/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.convert;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.aoju.bus.core.convert.AbstractConverter;
import org.aoju.bus.core.convert.ConverterRegistry;
import org.aoju.bus.core.toolkit.ArrayKit;
import org.aoju.bus.core.toolkit.ByteKit;
import org.aoju.bus.core.toolkit.IterKit;
import org.aoju.bus.core.toolkit.ObjectKit;
import org.aoju.bus.core.toolkit.StringKit;

public class ArrayConverter
extends AbstractConverter<Object> {
    private static final long serialVersionUID = 1L;
    private final Class<?> targetType;
    private final Class<?> targetComponentType;

    public ArrayConverter(Class<?> targetType) {
        if (null == targetType) {
            targetType = Object[].class;
        }
        if (targetType.isArray()) {
            this.targetType = targetType;
            this.targetComponentType = targetType.getComponentType();
        } else {
            this.targetComponentType = targetType;
            this.targetType = ArrayKit.getArrayType(targetType);
        }
    }

    @Override
    protected Object convertInternal(Object value) {
        return value.getClass().isArray() ? this.convertArrayToArray(value) : this.convertObjectToArray(value);
    }

    @Override
    public Class getTargetType() {
        return this.targetType;
    }

    private Object convertArrayToArray(Object array) {
        Class<?> valueComponentType = ArrayKit.getComponentType(array);
        if (valueComponentType == this.targetComponentType) {
            return array;
        }
        int len = ArrayKit.getLength(array);
        Object result = Array.newInstance(this.targetComponentType, len);
        ConverterRegistry converter = ConverterRegistry.getInstance();
        for (int i = 0; i < len; ++i) {
            Array.set(result, i, converter.convert(this.targetComponentType, Array.get(array, i)));
        }
        return result;
    }

    private Object convertObjectToArray(Object value) {
        Object[] result;
        if (value instanceof CharSequence) {
            if (this.targetComponentType == Character.TYPE || this.targetComponentType == Character.class) {
                return this.convertArrayToArray(value.toString().toCharArray());
            }
            String[] strings = StringKit.splitToArray(value.toString(), ",");
            return this.convertArrayToArray(strings);
        }
        ConverterRegistry converter = ConverterRegistry.getInstance();
        if (value instanceof List) {
            List list = (List)value;
            result = Array.newInstance(this.targetComponentType, list.size());
            for (int i = 0; i < list.size(); ++i) {
                Array.set(result, i, converter.convert(this.targetComponentType, list.get(i)));
            }
        } else if (value instanceof Collection) {
            Collection collection = (Collection)value;
            result = Array.newInstance(this.targetComponentType, collection.size());
            int i = 0;
            for (Object element : collection) {
                Array.set(result, i, converter.convert(this.targetComponentType, element));
                ++i;
            }
        } else if (value instanceof Iterable) {
            List list = IterKit.toList((Iterable)value);
            result = Array.newInstance(this.targetComponentType, list.size());
            for (int i = 0; i < list.size(); ++i) {
                Array.set(result, i, converter.convert(this.targetComponentType, list.get(i)));
            }
        } else if (value instanceof Iterator) {
            List list = IterKit.toList((Iterator)value);
            result = Array.newInstance(this.targetComponentType, list.size());
            for (int i = 0; i < list.size(); ++i) {
                Array.set(result, i, converter.convert(this.targetComponentType, list.get(i)));
            }
        } else {
            result = value instanceof Number && Byte.TYPE == this.targetComponentType ? (Object[])ByteKit.getBytes((Number)value) : (value instanceof Serializable && Byte.TYPE == this.targetComponentType ? (Object[])ObjectKit.serialize(value) : this.convertToSingleElementArray(value));
        }
        return result;
    }

    private Object[] convertToSingleElementArray(Object value) {
        Object[] singleElementArray = ArrayKit.newArray(this.targetComponentType, 1);
        singleElementArray[0] = ConverterRegistry.getInstance().convert(this.targetComponentType, value);
        return singleElementArray;
    }
}

