/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.date;

import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.aoju.bus.core.date.DateTime;
import org.aoju.bus.core.date.Formatter;
import org.aoju.bus.core.toolkit.StringKit;

public class Converter
extends Formatter {
    public static Date toDate(LocalDateTime localDateTime) {
        return Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date toDate(LocalDate localDate) {
        return Date.from(localDate.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date toDate(LocalTime localTime) {
        return Date.from(LocalDate.now().atTime(localTime).atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date toDate(Instant instant) {
        return Date.from(instant);
    }

    public static Date toDate(long epochMilli) {
        return new Date(epochMilli);
    }

    public static Date toDate(ZonedDateTime zonedDateTime) {
        return Date.from(zonedDateTime.toInstant());
    }

    public static Date toDate(YearMonth yearMonth, int dayOfMonth) {
        return Converter.toDate(yearMonth.atDay(dayOfMonth));
    }

    public static Date toDateStartOfMonth(YearMonth yearMonth) {
        return Converter.toDate(yearMonth, 1);
    }

    public static Date toDateEndOfMonth(YearMonth yearMonth) {
        return Converter.toDate(yearMonth.atEndOfMonth());
    }

    public static LocalDateTime toLocalDateTime(Date date) {
        return Instant.ofEpochMilli(date.getTime()).atZone(ZoneId.systemDefault()).toLocalDateTime();
    }

    public static LocalDateTime toLocalDateTime(Timestamp timestamp) {
        return timestamp.toLocalDateTime();
    }

    public static LocalDateTime toLocalDateTime(LocalDate localDate) {
        return localDate.atStartOfDay();
    }

    public static LocalDateTime toLocalDateTime(LocalTime localTime) {
        return LocalDate.now().atTime(localTime);
    }

    public static LocalDateTime toLocalDateTime(Instant instant) {
        return LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
    }

    public static LocalDateTime toLocalDateTime(long epochMilli) {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(epochMilli), ZoneId.systemDefault());
    }

    public static LocalDateTime toLocalDateTime(TemporalAccessor temporal) {
        return LocalDateTime.from(temporal);
    }

    public static LocalDateTime toLocalDateTime(ZonedDateTime zonedDateTime) {
        return zonedDateTime.toLocalDateTime();
    }

    public static LocalDate toLocalDate(Date date) {
        return Converter.toLocalDateTime(date).toLocalDate();
    }

    public static LocalDate toLocalDate(LocalDateTime localDateTime) {
        return localDateTime.toLocalDate();
    }

    public static LocalDate toLocalDate(Instant instant) {
        return Converter.toLocalDateTime(instant).toLocalDate();
    }

    public static LocalDate toLocalDate(long epochMilli) {
        return Converter.toLocalDateTime(epochMilli).toLocalDate();
    }

    public static LocalDate toLocalDate(TemporalAccessor temporal) {
        return LocalDate.from(temporal);
    }

    public static LocalDate toLocalDate(ZonedDateTime zonedDateTime) {
        return zonedDateTime.toLocalDate();
    }

    public static LocalDate toLocalDate(YearMonth yearMonth, int dayOfMonth) {
        return yearMonth.atDay(dayOfMonth);
    }

    public static LocalDate toLocalDateStartOfMonth(YearMonth yearMonth) {
        return Converter.toLocalDate(yearMonth, 1);
    }

    public static LocalDate toLocalDateEndOfMonth(YearMonth yearMonth) {
        return yearMonth.atEndOfMonth();
    }

    public static LocalTime toLocalTime(Date date) {
        return Converter.toLocalDateTime(date).toLocalTime();
    }

    public static LocalTime toLocalTime(LocalDateTime localDateTime) {
        return localDateTime.toLocalTime();
    }

    public static LocalTime toLocalTime(Instant instant) {
        return Converter.toLocalDateTime(instant).toLocalTime();
    }

    public static LocalTime toLocalTime(TemporalAccessor temporal) {
        return LocalTime.from(temporal);
    }

    public static LocalTime toLocalTime(ZonedDateTime zonedDateTime) {
        return zonedDateTime.toLocalTime();
    }

    public static Instant toInstant(Date date) {
        return date.toInstant();
    }

    public static Instant toInstant(Timestamp timestamp) {
        return timestamp.toInstant();
    }

    public static Instant toInstant(LocalDateTime localDateTime) {
        return localDateTime.atZone(ZoneId.systemDefault()).toInstant();
    }

    public static Instant toInstant(LocalDate localDate) {
        return Converter.toLocalDateTime(localDate).atZone(ZoneId.systemDefault()).toInstant();
    }

    public static Instant toInstant(Calendar calendar) {
        return null == calendar ? null : calendar.toInstant();
    }

    public static Instant toInstant(LocalTime localTime) {
        return Converter.toLocalDateTime(localTime).atZone(ZoneId.systemDefault()).toInstant();
    }

    public static Instant toInstant(long epochMilli) {
        return Instant.ofEpochMilli(epochMilli);
    }

    public static Instant toInstant(ZonedDateTime zonedDateTime) {
        return zonedDateTime.toInstant();
    }

    public static Instant toInstant(TemporalAccessor temporalAccessor) {
        if (null == temporalAccessor) {
            return null;
        }
        Instant result = temporalAccessor instanceof Instant ? (Instant)temporalAccessor : (temporalAccessor instanceof LocalDateTime ? ((LocalDateTime)temporalAccessor).atZone(ZoneId.systemDefault()).toInstant() : (temporalAccessor instanceof ZonedDateTime ? ((ZonedDateTime)temporalAccessor).toInstant() : (temporalAccessor instanceof OffsetDateTime ? ((OffsetDateTime)temporalAccessor).toInstant() : (temporalAccessor instanceof LocalDate ? ((LocalDate)temporalAccessor).atStartOfDay(ZoneId.systemDefault()).toInstant() : (temporalAccessor instanceof LocalTime ? ((LocalTime)temporalAccessor).atDate(LocalDate.now()).atZone(ZoneId.systemDefault()).toInstant() : (temporalAccessor instanceof OffsetTime ? ((OffsetTime)temporalAccessor).atDate(LocalDate.now()).toInstant() : Converter.toInstant(DateTime.of(temporalAccessor))))))));
        return result;
    }

    public static Calendar toCalendar(long millis) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(millis);
        return cal;
    }

    public static Calendar toCalendar(Date date) {
        if (date instanceof DateTime) {
            return ((DateTime)date).toCalendar();
        }
        if (date instanceof Date) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            return calendar;
        }
        return Converter.toCalendar(date.getTime());
    }

    public static Calendar toCalendar(Date date, TimeZone timeZone) {
        Calendar calendar = Calendar.getInstance(timeZone);
        calendar.setTime(date);
        return calendar;
    }

    public static long toEpochMilli(Date date) {
        return date.getTime();
    }

    public static long toEpochMilli(Timestamp timestamp) {
        return timestamp.getTime();
    }

    public static long toEpochMilli(LocalDateTime localDateTime) {
        return Converter.toInstant(localDateTime).toEpochMilli();
    }

    public static long toEpochMilli(LocalDate localDate) {
        return Converter.toInstant(localDate).toEpochMilli();
    }

    public static long toEpochMilli(Instant instant) {
        return instant.toEpochMilli();
    }

    public static long toEpochMilli(ZonedDateTime zonedDateTime) {
        return zonedDateTime.toInstant().toEpochMilli();
    }

    public static ZonedDateTime toZonedDateTime(Date date) {
        return Instant.ofEpochMilli(date.getTime()).atZone(ZoneId.systemDefault());
    }

    public static ZonedDateTime toZonedDateTime(Date date, String zoneId) {
        return Converter.toZonedDateTime(date, ZoneId.of(zoneId));
    }

    public static ZonedDateTime toZonedDateTime(Date date, ZoneId zone) {
        return Instant.ofEpochMilli(date.getTime()).atZone(zone);
    }

    public static ZonedDateTime toZonedDateTime(LocalDateTime localDateTime) {
        return localDateTime.atZone(ZoneId.systemDefault());
    }

    public static ZonedDateTime toZonedDateTime(LocalDateTime localDateTime, String zoneId) {
        return localDateTime.atZone(ZoneId.of(zoneId));
    }

    public static ZonedDateTime toZonedDateTime(LocalDate localDate) {
        return localDate.atStartOfDay().atZone(ZoneId.systemDefault());
    }

    public static ZonedDateTime toZonedDateTime(LocalTime localTime) {
        return LocalDate.now().atTime(localTime).atZone(ZoneId.systemDefault());
    }

    public static ZonedDateTime toZonedDateTime(Instant instant) {
        return LocalDateTime.ofInstant(instant, ZoneId.systemDefault()).atZone(ZoneId.systemDefault());
    }

    public static ZonedDateTime toZonedDateTime(long epochMilli) {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(epochMilli), ZoneId.systemDefault()).atZone(ZoneId.systemDefault());
    }

    public static ZonedDateTime toZonedDateTime(TemporalAccessor temporal) {
        return LocalDateTime.from(temporal).atZone(ZoneId.systemDefault());
    }

    public static YearMonth toYearMonth(Date date) {
        LocalDate localDate = Converter.toLocalDate(date);
        return YearMonth.of(localDate.getYear(), localDate.getMonthValue());
    }

    public static YearMonth toYearMonth(LocalDateTime localDateTime) {
        LocalDate localDate = Converter.toLocalDate(localDateTime);
        return YearMonth.of(localDate.getYear(), localDate.getMonthValue());
    }

    public static YearMonth toYearMonth(LocalDate localDate) {
        return YearMonth.of(localDate.getYear(), localDate.getMonthValue());
    }

    public static YearMonth toYearMonth(Instant instant) {
        LocalDate localDate = Converter.toLocalDate(instant);
        return YearMonth.of(localDate.getYear(), localDate.getMonthValue());
    }

    public static YearMonth toYearMonth(ZonedDateTime zonedDateTime) {
        LocalDate localDate = Converter.toLocalDate(zonedDateTime);
        return YearMonth.of(localDate.getYear(), localDate.getMonthValue());
    }

    public static Timestamp toTimestamp(Date date) {
        return new Timestamp(date.getTime());
    }

    public static Timestamp toTimestamp(LocalDateTime localDateTime) {
        return Timestamp.valueOf(localDateTime);
    }

    public static Timestamp toTimestamp(Instant instant) {
        return Timestamp.from(instant);
    }

    public static Timestamp toTimestamp(long epochMilli) {
        return new Timestamp(epochMilli);
    }

    public static String toTime(int seconds) {
        if (seconds < 0) {
            throw new IllegalArgumentException("Seconds must be a positive number!");
        }
        int hour = seconds / 3600;
        int other = seconds % 3600;
        int minute = other / 60;
        int second = other % 60;
        StringBuilder sb = new StringBuilder();
        if (hour < 10) {
            sb.append("0");
        }
        sb.append(hour);
        sb.append(":");
        if (minute < 10) {
            sb.append("0");
        }
        sb.append(minute);
        sb.append(":");
        if (second < 10) {
            sb.append("0");
        }
        sb.append(second);
        return sb.toString();
    }

    public static int toSecond(String time) {
        if (StringKit.isEmpty(time)) {
            return 0;
        }
        List<String> hms = StringKit.splitTrim(time, ":", 3, true);
        int lastIndex = hms.size() - 1;
        int result = 0;
        for (int i = lastIndex; i >= 0; --i) {
            result = (int)((double)result + (double)Integer.parseInt(hms.get(i)) * Math.pow(60.0, lastIndex - i));
        }
        return result;
    }
}

