/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.io.file;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.aoju.bus.core.io.LineHandler;
import org.aoju.bus.core.io.file.FileWrapper;
import org.aoju.bus.core.lang.Charset;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.toolkit.FileKit;
import org.aoju.bus.core.toolkit.IoKit;
import org.aoju.bus.core.toolkit.StringKit;

public class FileReader
extends FileWrapper {
    public FileReader(File file, java.nio.charset.Charset charset) {
        super(file, charset);
        this.checkFile();
    }

    public FileReader(File file, String charset) {
        this(file, Charset.charset(charset));
    }

    public FileReader(String filePath, java.nio.charset.Charset charset) {
        this(FileKit.file(filePath), charset);
    }

    public FileReader(String filePath, String charset) {
        this(FileKit.file(filePath), Charset.charset(charset));
    }

    public FileReader(File file) {
        this(file, DEFAULT_CHARSET);
    }

    public FileReader(String filePath) {
        this(filePath, DEFAULT_CHARSET);
    }

    public static FileReader create(File file, java.nio.charset.Charset charset) {
        return new FileReader(file, charset);
    }

    public static FileReader create(File file) {
        return new FileReader(file);
    }

    public byte[] readBytes() throws InstrumentException {
        long len = this.file.length();
        if (len >= Integer.MAX_VALUE) {
            throw new InstrumentException("File is larger then max array size");
        }
        byte[] bytes = new byte[(int)len];
        FileInputStream in = null;
        try {
            in = new FileInputStream(this.file);
            int readLength = in.read(bytes);
            if ((long)readLength < len) {
                throw new IOException(StringKit.format("File length is [{}] but read [{}]!", len, readLength));
            }
        }
        catch (Exception e) {
            try {
                throw new InstrumentException(e);
            }
            catch (Throwable throwable) {
                IoKit.close(in);
                throw throwable;
            }
        }
        IoKit.close(in);
        return bytes;
    }

    public String readString() throws InstrumentException {
        return new String(this.readBytes(), this.charset);
    }

    public <T extends Collection<String>> T readLines(T collection) throws InstrumentException {
        T t;
        BufferedReader reader = null;
        try {
            String line;
            reader = FileKit.getReader(this.file, this.charset);
            while (null != (line = reader.readLine())) {
                collection.add((String)line);
            }
            t = collection;
        }
        catch (IOException e) {
            try {
                throw new InstrumentException(e);
            }
            catch (Throwable throwable) {
                IoKit.close(reader);
                throw throwable;
            }
        }
        IoKit.close(reader);
        return t;
    }

    public void readLines(LineHandler lineHandler) throws InstrumentException {
        BufferedReader reader = null;
        try {
            reader = FileKit.getReader(this.file, this.charset);
            IoKit.readLines((Reader)reader, lineHandler);
        }
        catch (Throwable throwable) {
            IoKit.close(reader);
            throw throwable;
        }
        IoKit.close(reader);
    }

    public List<String> readLines() throws InstrumentException {
        return this.readLines(new ArrayList());
    }

    public <T> T read(ReaderHandler<T> readerHandler) throws InstrumentException {
        T result;
        BufferedReader reader = null;
        try {
            reader = FileKit.getReader(this.file, this.charset);
            result = readerHandler.handle(reader);
        }
        catch (IOException e) {
            try {
                throw new InstrumentException(e);
            }
            catch (Throwable throwable) {
                IoKit.close(reader);
                throw throwable;
            }
        }
        IoKit.close(reader);
        return result;
    }

    public BufferedReader getReader() throws InstrumentException {
        return IoKit.getReader((InputStream)this.getInputStream(), this.charset);
    }

    public BufferedInputStream getInputStream() throws InstrumentException {
        try {
            return new BufferedInputStream(new FileInputStream(this.file));
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
    }

    public long writeToStream(OutputStream out) throws InstrumentException {
        return this.writeToStream(out, false);
    }

    /*
     * Exception decompiling
     */
    public long writeToStream(OutputStream out, boolean isClose) throws InstrumentException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void checkFile() throws InstrumentException {
        if (!this.file.exists()) {
            throw new InstrumentException("File not exist : " + this.file);
        }
        if (!this.file.isFile()) {
            throw new InstrumentException("Not a file :" + this.file);
        }
    }

    public static interface ReaderHandler<T> {
        public T handle(BufferedReader var1) throws IOException;
    }
}

