/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.lang;

import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.aoju.bus.core.lang.function.VoidFunc0;
import org.aoju.bus.core.toolkit.StringKit;

public class Optional<T> {
    private static final Optional<?> EMPTY = new Optional<Object>(null);
    private final T value;

    private Optional(T value) {
        this.value = value;
    }

    public static <T> Optional<T> empty() {
        return EMPTY;
    }

    public static <T> Optional<T> of(T value) {
        return new Optional<T>(Objects.requireNonNull(value));
    }

    public static <T> Optional<T> ofNullable(T value) {
        return value == null ? Optional.empty() : new Optional<T>(value);
    }

    public static <T> Optional<T> ofBlankAble(T value) {
        return StringKit.isBlank(value) ? Optional.empty() : new Optional<T>(value);
    }

    public T get() {
        return this.value;
    }

    public Optional<T> set(T value) {
        return Optional.ofNullable(value);
    }

    public boolean isPresent() {
        return this.value != null;
    }

    public boolean isEmpty() {
        return this.value == null;
    }

    public void ifPresent(Consumer<? super T> action) {
        if (this.value != null) {
            action.accept(this.value);
        }
    }

    public void ifPresentOrElse(Consumer<? super T> action, VoidFunc0 emptyAction) {
        if (this.value != null) {
            action.accept(this.value);
        } else {
            emptyAction.callWithRuntimeException();
        }
    }

    public Optional<T> filter(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate);
        if (this.isEmpty()) {
            return this;
        }
        return predicate.test(this.value) ? this : Optional.empty();
    }

    public <U> Optional<U> map(Function<? super T, ? extends U> mapper) {
        Objects.requireNonNull(mapper);
        if (this.isEmpty()) {
            return Optional.empty();
        }
        return Optional.ofNullable(mapper.apply(this.value));
    }

    public <U> Optional<U> flatMap(Function<? super T, ? extends Optional<? extends U>> mapper) {
        Objects.requireNonNull(mapper);
        if (this.isEmpty()) {
            return Optional.empty();
        }
        return Optional.ofNullable(mapper.apply(this.value).orElse(null));
    }

    public <U> Optional<U> flattedMap(Function<? super T, ? extends java.util.Optional<? extends U>> mapper) {
        Objects.requireNonNull(mapper);
        if (this.isEmpty()) {
            return Optional.empty();
        }
        java.util.Optional<U> r = mapper.apply(this.value);
        return Objects.requireNonNull(Optional.ofNullable(r.orElse(null)));
    }

    public Optional<T> peek(Consumer<T> action) throws NullPointerException {
        Objects.requireNonNull(action);
        if (this.isEmpty()) {
            return Optional.empty();
        }
        action.accept(this.value);
        return this;
    }

    public final Optional<T> peeks(Consumer<T> ... actions) throws NullPointerException {
        return Stream.of(actions).reduce(this, Optional::peek, (opts, opt) -> null);
    }

    public Optional<T> or(Supplier<? extends Optional<? extends T>> supplier) {
        Objects.requireNonNull(supplier);
        if (this.isPresent()) {
            return this;
        }
        Optional<? extends T> r = supplier.get();
        return Objects.requireNonNull(r);
    }

    public Stream<T> stream() {
        if (this.isEmpty()) {
            return Stream.empty();
        }
        return Stream.of(this.value);
    }

    public T orElse(T other) {
        return this.value != null ? this.value : other;
    }

    public T orElseGet(Supplier<? extends T> supplier) {
        return this.value != null ? this.value : supplier.get();
    }

    public T orElseThrow() {
        if (this.value == null) {
            throw new NoSuchElementException("No value present");
        }
        return this.value;
    }

    public <X extends Throwable> T orElseThrow(Supplier<? extends X> exceptionSupplier) throws X {
        if (this.value != null) {
            return this.value;
        }
        throw (Throwable)exceptionSupplier.get();
    }

    public <X extends Throwable> T orElseThrow(Function<String, ? extends X> exceptionFunction, String message) throws X {
        if (this.value != null) {
            return this.value;
        }
        throw (Throwable)exceptionFunction.apply(message);
    }

    public java.util.Optional<T> toOptional() {
        return java.util.Optional.ofNullable(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Optional)) {
            return false;
        }
        Optional other = (Optional)obj;
        return Objects.equals(this.value, other.value);
    }

    public int hashCode() {
        return Objects.hashCode(this.value);
    }

    public String toString() {
        return this.value != null ? this.value.toString() : null;
    }
}

