/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.loader;

import java.security.SecureClassLoader;
import java.util.HashMap;
import java.util.Map;
import org.aoju.bus.core.io.resource.Resource;
import org.aoju.bus.core.toolkit.ClassKit;
import org.aoju.bus.core.toolkit.ObjectKit;

public class ClazzLoader<T extends Resource>
extends SecureClassLoader {
    private final Map<String, T> resourceMap;

    public ClazzLoader(ClassLoader parentClassLoader, Map<String, T> resourceMap) {
        super(ObjectKit.defaultIfNull(parentClassLoader, ClassKit.getClassLoader()));
        this.resourceMap = ObjectKit.defaultIfNull(resourceMap, new HashMap());
    }

    public ClazzLoader<T> addResource(T resource) {
        this.resourceMap.put(resource.getName(), resource);
        return this;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Resource resource = (Resource)this.resourceMap.get(name);
        if (null != resource) {
            byte[] bytes = resource.readBytes();
            return this.defineClass(name, bytes, 0, bytes.length);
        }
        return super.findClass(name);
    }
}

