/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.toolkit;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.text.Normalizer;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.lang.Charset;
import org.aoju.bus.core.lang.RegEx;
import org.aoju.bus.core.toolkit.ArrayKit;

public class CharsKit {
    public static boolean isAscii(char ch) {
        return ch < '\u0080';
    }

    public static boolean isAsciiPrintable(char ch) {
        return ch >= ' ' && ch < '\u007f';
    }

    public static boolean isAsciiControl(char ch) {
        return ch < ' ' || ch == '\u007f';
    }

    public static boolean isLetter(char ch) {
        return CharsKit.isLetterUpper(ch) || CharsKit.isLetterLower(ch);
    }

    public static boolean isLetterUpper(char ch) {
        return ch >= 'A' && ch <= 'Z';
    }

    public static boolean isLetterLower(char ch) {
        return ch >= 'a' && ch <= 'z';
    }

    public static boolean isNumber(char ch) {
        return ch >= '0' && ch <= '9';
    }

    public static boolean isHexChar(char c) {
        return CharsKit.isNumber(c) || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
    }

    public static boolean isLetterOrNumber(char ch) {
        return CharsKit.isLetter(ch) || CharsKit.isNumber(ch);
    }

    public static boolean isCharClass(Class<?> clazz) {
        return clazz == Character.class || clazz == Character.TYPE;
    }

    public static boolean isChar(Object value) {
        return value instanceof Character || value.getClass() == Character.TYPE;
    }

    public static boolean isBlankChar(char c) {
        return CharsKit.isBlankChar((int)c);
    }

    public static boolean isBlankChar(int c) {
        return Character.isWhitespace(c) || Character.isSpaceChar(c) || c == 65279 || c == 8234 || c == 0;
    }

    public static boolean isBlank(CharSequence text) {
        int length;
        if (text == null || (length = text.length()) == 0) {
            return true;
        }
        for (int i = 0; i < length; ++i) {
            if (CharsKit.isBlankChar(text.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(CharSequence text) {
        return false == CharsKit.isBlank(text);
    }

    public static boolean isAllBlank(CharSequence ... texts) {
        if (ArrayKit.isEmpty(texts)) {
            return true;
        }
        for (CharSequence text : texts) {
            if (!CharsKit.isNotBlank(text)) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmpty(CharSequence text) {
        return text == null || text.length() == 0;
    }

    public static boolean isNotEmpty(CharSequence text) {
        return false == CharsKit.isEmpty(text);
    }

    public static boolean isAllEmpty(CharSequence ... texts) {
        if (ArrayKit.isEmpty(texts)) {
            return true;
        }
        for (CharSequence text : texts) {
            if (!CharsKit.isNotEmpty(text)) continue;
            return false;
        }
        return true;
    }

    public static boolean isAllNotEmpty(CharSequence ... args) {
        return false == CharsKit.hasEmpty(args);
    }

    public static boolean isAllNotBlank(CharSequence ... args) {
        return false == CharsKit.hasBlank(args);
    }

    public static boolean isNullOrUndefined(CharSequence text) {
        if (null == text) {
            return true;
        }
        return CharsKit.isNullOrUndefinedStr(text);
    }

    public static boolean isEmptyOrUndefined(CharSequence text) {
        if (CharsKit.isEmpty(text)) {
            return true;
        }
        return CharsKit.isNullOrUndefinedStr(text);
    }

    public static boolean isBlankOrUndefined(CharSequence text) {
        if (CharsKit.isBlank(text)) {
            return true;
        }
        return CharsKit.isNullOrUndefinedStr(text);
    }

    private static boolean isNullOrUndefinedStr(CharSequence text) {
        String strString = text.toString().trim();
        return "null".equals(strString) || "undefined".equals(strString);
    }

    private static boolean isNotNullAndNotUndefinedStr(CharSequence str) {
        String strString = str.toString().trim();
        return !"null".equals(strString) && !"undefined".equals(strString);
    }

    public static boolean hasBlank(CharSequence ... texts) {
        if (ArrayKit.isEmpty(texts)) {
            return true;
        }
        for (CharSequence text : texts) {
            if (!CharsKit.isBlank(text)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasEmpty(CharSequence ... texts) {
        if (ArrayKit.isEmpty(texts)) {
            return true;
        }
        for (CharSequence text : texts) {
            if (!CharsKit.isEmpty(text)) continue;
            return true;
        }
        return false;
    }

    public static boolean isEmoji(char c) {
        return false == (c == '\u0000' || c == '\t' || c == '\n' || c == '\r' || c >= ' ' && c <= '\ud7ff' || c >= '\ue000' && c <= '\ufffd' || c >= '\u10000' && c <= '\u10ffff');
    }

    public static boolean equals(char c1, char c2, boolean ignoreCase) {
        if (ignoreCase) {
            return Character.toLowerCase(c1) == Character.toLowerCase(c2);
        }
        return c1 == c2;
    }

    public static int count(CharSequence content, CharSequence strForSearch) {
        if (CharsKit.hasEmpty(content, strForSearch) || strForSearch.length() > content.length()) {
            return 0;
        }
        int count = 0;
        int idx = 0;
        String content2 = content.toString();
        String strForSearch2 = strForSearch.toString();
        while ((idx = content2.indexOf(strForSearch2, idx)) > -1) {
            ++count;
            idx += strForSearch.length();
        }
        return count;
    }

    public static int count(CharSequence content, char charForSearch) {
        int count = 0;
        if (CharsKit.isEmpty(content)) {
            return 0;
        }
        int contentLength = content.length();
        for (int i = 0; i < contentLength; ++i) {
            if (charForSearch != content.charAt(i)) continue;
            ++count;
        }
        return count;
    }

    public static String toString(char c) {
        String[] CACHE = new String[128];
        for (char i = '\u0000'; i < '\u0080'; i = (char)(i + '\u0001')) {
            CACHE[i] = String.valueOf(i);
        }
        return c < '\u0080' ? CACHE[c] : String.valueOf(c);
    }

    public static boolean isFileSeparator(char c) {
        return '/' == c || '\\' == c;
    }

    public static int compare(char x, char y) {
        return x - y;
    }

    public static char[] getChars(byte[] bytes) {
        ByteBuffer bb = ByteBuffer.allocate(bytes.length);
        bb.put(bytes).flip();
        CharBuffer cb = Charset.UTF_8.decode(bb);
        return cb.array();
    }

    public static char byteToChar(byte[] b) {
        int hi = (b[0] & 0xFF) << 8;
        int lo = b[1] & 0xFF;
        return (char)(hi | lo);
    }

    public static char toCloseChar(char c) {
        int result = c;
        if (c >= 49 && c <= 57) {
            result = 9312 + c - 49;
        } else if (c >= 65 && c <= 90) {
            result = 9398 + c - 65;
        } else if (c >= 97 && c <= 122) {
            result = 9424 + c - 97;
        }
        return (char)result;
    }

    public static char toCloseByNumber(int number) {
        if (number > 20) {
            throw new IllegalArgumentException("Number must be [1-20]");
        }
        return (char)(9312 + number - 1);
    }

    public static boolean startWithNumber(CharSequence text) {
        return CharsKit.isNotBlank(text) && RegEx.NUMBERS.matcher(text.subSequence(0, 1)).find();
    }

    public static boolean startWithGeneral(CharSequence text) {
        return CharsKit.isNotBlank(text) && RegEx.GENERAL.matcher(text.subSequence(0, 1)).find();
    }

    public static boolean startWithWord(CharSequence text) {
        return CharsKit.isNotBlank(text) && RegEx.WORD.matcher(text.subSequence(0, 1)).find();
    }

    public static boolean startWithChinese(CharSequence text) {
        return CharsKit.isNotBlank(text) && RegEx.CHINESES.matcher(text.subSequence(0, 1)).find();
    }

    public static boolean isCharEquals(CharSequence str) {
        Assert.notEmpty(str, "Str to check must be not empty!", new Object[0]);
        return CharsKit.count(str, str.charAt(0)) == str.length();
    }

    public static String normalize(CharSequence str) {
        return Normalizer.normalize(str, Normalizer.Form.NFC);
    }
}

