/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.toolkit;

import java.io.StringReader;
import java.io.StringWriter;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.aoju.bus.core.convert.Convert;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.lang.Filter;
import org.aoju.bus.core.lang.Normal;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.lang.function.Func1;
import org.aoju.bus.core.text.NamingCase;
import org.aoju.bus.core.text.Similarity;
import org.aoju.bus.core.text.TextBuilder;
import org.aoju.bus.core.text.TextFormatter;
import org.aoju.bus.core.text.TextSplitter;
import org.aoju.bus.core.toolkit.ArrayKit;
import org.aoju.bus.core.toolkit.CharsKit;
import org.aoju.bus.core.toolkit.HexKit;
import org.aoju.bus.core.toolkit.MapKit;
import org.aoju.bus.core.toolkit.MathKit;
import org.aoju.bus.core.toolkit.ObjectKit;
import org.aoju.bus.core.toolkit.PatternKit;
import org.aoju.bus.core.toolkit.TextKit;

public class StringKit {
    private static final int INDEX_NOT_FOUND = -1;
    private static final int PAD_LIMIT = 8192;

    public static String trim(CharSequence text) {
        return null == text ? null : StringKit.trim(text, 0);
    }

    public static String trim(CharSequence text, int mode) {
        int start;
        if (null == text) {
            return null;
        }
        int length = text.length();
        int end = length;
        if (mode <= 0) {
            for (start = 0; start < end && CharsKit.isBlankChar(text.charAt(start)); ++start) {
            }
        }
        if (mode >= 0) {
            while (start < end && CharsKit.isBlankChar(text.charAt(end - 1))) {
                --end;
            }
        }
        if (start > 0 || end < length) {
            return text.toString().substring(start, end);
        }
        return text.toString();
    }

    public static String[] trim(String[] array) {
        if (ArrayKit.isEmpty(array)) {
            return array;
        }
        String[] resultArray = new String[array.length];
        for (int i = 0; i < array.length; ++i) {
            String param = array[i];
            resultArray[i] = StringKit.trim(param);
        }
        return resultArray;
    }

    public static String trim(CharSequence text, int mode, Predicate<Character> predicate) {
        String result;
        if (text == null) {
            result = null;
        } else {
            int start;
            int length = text.length();
            int end = length;
            if (mode <= 0) {
                for (start = 0; start < end && predicate.test(Character.valueOf(text.charAt(start))); ++start) {
                }
            }
            if (mode >= 0) {
                while (start < end && predicate.test(Character.valueOf(text.charAt(end - 1)))) {
                    --end;
                }
            }
            result = start > 0 || end < length ? text.toString().substring(start, end) : text.toString();
        }
        return result;
    }

    public static String trimToNull(CharSequence text) {
        String trimStr = StringKit.trim(text);
        return "".equals(trimStr) ? null : trimStr;
    }

    public static String trimToEmpty(String text) {
        return null == text ? "" : text.trim();
    }

    public static boolean isAllCharMatch(CharSequence value, org.aoju.bus.core.lang.Matcher<Character> matcher) {
        if (StringKit.isBlank(value)) {
            return false;
        }
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            if (matcher.match(Character.valueOf(value.charAt(i)))) continue;
            return false;
        }
        return true;
    }

    public static boolean isBlank(CharSequence text) {
        int length;
        if (null == text || (length = text.length()) == 0) {
            return true;
        }
        for (int i = 0; i < length; ++i) {
            if (CharsKit.isBlankChar(text.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isBlank(Object obj) {
        if (null == obj) {
            return true;
        }
        if (obj instanceof CharSequence) {
            return StringKit.isBlank((CharSequence)obj);
        }
        return false;
    }

    public static boolean isNotBlank(CharSequence text) {
        return false == StringKit.isBlank(text);
    }

    public static boolean isAllNotBlank(CharSequence ... args) {
        return false == StringKit.hasBlank(args);
    }

    public static boolean hasBlank(CharSequence ... texts) {
        if (ArrayKit.isEmpty(texts)) {
            return true;
        }
        for (CharSequence text : texts) {
            if (!StringKit.isBlank(text)) continue;
            return true;
        }
        return false;
    }

    public static boolean isNoneBlank(CharSequence ... texts) {
        return !StringKit.isAnyBlank(texts);
    }

    public static boolean isAllBlank(CharSequence ... texts) {
        if (ArrayKit.isEmpty(texts)) {
            return true;
        }
        for (CharSequence text : texts) {
            if (!StringKit.isNotBlank(text)) continue;
            return false;
        }
        return true;
    }

    public static boolean isAnyBlank(CharSequence ... texts) {
        if (ArrayKit.isEmpty(texts)) {
            return false;
        }
        for (CharSequence text : texts) {
            if (!StringKit.isBlank(text)) continue;
            return true;
        }
        return false;
    }

    public static boolean isEmpty(CharSequence text) {
        return null == text || text.length() == 0;
    }

    public static boolean isAllEmpty(CharSequence ... texts) {
        if (ArrayKit.isEmpty(texts)) {
            return true;
        }
        for (CharSequence text : texts) {
            if (!StringKit.isNotEmpty(text)) continue;
            return false;
        }
        return true;
    }

    public static boolean isAllNotEmpty(CharSequence ... texts) {
        return false == StringKit.hasEmpty(texts);
    }

    public static boolean hasEmpty(CharSequence ... texts) {
        if (ArrayKit.isEmpty(texts)) {
            return true;
        }
        for (CharSequence text : texts) {
            if (!StringKit.isEmpty(text)) continue;
            return true;
        }
        return false;
    }

    public static boolean isNotEmpty(CharSequence text) {
        return false == StringKit.isEmpty(text);
    }

    public static String emptyIfNull(CharSequence text) {
        return StringKit.nullToEmpty(text);
    }

    public static boolean emptyIfString(Object obj) {
        if (null == obj) {
            return true;
        }
        if (obj instanceof CharSequence) {
            return 0 == ((CharSequence)obj).length();
        }
        return false;
    }

    public static String nullToEmpty(CharSequence text) {
        return StringKit.nullToDefault(text, "");
    }

    public static String nullToDefault(CharSequence text, String defaultStr) {
        return null == text ? defaultStr : text.toString();
    }

    public static String emptyToDefault(CharSequence text, String defaultStr) {
        return StringKit.isEmpty(text) ? defaultStr : text.toString();
    }

    public static String blankToDefault(CharSequence text, String defaultStr) {
        return StringKit.isBlank(text) ? defaultStr : text.toString();
    }

    public static String emptyToNull(CharSequence text) {
        return StringKit.isEmpty(text) ? null : text.toString();
    }

    public static boolean isNullOrUndefined(CharSequence text) {
        if (null == text) {
            return true;
        }
        return StringKit.isNullOrUndefinedStr(text);
    }

    public static boolean isEmptyOrUndefined(CharSequence text) {
        if (StringKit.isEmpty(text)) {
            return true;
        }
        return StringKit.isNullOrUndefinedStr(text);
    }

    public static boolean isBlankOrUndefined(CharSequence text) {
        if (StringKit.isBlank(text)) {
            return true;
        }
        return StringKit.isNullOrUndefinedStr(text);
    }

    private static boolean isNullOrUndefinedStr(CharSequence text) {
        String strString = text.toString().trim();
        return "null".equals(strString) || "undefined".equals(strString);
    }

    public static boolean areNotEmpty(String ... values) {
        boolean result = true;
        if (null != values && values.length != 0) {
            String[] var2 = values;
            int var3 = values.length;
            for (int var4 = 0; var4 < var3; ++var4) {
                String value = var2[var4];
                result &= !StringKit.isEmpty(value);
            }
        } else {
            result = false;
        }
        return result;
    }

    public static boolean isSubEquals(CharSequence str1, int start1, CharSequence str2, int start2, int length, boolean ignoreCase) {
        if (null == str1 || null == str2) {
            return false;
        }
        return str1.toString().regionMatches(ignoreCase, start1, str2.toString(), start2, length);
    }

    public static String toString(Object obj) {
        return StringKit.toString(obj, org.aoju.bus.core.lang.Charset.UTF_8);
    }

    public static String toString(CharSequence cs) {
        return null == cs ? null : cs.toString();
    }

    public static String toString(Object obj, String charset) {
        return StringKit.toString(obj, Charset.forName(charset));
    }

    public static String toString(String text, String defaultStr) {
        return null == text ? defaultStr : text;
    }

    public static String toString(Object obj, Charset charset) {
        if (ObjectKit.isEmpty(obj)) {
            return null;
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof byte[]) {
            return StringKit.toString((byte[])obj, charset);
        }
        if (obj instanceof Byte[]) {
            return StringKit.toString((Byte[])obj, charset);
        }
        if (obj instanceof ByteBuffer) {
            return StringKit.toString((ByteBuffer)obj, charset);
        }
        if (ArrayKit.isArray(obj)) {
            return ArrayKit.toString(obj);
        }
        return obj.toString();
    }

    public static String toString(byte[] bytes, String charset) {
        return StringKit.toString(bytes, StringKit.isBlank(charset) ? Charset.defaultCharset() : Charset.forName(charset));
    }

    public static String toString(byte[] data, Charset charset) {
        if (null == data) {
            return null;
        }
        if (null == charset) {
            return new String(data);
        }
        return new String(data, charset);
    }

    public static String toString(Byte[] bytes, String charset) {
        return StringKit.toString(bytes, StringKit.isBlank(charset) ? Charset.defaultCharset() : Charset.forName(charset));
    }

    public static String toString(Byte[] data, Charset charset) {
        if (null == data) {
            return null;
        }
        byte[] bytes = new byte[data.length];
        for (int i = 0; i < data.length; ++i) {
            Byte dataByte = data[i];
            bytes[i] = null == dataByte ? -1 : (int)dataByte.byteValue();
        }
        return StringKit.toString(bytes, charset);
    }

    public static String toString(ByteBuffer data, String charset) {
        if (null == data) {
            return null;
        }
        return StringKit.toString(data, Charset.forName(charset));
    }

    public static String toString(ByteBuffer data, Charset charset) {
        if (null == charset) {
            charset = Charset.defaultCharset();
        }
        return charset.decode(data).toString();
    }

    public static String toString(String[] values) {
        if (ArrayKit.isEmpty(values)) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (String value : values) {
            builder.append("," + value);
        }
        String parameter = builder.toString().trim();
        if (parameter.length() > 0) {
            return parameter.substring(1);
        }
        return "";
    }

    public static String toString(Class<?>[] parameterTypes) {
        if (ArrayKit.isEmpty(parameterTypes)) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (Class<?> clazz : parameterTypes) {
            builder.append("," + clazz.getCanonicalName());
        }
        String parameter = builder.toString().trim();
        if (parameter.length() > 0) {
            return parameter.substring(1);
        }
        return "";
    }

    public static boolean hasText(String text) {
        if (null == text || text.isEmpty()) {
            return false;
        }
        int strLen = text.length();
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(text.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean hasLength(String text) {
        return null != text && !text.isEmpty();
    }

    public static byte[] base64ToByte(String text) {
        try {
            if (null == text) {
                return null;
            }
            return Base64.getDecoder().decode(text);
        }
        catch (Exception e) {
            throw new InstrumentException(e);
        }
    }

    public static String base64ToString(String text) {
        try {
            if (null == text) {
                return null;
            }
            return new String(StringKit.base64ToByte(text), org.aoju.bus.core.lang.Charset.UTF_8);
        }
        catch (Exception e) {
            throw new InstrumentException(e);
        }
    }

    public static String base64ToString(String text, String charset) {
        try {
            if (null == text) {
                return null;
            }
            return new String(StringKit.base64ToByte(text), charset);
        }
        catch (Exception e) {
            throw new InstrumentException(e);
        }
    }

    public static String byteArrayToHex(byte[] byteArray) {
        char[] resultCharArray = new char[byteArray.length * 2];
        int index = 0;
        for (byte b : byteArray) {
            resultCharArray[index++] = Normal.DIGITS_16_LOWER[b >>> 4 & 0xF];
            resultCharArray[index++] = Normal.DIGITS_16_LOWER[b & 0xF];
        }
        return new String(resultCharArray);
    }

    public static byte[] hexStringToByte(String hex) {
        if (StringKit.isEmpty(hex)) {
            return Normal.EMPTY_BYTE_ARRAY;
        }
        byte[] bytes = new byte[hex.length() / 2];
        for (int i = 0; i < hex.length() / 2; ++i) {
            String subStr = hex.substring(i * 2, i * 2 + 2);
            bytes[i] = (byte)Integer.parseInt(subStr, 16);
        }
        return bytes;
    }

    public static String toUnicode(char c) {
        return HexKit.toUnicodeHex(c);
    }

    public static String toUnicode(int c) {
        return HexKit.toUnicodeHex(c);
    }

    public static String toUnicode(String input) {
        StringBuilder unicode = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            String hexStr = Integer.toHexString(c);
            while (hexStr.length() < 4) {
                hexStr = "0" + hexStr;
            }
            unicode.append("\\u" + hexStr);
        }
        return unicode.toString();
    }

    public static String toUnicode(String text, boolean isSkipAscii) {
        if (StringKit.isEmpty(text)) {
            return text;
        }
        int len = text.length();
        TextKit unicode = TextKit.create(text.length() * 6);
        for (int i = 0; i < len; ++i) {
            char c = text.charAt(i);
            if (isSkipAscii && CharsKit.isAsciiPrintable(c)) {
                unicode.append(c);
                continue;
            }
            unicode.append(HexKit.toUnicodeHex(c));
        }
        return unicode.toString();
    }

    public static String toUnicodeString(String input) {
        StringBuilder string = new StringBuilder();
        String[] hex = input.split("\\\\u");
        for (int i = 1; i < hex.length; ++i) {
            int data = Integer.parseInt(hex[i], 16);
            string.append((char)data);
        }
        return string.toString();
    }

    public static String toUnicodeString(String unicode, boolean isSkipAscii) {
        if (StringKit.isBlank(unicode)) {
            return unicode;
        }
        if (isSkipAscii) {
            int len = unicode.length();
            TextKit sb = TextKit.create(len);
            int i = -1;
            int pos = 0;
            while ((i = StringKit.indexOfIgnoreCase(unicode, "\\u", pos)) != -1) {
                sb.append(unicode, pos, i);
                pos = i;
                if (i + 5 < len) {
                    char c = '\u0000';
                    try {
                        c = (char)Integer.parseInt(unicode.substring(i + 2, i + 6), 16);
                        sb.append(c);
                        pos = i + 6;
                    }
                    catch (NumberFormatException e) {
                        sb.append(unicode, pos, i + 2);
                        pos = i + 2;
                    }
                    continue;
                }
                pos = i;
                break;
            }
            if (pos < len) {
                sb.append(unicode, pos, len);
            }
            return sb.toString();
        }
        return StringKit.toUnicodeString(unicode);
    }

    public static String encloseAlphabetByChar(char letter) {
        if (!(letter >= 'a' && letter <= 'z' || letter >= 'A' && letter <= 'Z')) {
            throw new IllegalArgumentException("number\u53d6\u503c\u8303\u56f4\u662f[a-z]\u3001[A-Z]\u7684\u5b57\u7b26");
        }
        String start = "\u24b6";
        String hexStr = StringKit.toUnicode(start).substring("\\u".length());
        int difference = letter >= 'a' && letter <= 'z' ? letter - 97 : letter - 65;
        String hex = new BigInteger(hexStr, 16).add(new BigInteger(String.valueOf(difference), 10)).toString(16);
        String unicodeStr = "\\u" + hex;
        return StringKit.toString(unicodeStr);
    }

    public static boolean equals(CharSequence stra, CharSequence strb) {
        return StringKit.equals(stra, strb, false);
    }

    public static boolean equals(CharSequence stra, CharSequence strb, boolean ignoreCase) {
        if (null == stra) {
            return null == strb;
        }
        if (null == strb) {
            return false;
        }
        if (ignoreCase) {
            return stra.toString().equalsIgnoreCase(strb.toString());
        }
        return stra.equals(strb);
    }

    public static boolean equalsIgnoreCase(CharSequence stra, CharSequence strb) {
        return StringKit.equals(stra, strb, true);
    }

    public static boolean equalsAnyIgnoreCase(CharSequence stra, CharSequence ... strb) {
        return StringKit.equalsAny(stra, true, strb);
    }

    public static boolean equalsAny(CharSequence str1, CharSequence ... texts) {
        return StringKit.equalsAny(str1, false, texts);
    }

    public static boolean equalsAny(CharSequence str1, boolean ignoreCase, CharSequence ... texts) {
        if (ArrayKit.isEmpty(texts)) {
            return false;
        }
        for (CharSequence text : texts) {
            if (!StringKit.equals(str1, text, ignoreCase)) continue;
            return true;
        }
        return false;
    }

    public static String format(String template, Object ... args) {
        if (null == template) {
            return "null";
        }
        if (ArrayKit.isEmpty(args) || StringKit.isBlank(template)) {
            return template;
        }
        return TextFormatter.format(template, args);
    }

    public static String format(CharSequence template, Map<?, ?> args) {
        return StringKit.format(template, args, true);
    }

    public static String format(CharSequence template, Map<?, ?> map, boolean ignoreNull) {
        return TextFormatter.format(template, map, ignoreNull);
    }

    public static String sub(CharSequence text, int fromIndex, int toIndex) {
        if (StringKit.isEmpty(text)) {
            return StringKit.toString(text);
        }
        int len = text.length();
        if (fromIndex < 0) {
            if ((fromIndex = len + fromIndex) < 0) {
                fromIndex = 0;
            }
        } else if (fromIndex > len) {
            fromIndex = len;
        }
        if (toIndex < 0) {
            if ((toIndex = len + toIndex) < 0) {
                toIndex = len;
            }
        } else if (toIndex > len) {
            toIndex = len;
        }
        if (toIndex < fromIndex) {
            int tmp = fromIndex;
            fromIndex = toIndex;
            toIndex = tmp;
        }
        if (fromIndex == toIndex) {
            return "";
        }
        return text.toString().substring(fromIndex, toIndex);
    }

    public static String subPre(CharSequence string, int toIndex) {
        return StringKit.sub(string, 0, toIndex);
    }

    public static String subSuf(CharSequence string, int fromIndex) {
        if (StringKit.isEmpty(string)) {
            return null;
        }
        return StringKit.sub(string, fromIndex, string.length());
    }

    public static String subBeforeLast(String text, String separator) {
        if (StringKit.isEmpty(text) || StringKit.isEmpty(separator)) {
            return text;
        }
        int pos = text.lastIndexOf(separator);
        if (pos == -1) {
            return text;
        }
        return text.substring(0, pos);
    }

    public static String subAfterLast(String text, String separator) {
        if (StringKit.isEmpty(text)) {
            return text;
        }
        if (StringKit.isEmpty(separator)) {
            return "";
        }
        int pos = text.lastIndexOf(separator);
        if (pos == -1 || pos == text.length() - separator.length()) {
            return "";
        }
        return text.substring(pos + separator.length());
    }

    public static String subCodePoint(CharSequence text, int fromIndex, int toIndex) {
        if (StringKit.isEmpty(text)) {
            return StringKit.toString(text);
        }
        if (fromIndex < 0 || fromIndex > toIndex) {
            throw new IllegalArgumentException();
        }
        if (fromIndex == toIndex) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int subLen = toIndex - fromIndex;
        text.toString().codePoints().skip(fromIndex).limit(subLen).forEach(v -> sb.append(Character.toChars(v)));
        return sb.toString();
    }

    public static String subBefore(CharSequence string, CharSequence separator, boolean isLastSeparator) {
        int pos;
        if (StringKit.isEmpty(string) || null == separator) {
            return null == string ? null : "";
        }
        String text = string.toString();
        String sep = separator.toString();
        if (sep.isEmpty()) {
            return "";
        }
        int n = pos = isLastSeparator ? text.lastIndexOf(sep) : text.indexOf(sep);
        if (-1 == pos) {
            return text;
        }
        if (0 == pos) {
            return "";
        }
        return text.substring(0, pos);
    }

    public static String subBefore(CharSequence string, char separator, boolean isLastSeparator) {
        int pos;
        if (StringKit.isEmpty(string)) {
            return null == string ? null : "";
        }
        String text = string.toString();
        int n = pos = isLastSeparator ? text.lastIndexOf(separator) : text.indexOf(separator);
        if (-1 == pos) {
            return text;
        }
        if (0 == pos) {
            return "";
        }
        return text.substring(0, pos);
    }

    public static String subAfter(CharSequence string, CharSequence separator, boolean isLastSeparator) {
        int pos;
        if (StringKit.isEmpty(string)) {
            return null == string ? null : "";
        }
        if (null == separator) {
            return "";
        }
        String text = string.toString();
        String sep = separator.toString();
        int n = pos = isLastSeparator ? text.lastIndexOf(sep) : text.indexOf(sep);
        if (-1 == pos || string.length() - 1 == pos) {
            return "";
        }
        return text.substring(pos + separator.length());
    }

    public static String subAfter(CharSequence string, char separator, boolean isLastSeparator) {
        int pos;
        if (StringKit.isEmpty(string)) {
            return null == string ? null : "";
        }
        String text = string.toString();
        int n = pos = isLastSeparator ? text.lastIndexOf(separator) : text.indexOf(separator);
        if (-1 == pos) {
            return "";
        }
        return text.substring(pos + 1);
    }

    public static String subBetween(CharSequence text, CharSequence before, CharSequence after) {
        return StringKit.subBetween(text.toString(), before.toString(), after.toString());
    }

    public static String subBetween(String text, String before, String after) {
        int end;
        if (null == text || null == before || null == after) {
            return null;
        }
        int start = text.indexOf(before);
        if (start != -1 && (end = text.indexOf(after, start + before.length())) != -1) {
            return text.substring(start + before.length(), end);
        }
        return null;
    }

    public static String subBetween(CharSequence text, CharSequence beforeAndAfter) {
        return StringKit.subBetween(text, beforeAndAfter, beforeAndAfter);
    }

    public static String[] subBetweenAll(CharSequence text, CharSequence prefix, CharSequence suffix) {
        if (StringKit.hasEmpty(text, prefix, suffix) || !StringKit.contains(text, prefix)) {
            return new String[0];
        }
        LinkedList<String> result = new LinkedList<String>();
        String[] split = StringKit.splitToArray(text, prefix);
        if (prefix.equals(suffix)) {
            int length = split.length - 1;
            for (int i = 1; i < length; i += 2) {
                result.add(split[i]);
            }
        } else {
            for (String fragment : split) {
                int suffixIndex = fragment.indexOf(suffix.toString());
                if (suffixIndex <= 0) continue;
                result.add(fragment.substring(0, suffixIndex));
            }
        }
        return result.toArray(new String[0]);
    }

    public static String[] subBetweenAll(CharSequence text, CharSequence prefixAndSuffix) {
        return StringKit.subBetweenAll(text, prefixAndSuffix, prefixAndSuffix);
    }

    public static String subByLength(CharSequence text, int length) {
        if (StringKit.isEmpty(text)) {
            return null;
        }
        if (length <= 0) {
            return "";
        }
        return StringKit.sub(text, -length, text.length());
    }

    public static String subWithLength(String input, int fromIndex, int length) {
        return StringKit.sub(input, fromIndex, fromIndex + length);
    }

    public static List<String> splitPath(String text) {
        return StringKit.splitPath(text, 0);
    }

    public static List<String> splitPath(String text, int limit) {
        return StringKit.split((CharSequence)text, '/', limit, true, true);
    }

    public static String[] splitPathToArray(String text) {
        return ArrayKit.toArray(StringKit.splitPath(text));
    }

    public static String[] splitPathToArray(String text, int limit) {
        return ArrayKit.toArray(StringKit.splitPath(text, limit));
    }

    public static List<String> splitTrim(CharSequence text, char separator) {
        return StringKit.splitTrim(text.toString(), separator, true);
    }

    public static List<String> splitTrim(CharSequence text, CharSequence separator) {
        return StringKit.splitTrim(text, separator, -1);
    }

    public static List<String> splitTrim(CharSequence text, char separator, int limit) {
        return StringKit.split(text, separator, limit, true, true);
    }

    public static List<String> splitTrim(CharSequence text, CharSequence separator, int limit) {
        return StringKit.split(text, separator, limit, true, true);
    }

    public static List<String> splitTrim(String text, char separator, boolean ignoreEmpty) {
        return StringKit.split((CharSequence)text, separator, 0, true, ignoreEmpty);
    }

    public static List<String> splitTrim(String text, String separator, boolean ignoreEmpty) {
        return StringKit.split((CharSequence)text, separator, true, ignoreEmpty);
    }

    public static List<String> splitTrim(String text, String separator, int limit, boolean ignoreEmpty) {
        return StringKit.split((CharSequence)text, separator, limit, true, ignoreEmpty);
    }

    public static long[] splitToLong(CharSequence text, char separator) {
        return Convert.convert(long[].class, StringKit.splitTrim(text, separator));
    }

    public static long[] splitToLong(CharSequence text, CharSequence separator) {
        return Convert.convert(long[].class, StringKit.splitTrim(text, separator));
    }

    public static int[] splitToInt(CharSequence text, char separator) {
        return Convert.convert(int[].class, StringKit.splitTrim(text, separator));
    }

    public static int[] splitToInt(CharSequence text, CharSequence separator) {
        return Convert.convert(int[].class, StringKit.splitTrim(text, separator));
    }

    public static String[] splitToArray(CharSequence text, CharSequence separator) {
        if (text == null) {
            return new String[0];
        }
        return TextSplitter.splitToArray((CharSequence)text.toString(), StringKit.toString(separator), 0, false, false);
    }

    public static String[] splitToArray(CharSequence text, char separator) {
        return StringKit.splitToArray(text, separator, 0);
    }

    public static String[] splitToArray(CharSequence text, char separator, int limit) {
        Assert.notNull(text, "Text must be not null!", new Object[0]);
        return TextSplitter.splitToArray((CharSequence)text.toString(), separator, limit, false, false);
    }

    public static String[] splitToArray(String text, String separator) {
        return TextSplitter.splitToArray(text, separator);
    }

    public static String[] splitToArray(String text, String separator, boolean isTrim, boolean ignoreEmpty) {
        return TextSplitter.splitToArray(text, separator, isTrim, ignoreEmpty);
    }

    public static List<String> split(CharSequence text, char separator) {
        return StringKit.split(text, separator, 0);
    }

    public static List<String> split(CharSequence text, char separator, int limit) {
        return StringKit.split(text, separator, limit, false, false);
    }

    public static List<String> split(CharSequence text, char separator, boolean isTrim, boolean ignoreEmpty) {
        return StringKit.split(text, separator, 0, isTrim, ignoreEmpty);
    }

    public static List<String> split(CharSequence text, char separator, int limit, boolean isTrim, boolean ignoreEmpty) {
        return TextSplitter.split(text, separator, limit, isTrim, ignoreEmpty);
    }

    public static <R> List<R> split(CharSequence text, char separator, int limit, boolean ignoreEmpty, Function<String, R> mapping) {
        if (null == text) {
            return new ArrayList(0);
        }
        return TextSplitter.split((CharSequence)text.toString(), separator, limit, ignoreEmpty, mapping);
    }

    public static List<String> split(CharSequence text, CharSequence separator) {
        return StringKit.split(text, separator, false, false);
    }

    public static List<String> split(CharSequence text, CharSequence separator, boolean isTrim, boolean ignoreEmpty) {
        return StringKit.split(text, separator, 0, isTrim, ignoreEmpty);
    }

    public static List<String> split(CharSequence text, CharSequence separator, int limit, boolean isTrim, boolean ignoreEmpty) {
        if (null == text) {
            return new ArrayList<String>(0);
        }
        String separatorStr = null == separator ? null : separator.toString();
        return TextSplitter.split((CharSequence)text.toString(), separatorStr, limit, isTrim, ignoreEmpty);
    }

    public static String split(String text, CharSequence separator, CharSequence reserve) {
        StringBuffer sb = new StringBuffer();
        if (StringKit.isNotEmpty(text)) {
            String[] arr = StringKit.splitToArray((CharSequence)text, separator);
            for (int i = 0; i < arr.length; ++i) {
                if (i == 0) {
                    sb.append("'").append(arr[i]).append("'");
                    continue;
                }
                sb.append(reserve).append("'").append(arr[i]).append("'");
            }
        }
        return sb.toString();
    }

    public static String split(String text) {
        return StringKit.split(text, ",", ",");
    }

    public static String[] split(CharSequence text, int len) {
        if (null == text) {
            return new String[0];
        }
        return TextSplitter.splitByLength(text.toString(), len);
    }

    public static int indexOf(CharSequence text, char searchChar) {
        return StringKit.indexOf(text, searchChar, 0);
    }

    public static int indexOf(CharSequence text, char searchChar, int start) {
        if (text instanceof String) {
            return ((String)text).indexOf(searchChar, start);
        }
        return StringKit.indexOf(text, searchChar, start, -1);
    }

    public static int indexOf(CharSequence text, char searchChar, int start, int end) {
        if (StringKit.isEmpty(text)) {
            return 94;
        }
        int len = text.length();
        if (start < 0 || start > len) {
            start = 0;
        }
        if (end > len || end < 0) {
            end = len;
        }
        for (int i = start; i < end; ++i) {
            if (text.charAt(i) != searchChar) continue;
            return i;
        }
        return -1;
    }

    public static int indexOfIgnoreCase(CharSequence text, CharSequence word) {
        return StringKit.indexOfIgnoreCase(text, word, 0);
    }

    public static int indexOfIgnoreCase(CharSequence text, CharSequence word, int fromIndex) {
        return StringKit.indexOf(text, word, fromIndex, true);
    }

    public static int indexOf(CharSequence text, CharSequence word, int fromIndex, boolean ignoreCase) {
        int endLimit;
        if (null == text || null == word) {
            return -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (fromIndex > (endLimit = text.length() - word.length() + 1)) {
            return -1;
        }
        if (word.length() == 0) {
            return fromIndex;
        }
        if (!ignoreCase) {
            return text.toString().indexOf(word.toString(), fromIndex);
        }
        for (int i = fromIndex; i < endLimit; ++i) {
            if (!StringKit.isSubEquals(text, i, word, 0, word.length(), true)) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOfIgnoreCase(CharSequence text, CharSequence word) {
        return StringKit.lastIndexOfIgnoreCase(text, word, text.length());
    }

    public static int lastIndexOfIgnoreCase(CharSequence text, CharSequence word, int fromIndex) {
        return StringKit.lastIndexOf(text, word, fromIndex, true);
    }

    public static int lastIndexOf(CharSequence text, CharSequence word, int fromIndex, boolean ignoreCase) {
        if (null == text || null == word) {
            return -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        fromIndex = Math.min(fromIndex, text.length());
        if (word.length() == 0) {
            return fromIndex;
        }
        if (!ignoreCase) {
            return text.toString().lastIndexOf(word.toString(), fromIndex);
        }
        for (int i = fromIndex; i >= 0; --i) {
            if (!StringKit.isSubEquals(text, i, word, 0, word.length(), true)) continue;
            return i;
        }
        return -1;
    }

    public static int ordinalIndexOf(String text, String word, int ordinal) {
        if (null == text || null == word || ordinal <= 0) {
            return -1;
        }
        if (word.length() == 0) {
            return 0;
        }
        int found = 0;
        int index = -1;
        do {
            if ((index = text.indexOf(word, index + 1)) >= 0) continue;
            return index;
        } while (++found < ordinal);
        return index;
    }

    public static String repeat(char c, int count) {
        if (count <= 0) {
            return "";
        }
        char[] result = new char[count];
        for (int i = 0; i < count; ++i) {
            result[i] = c;
        }
        return new String(result);
    }

    public static String repeat(CharSequence text, int count) {
        int n;
        if (null == text) {
            return null;
        }
        if (count <= 0 || text.length() == 0) {
            return "";
        }
        if (count == 1) {
            return text.toString();
        }
        int len = text.length();
        long longSize = (long)len * (long)count;
        int size = (int)longSize;
        if ((long)size != longSize) {
            throw new ArrayIndexOutOfBoundsException("Required String length is too large: " + longSize);
        }
        char[] array = new char[size];
        text.toString().getChars(0, len, array, 0);
        for (n = len; n < size - n; n <<= 1) {
            System.arraycopy(array, 0, array, n, n);
        }
        System.arraycopy(array, 0, array, n, size - n);
        return new String(array);
    }

    public static String repeatByLength(CharSequence text, int padLen) {
        if (null == text) {
            return null;
        }
        if (padLen <= 0) {
            return "";
        }
        int strLen = text.length();
        if (strLen == padLen) {
            return text.toString();
        }
        if (strLen > padLen) {
            return StringKit.subPre(text, padLen);
        }
        char[] padding = new char[padLen];
        for (int i = 0; i < padLen; ++i) {
            padding[i] = text.charAt(i % strLen);
        }
        return new String(padding);
    }

    public static String repeatAndJoin(CharSequence text, int count, CharSequence conjunction) {
        if (count <= 0) {
            return "";
        }
        TextBuilder builder = TextBuilder.create();
        boolean isFirst = true;
        while (count-- > 0) {
            if (isFirst) {
                isFirst = false;
            } else if (StringKit.isNotEmpty(conjunction.toString())) {
                builder.append(conjunction);
            }
            builder.append(text);
        }
        return builder.toString();
    }

    public static String reverse(String text) {
        char[] chars = text.toCharArray();
        ArrayKit.reverse(chars);
        return new String(chars);
    }

    public static byte[] bytes(CharSequence text) {
        return StringKit.bytes(text, Charset.defaultCharset());
    }

    public static byte[] bytes(CharSequence text, String charset) {
        return StringKit.bytes(text, StringKit.isBlank(charset) ? Charset.defaultCharset() : Charset.forName(charset));
    }

    public static byte[] bytes(CharSequence text, Charset charset) {
        if (null == text) {
            return null;
        }
        if (null == charset) {
            return text.toString().getBytes();
        }
        return text.toString().getBytes(charset);
    }

    public static String removeStart(String text, String remove) {
        if (StringKit.isEmpty(text) || StringKit.isEmpty(remove)) {
            return text;
        }
        if (text.startsWith(remove)) {
            return text.substring(remove.length());
        }
        return text;
    }

    public static String removePreAndLowerFirst(CharSequence text, int preLength) {
        if (null == text) {
            return null;
        }
        if (text.length() > preLength) {
            char first = Character.toLowerCase(text.charAt(preLength));
            if (text.length() > preLength + 1) {
                return first + text.toString().substring(preLength + 1);
            }
            return String.valueOf(first);
        }
        return text.toString();
    }

    public static String removePreAndLowerFirst(CharSequence text, CharSequence prefix) {
        return StringKit.lowerFirst(StringKit.removePrefix(text, prefix));
    }

    public static String removePrefix(CharSequence text, CharSequence prefix) {
        if (StringKit.isEmpty(text) || StringKit.isEmpty(prefix)) {
            return StringKit.toString(text);
        }
        String str2 = text.toString();
        if (str2.startsWith(prefix.toString())) {
            return StringKit.subSuf(str2, prefix.length());
        }
        return str2;
    }

    public static String removePrefixIgnoreCase(CharSequence text, CharSequence prefix) {
        if (StringKit.isEmpty(text) || StringKit.isEmpty(prefix)) {
            return StringKit.toString(text);
        }
        String str2 = text.toString();
        if (str2.toLowerCase().startsWith(prefix.toString().toLowerCase())) {
            return StringKit.subSuf(str2, prefix.length());
        }
        return str2;
    }

    public static String removeSuffix(CharSequence text, CharSequence suffix) {
        if (StringKit.isEmpty(text) || StringKit.isEmpty(suffix)) {
            return StringKit.toString(text);
        }
        String str2 = text.toString();
        if (str2.endsWith(suffix.toString())) {
            return StringKit.subPre(str2, str2.length() - suffix.length());
        }
        return str2;
    }

    public static String upperFirstAndAddPre(CharSequence text, String preString) {
        if (null == text || null == preString) {
            return null;
        }
        return preString + StringKit.upperFirst(text);
    }

    public static String upperFirst(CharSequence text) {
        char firstChar;
        if (null == text) {
            return null;
        }
        if (text.length() > 0 && Character.isLowerCase(firstChar = text.charAt(0))) {
            return Character.toUpperCase(firstChar) + StringKit.subSuf(text, 1);
        }
        return text.toString();
    }

    public static String lowerFirst(CharSequence text) {
        char firstChar;
        if (null == text) {
            return null;
        }
        if (text.length() > 0 && Character.isUpperCase(firstChar = text.charAt(0))) {
            return Character.toLowerCase(firstChar) + StringKit.subSuf(text, 1);
        }
        return text.toString();
    }

    public static String toUnderlineCase(CharSequence camelCaseStr) {
        return NamingCase.toUnderlineCase(camelCaseStr);
    }

    public static String toSymbolCase(CharSequence text, char symbol) {
        return NamingCase.toSymbolCase(text, symbol);
    }

    public static String toCamelCase(CharSequence text) {
        return NamingCase.toCamelCase(text);
    }

    public static String remove(String text, String remove) {
        if (StringKit.isEmpty(text) || StringKit.isEmpty(remove)) {
            return text;
        }
        return StringKit.replace(text, remove, "", -1);
    }

    public static String removeIgnoreCase(String text, String remove) {
        if (StringKit.isEmpty(text) || StringKit.isEmpty(remove)) {
            return text;
        }
        return StringKit.replaceIgnoreCase(text, remove, "", -1);
    }

    public static String remove(String text, char remove) {
        if (StringKit.isEmpty(text) || text.indexOf(remove) == -1) {
            return text;
        }
        char[] chars = text.toCharArray();
        int pos = 0;
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == remove) continue;
            chars[pos++] = chars[i];
        }
        return new String(chars, 0, pos);
    }

    public static String removeAll(String text, String regex) {
        return StringKit.replaceAll(text, regex, "");
    }

    public static String removeAll(CharSequence text, char ... chars) {
        if (null == text || ArrayKit.isEmpty(chars)) {
            return StringKit.toString(text);
        }
        int len = text.length();
        if (0 == len) {
            return StringKit.toString(text);
        }
        StringBuilder builder = StringKit.builder(len);
        for (int i = 0; i < len; ++i) {
            char c = text.charAt(i);
            if (ArrayKit.contains(chars, c)) continue;
            builder.append(c);
        }
        return builder.toString();
    }

    public static String removeAll(CharSequence text, CharSequence strToRemove) {
        if (StringKit.isEmpty(text) || StringKit.isEmpty(strToRemove)) {
            return StringKit.toString(text);
        }
        return text.toString().replace(strToRemove, "");
    }

    public static String removeAny(CharSequence text, CharSequence ... strsToRemove) {
        String result = StringKit.toString(text);
        if (StringKit.isNotEmpty(text)) {
            for (CharSequence strToRemove : strsToRemove) {
                result = StringKit.removeAll((CharSequence)result, strToRemove);
            }
        }
        return result;
    }

    public static String removeFirst(String text, String regex) {
        return StringKit.replaceFirst(text, regex, "");
    }

    public static String replaceAll(String text, String regex, String replacement) {
        if (null == text || null == regex || null == replacement) {
            return text;
        }
        return text.replaceAll(regex, replacement);
    }

    public static String replaceFirst(String text, String regex, String replacement) {
        if (null == text || null == regex || null == replacement) {
            return text;
        }
        return text.replaceFirst(regex, replacement);
    }

    public static String replace(String text, String word, String replacement) {
        return StringKit.replace(text, word, replacement, -1);
    }

    public static String replaceIgnoreCase(String text, String word, String replacement) {
        return StringKit.replaceIgnoreCase(text, word, replacement, -1);
    }

    public static String replace(String text, String word, String replacement, int max) {
        return StringKit.replace(text, word, replacement, max, false);
    }

    private static String replace(String text, String word, String replacement, int max, boolean ignoreCase) {
        int start;
        int end;
        if (StringKit.isEmpty(text) || StringKit.isEmpty(word) || null == replacement || max == 0) {
            return text;
        }
        String searchText = text;
        if (ignoreCase) {
            searchText = text.toLowerCase();
            word = word.toLowerCase();
        }
        if ((end = searchText.indexOf(word, start = 0)) == -1) {
            return text;
        }
        int replLength = word.length();
        int increase = replacement.length() - replLength;
        int n = increase = increase < 0 ? 0 : increase;
        StringBuilder buf = new StringBuilder(text.length() + (increase *= max < 0 ? 16 : (max > 64 ? 64 : max)));
        while (end != -1) {
            buf.append(text, start, end).append(replacement);
            start = end + replLength;
            if (--max == 0) break;
            end = searchText.indexOf(word, start);
        }
        buf.append(text, start, text.length());
        return buf.toString();
    }

    public static String replaceBlank(String text) {
        String val = "";
        if (null != text) {
            Pattern p = Pattern.compile("\\s*|\t|\r|\n");
            Matcher m = p.matcher(text);
            val = m.replaceAll("");
        }
        return val;
    }

    public static String replaceIgnoreCase(String text, String word, String replacement, int max) {
        return StringKit.replace(text, word, replacement, max, true);
    }

    public static String replaceEach(String text, String[] searchList, String[] replacementList) {
        return StringKit.replaceEach(text, searchList, replacementList, false, 0);
    }

    public static String replaceEachRepeatedly(String text, String[] searchList, String[] replacementList) {
        int timeToLive = null == searchList ? 0 : searchList.length;
        return StringKit.replaceEach(text, searchList, replacementList, true, timeToLive);
    }

    private static String replaceEach(String text, String[] searchList, String[] replacementList, boolean repeat, int timeToLive) {
        if (null == text || text.isEmpty() || null == searchList || searchList.length == 0 || null == replacementList || replacementList.length == 0) {
            return text;
        }
        if (timeToLive < 0) {
            throw new IllegalStateException("Aborting to protect against StackOverflowError - output of one loop is the input of another");
        }
        int searchLength = searchList.length;
        int replacementLength = replacementList.length;
        if (searchLength != replacementLength) {
            throw new IllegalArgumentException("Search and Replace array lengths don't match: " + searchLength + " vs " + replacementLength);
        }
        boolean[] noMoreMatchesForReplIndex = new boolean[searchLength];
        int textIndex = -1;
        int replaceIndex = -1;
        int tempIndex = -1;
        for (int i = 0; i < searchLength; ++i) {
            if (noMoreMatchesForReplIndex[i] || null == searchList[i] || searchList[i].isEmpty() || null == replacementList[i]) continue;
            tempIndex = text.indexOf(searchList[i]);
            if (tempIndex == -1) {
                noMoreMatchesForReplIndex[i] = true;
                continue;
            }
            if (textIndex != -1 && tempIndex >= textIndex) continue;
            textIndex = tempIndex;
            replaceIndex = i;
        }
        if (textIndex == -1) {
            return text;
        }
        int start = 0;
        int increase = 0;
        for (int i = 0; i < searchList.length; ++i) {
            int greater;
            if (null == searchList[i] || null == replacementList[i] || (greater = replacementList[i].length() - searchList[i].length()) <= 0) continue;
            increase += 3 * greater;
        }
        increase = Math.min(increase, text.length() / 5);
        StringBuilder buf = new StringBuilder(text.length() + increase);
        while (textIndex != -1) {
            int i;
            for (i = start; i < textIndex; ++i) {
                buf.append(text.charAt(i));
            }
            buf.append(replacementList[replaceIndex]);
            start = textIndex + searchList[replaceIndex].length();
            textIndex = -1;
            replaceIndex = -1;
            for (i = 0; i < searchLength; ++i) {
                if (noMoreMatchesForReplIndex[i] || null == searchList[i] || searchList[i].isEmpty() || null == replacementList[i]) continue;
                tempIndex = text.indexOf(searchList[i], start);
                if (tempIndex == -1) {
                    noMoreMatchesForReplIndex[i] = true;
                    continue;
                }
                if (textIndex != -1 && tempIndex >= textIndex) continue;
                textIndex = tempIndex;
                replaceIndex = i;
            }
        }
        int textLength = text.length();
        for (int i = start; i < textLength; ++i) {
            buf.append(text.charAt(i));
        }
        String result = buf.toString();
        if (!repeat) {
            return result;
        }
        return StringKit.replaceEach(result, searchList, replacementList, repeat, timeToLive - 1);
    }

    public static String replaceChars(String text, char searchChar, char replaceChar) {
        if (null == text) {
            return null;
        }
        return text.replace(searchChar, replaceChar);
    }

    public static String replaceChars(String text, String searchChars, String replaceChars) {
        if (StringKit.isEmpty(text) || StringKit.isEmpty(searchChars)) {
            return text;
        }
        if (null == replaceChars) {
            replaceChars = "";
        }
        boolean modified = false;
        int replaceCharsLength = replaceChars.length();
        int strLength = text.length();
        StringBuilder buf = new StringBuilder(strLength);
        for (int i = 0; i < strLength; ++i) {
            char ch = text.charAt(i);
            int index = searchChars.indexOf(ch);
            if (index >= 0) {
                modified = true;
                if (index >= replaceCharsLength) continue;
                buf.append(replaceChars.charAt(index));
                continue;
            }
            buf.append(ch);
        }
        if (modified) {
            return buf.toString();
        }
        return text;
    }

    public static String replaceIgnoreCase(CharSequence text, CharSequence word, CharSequence replacement) {
        return StringKit.replace(text, 0, word, replacement, true);
    }

    public static String replace(CharSequence text, CharSequence word, CharSequence replacement) {
        return StringKit.replace(text, 0, word, replacement, false);
    }

    public static String replace(CharSequence text, CharSequence word, CharSequence replacement, boolean ignoreCase) {
        return StringKit.replace(text, 0, word, replacement, ignoreCase);
    }

    public static String replace(CharSequence text, int fromIndex, CharSequence word, CharSequence replacement, boolean ignoreCase) {
        if (StringKit.isEmpty(text) || StringKit.isEmpty(word)) {
            return StringKit.toString(text);
        }
        if (null == replacement) {
            replacement = "";
        }
        int strLength = text.length();
        int wordLength = word.length();
        if (fromIndex > strLength) {
            return StringKit.toString(text);
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        TextKit result = TextKit.create(strLength + 16);
        if (0 != fromIndex) {
            result.append(text.subSequence(0, fromIndex));
        }
        int preIndex = fromIndex;
        int index = fromIndex;
        while ((index = StringKit.indexOf(text, word, preIndex, ignoreCase)) > -1) {
            result.append(text.subSequence(preIndex, index));
            result.append(replacement);
            preIndex = index + wordLength;
        }
        if (preIndex < strLength) {
            result.append(text.subSequence(preIndex, strLength));
        }
        return result.toString();
    }

    public static String replace(CharSequence text, Pattern pattern, Func1<Matcher, String> replaceFun) {
        return PatternKit.replaceAll(text, pattern, replaceFun);
    }

    public static String replace(CharSequence text, String regex, Func1<Matcher, String> replaceFun) {
        return PatternKit.replaceAll(text, regex, replaceFun);
    }

    public static String replace(CharSequence text, int startInclude, int endExclude, char replacedChar) {
        if (StringKit.isEmpty(text)) {
            return StringKit.toString(text);
        }
        int strLength = text.length();
        if (startInclude > strLength) {
            return StringKit.toString(text);
        }
        if (endExclude > strLength) {
            endExclude = strLength;
        }
        if (startInclude > endExclude) {
            return StringKit.toString(text);
        }
        char[] chars = new char[strLength];
        for (int i = 0; i < strLength; ++i) {
            chars[i] = i >= startInclude && i < endExclude ? replacedChar : text.charAt(i);
        }
        return new String(chars);
    }

    public static String hide(CharSequence text, int startInclude, int endExclude) {
        return StringKit.replace(text, startInclude, endExclude, '*');
    }

    public static String replaceChars(CharSequence text, String chars, CharSequence replacedStr) {
        if (StringKit.isEmpty(text) || StringKit.isEmpty(chars)) {
            return StringKit.toString(text);
        }
        return StringKit.replaceChars(text, chars.toCharArray(), replacedStr);
    }

    public static String replaceChars(CharSequence text, char[] chars, CharSequence replacedStr) {
        if (StringKit.isEmpty(text) || ArrayKit.isEmpty(chars)) {
            return StringKit.toString(text);
        }
        HashSet<Character> set = new HashSet<Character>(chars.length);
        for (char c : chars) {
            set.add(Character.valueOf(c));
        }
        int strLen = text.length();
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < strLen; ++i) {
            char c = text.charAt(i);
            builder.append(set.contains(Character.valueOf(c)) ? replacedStr : Character.valueOf(c));
        }
        return builder.toString();
    }

    public static String cleanBlank(CharSequence text) {
        return StringKit.filter(text, c -> !CharsKit.isBlankChar(c.charValue()));
    }

    public static String wrap(CharSequence text, CharSequence prefixAndSuffix) {
        return StringKit.wrap(text, prefixAndSuffix, prefixAndSuffix);
    }

    public static String wrap(CharSequence text, CharSequence prefix, CharSequence suffix) {
        return StringKit.nullToEmpty(prefix).concat(StringKit.nullToEmpty(text)).concat(StringKit.nullToEmpty(suffix));
    }

    public static String[] wrapAll(CharSequence prefixAndSuffix, CharSequence ... texts) {
        return StringKit.wrapAll(prefixAndSuffix, prefixAndSuffix, texts);
    }

    public static String[] wrapAll(CharSequence prefix, CharSequence suffix, CharSequence ... texts) {
        String[] results = new String[texts.length];
        for (int i = 0; i < texts.length; ++i) {
            results[i] = StringKit.wrap(texts[i], prefix, suffix);
        }
        return results;
    }

    public static String unWrap(CharSequence text, String prefix, String suffix) {
        if (StringKit.isWrap(text, prefix, suffix)) {
            return StringKit.sub(text, prefix.length(), text.length() - suffix.length());
        }
        return text.toString();
    }

    public static String unWrap(CharSequence text, char prefix, char suffix) {
        if (StringKit.isEmpty(text)) {
            return StringKit.toString(text);
        }
        if (text.charAt(0) == prefix && text.charAt(text.length() - 1) == suffix) {
            return StringKit.sub(text, 1, text.length() - 1);
        }
        return text.toString();
    }

    public static String unWrap(CharSequence text, char prefixAndSuffix) {
        return StringKit.unWrap(text, prefixAndSuffix, prefixAndSuffix);
    }

    public static boolean isWrap(CharSequence text, String prefix, String suffix) {
        if (ArrayKit.hasNull(text, prefix, suffix)) {
            return false;
        }
        String str2 = text.toString();
        return str2.startsWith(prefix) && str2.endsWith(suffix);
    }

    public static boolean isWrap(CharSequence text, String wrapper) {
        return StringKit.isWrap(text, wrapper, wrapper);
    }

    public static boolean isWrap(CharSequence text, char wrapper) {
        return StringKit.isWrap(text, wrapper, wrapper);
    }

    public static boolean isWrap(CharSequence text, char prefixChar, char suffixChar) {
        if (null == text) {
            return false;
        }
        return text.charAt(0) == prefixChar && text.charAt(text.length() - 1) == suffixChar;
    }

    public static String wrapIfMissing(CharSequence text, CharSequence prefix, CharSequence suffix) {
        int len = 0;
        if (StringKit.isNotEmpty(text)) {
            len += text.length();
        }
        if (StringKit.isNotEmpty(prefix)) {
            len += prefix.length();
        }
        if (StringKit.isNotEmpty(suffix)) {
            len += suffix.length();
        }
        StringBuilder sb = new StringBuilder(len);
        if (StringKit.isNotEmpty(prefix) && !StringKit.startWith(text, prefix)) {
            sb.append(prefix);
        }
        if (StringKit.isNotEmpty(text)) {
            sb.append(text);
        }
        if (StringKit.isNotEmpty(suffix) && !StringKit.endWith(text, suffix)) {
            sb.append(suffix);
        }
        return sb.toString();
    }

    public static String[] wrapAllIfMissing(CharSequence prefixAndSuffix, CharSequence ... texts) {
        return StringKit.wrapAllIfMissing(prefixAndSuffix, prefixAndSuffix, texts);
    }

    public static String[] wrapAllIfMissing(CharSequence prefix, CharSequence suffix, CharSequence ... texts) {
        String[] results = new String[texts.length];
        for (int i = 0; i < texts.length; ++i) {
            results[i] = StringKit.wrapIfMissing(texts[i], prefix, suffix);
        }
        return results;
    }

    public static boolean startWith(CharSequence text, char c) {
        if (StringKit.isEmpty(text)) {
            return false;
        }
        return c == text.charAt(0);
    }

    public static boolean startWith(CharSequence text, CharSequence prefix, boolean ignoreCase) {
        return StringKit.startWith(text, prefix, ignoreCase, false);
    }

    public static boolean startWith(CharSequence text, CharSequence prefix, boolean ignoreCase, boolean ignoreEquals) {
        if (null == text || null == prefix) {
            if (!ignoreEquals) {
                return false;
            }
            return null == text && null == prefix;
        }
        boolean isStartWith = ignoreCase ? text.toString().toLowerCase().startsWith(prefix.toString().toLowerCase()) : text.toString().startsWith(prefix.toString());
        if (isStartWith) {
            return false == ignoreEquals || false == StringKit.equals(text, prefix, ignoreCase);
        }
        return false;
    }

    public static boolean startWith(CharSequence text, CharSequence prefix) {
        return StringKit.startWith(text, prefix, false);
    }

    public static boolean startWithIgnoreEquals(CharSequence text, CharSequence prefix) {
        return StringKit.startWith(text, prefix, false, true);
    }

    public static boolean startWithAny(CharSequence text, CharSequence ... prefixes) {
        if (StringKit.isEmpty(text) || ArrayKit.isEmpty(prefixes)) {
            return false;
        }
        for (CharSequence suffix : prefixes) {
            if (!StringKit.startWith(text, suffix, false)) continue;
            return true;
        }
        return false;
    }

    public static boolean startWithIgnoreCase(CharSequence text, CharSequence prefix) {
        return StringKit.startWith(text, prefix, true);
    }

    public static boolean endWith(CharSequence text, char c) {
        if (StringKit.isEmpty(text)) {
            return false;
        }
        return c == text.charAt(text.length() - 1);
    }

    public static boolean endWith(CharSequence text, CharSequence suffix, boolean isIgnoreCase) {
        if (null == text || null == suffix) {
            return null == text && null == suffix;
        }
        if (isIgnoreCase) {
            return text.toString().toLowerCase().endsWith(suffix.toString().toLowerCase());
        }
        return text.toString().endsWith(suffix.toString());
    }

    public static boolean endWith(CharSequence text, CharSequence suffix) {
        return StringKit.endWith(text, suffix, false);
    }

    public static boolean endWithAny(CharSequence text, CharSequence ... suffixes) {
        if (StringKit.isEmpty(text) || ArrayKit.isEmpty(suffixes)) {
            return false;
        }
        for (CharSequence suffix : suffixes) {
            if (!StringKit.endWith(text, suffix, false)) continue;
            return true;
        }
        return false;
    }

    public static boolean endWithAnyIgnoreCase(CharSequence text, CharSequence ... suffixes) {
        if (StringKit.isEmpty(text) || ArrayKit.isEmpty(suffixes)) {
            return false;
        }
        for (CharSequence suffix : suffixes) {
            if (!StringKit.endWith(text, suffix, true)) continue;
            return true;
        }
        return false;
    }

    public static boolean endWithIgnoreCase(CharSequence text, CharSequence suffix) {
        return StringKit.endWith(text, suffix, true);
    }

    public static String strip(CharSequence text, CharSequence prefixOrSuffix) {
        return StringKit.strip(text, prefixOrSuffix, prefixOrSuffix);
    }

    public static String strip(CharSequence text, CharSequence prefix, CharSequence suffix) {
        if (StringKit.isEmpty(text)) {
            return StringKit.toString(text);
        }
        int from = 0;
        int to = text.length();
        String str2 = text.toString();
        if (StringKit.startWith((CharSequence)str2, prefix)) {
            from = prefix.length();
        }
        if (StringKit.endWith((CharSequence)str2, suffix)) {
            to -= suffix.length();
        }
        return str2.substring(from, to);
    }

    public static String stripIgnoreCase(CharSequence text, CharSequence prefixOrSuffix) {
        return StringKit.stripIgnoreCase(text, prefixOrSuffix, prefixOrSuffix);
    }

    public static String stripIgnoreCase(CharSequence text, CharSequence prefix, CharSequence suffix) {
        if (StringKit.isEmpty(text)) {
            return StringKit.toString(text);
        }
        int from = 0;
        int to = text.length();
        String str2 = text.toString();
        if (StringKit.startWithIgnoreCase(str2, prefix)) {
            from = prefix.length();
        }
        if (StringKit.endWithIgnoreCase(str2, suffix)) {
            to -= suffix.length();
        }
        return str2.substring(from, to);
    }

    public static String addPrefixIfNot(CharSequence text, CharSequence prefix) {
        String prefix2;
        if (StringKit.isEmpty(text) || StringKit.isEmpty(prefix)) {
            return StringKit.toString(text);
        }
        String str2 = text.toString();
        if (!str2.startsWith(prefix2 = prefix.toString())) {
            return prefix2.concat(str2);
        }
        return str2;
    }

    public static String addSuffixIfNot(CharSequence text, CharSequence suffix) {
        String suffix2;
        if (StringKit.isEmpty(text) || StringKit.isEmpty(suffix)) {
            return StringKit.toString(text);
        }
        String str2 = text.toString();
        if (!str2.endsWith(suffix2 = suffix.toString())) {
            return str2.concat(suffix2);
        }
        return str2;
    }

    public static boolean contains(CharSequence text, char searchChar) {
        return StringKit.indexOf(text, searchChar) > -1;
    }

    public static boolean contains(CharSequence text, CharSequence word) {
        if (null == text || null == word) {
            return false;
        }
        return text.toString().contains(word);
    }

    public static boolean containsAny(CharSequence text, CharSequence ... testStrs) {
        return null != StringKit.getContainsAny(text, testStrs);
    }

    public static boolean containsAny(CharSequence text, char ... testChars) {
        if (!StringKit.isEmpty(text)) {
            int len = text.length();
            for (int i = 0; i < len; ++i) {
                if (!ArrayKit.contains(testChars, text.charAt(i))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsOnly(CharSequence text, char ... testChars) {
        if (!StringKit.isEmpty(text)) {
            int len = text.length();
            for (int i = 0; i < len; ++i) {
                if (ArrayKit.contains(testChars, text.charAt(i))) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean containsBlank(CharSequence text) {
        if (null == text) {
            return false;
        }
        int length = text.length();
        if (0 == length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (!CharsKit.isBlankChar(text.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static String getContainsAny(CharSequence text, CharSequence ... testStrs) {
        if (StringKit.isEmpty(text) || ArrayKit.isEmpty(testStrs)) {
            return null;
        }
        for (CharSequence val : testStrs) {
            if (!val.toString().contains(text)) continue;
            return val.toString();
        }
        return null;
    }

    public static boolean containsIgnoreCase(CharSequence text, CharSequence testStr) {
        if (null == text) {
            return null == testStr;
        }
        return text.toString().toLowerCase().contains(testStr.toString().toLowerCase());
    }

    public static boolean containsAnyIgnoreCase(CharSequence text, CharSequence ... testStrs) {
        return null != StringKit.getContainsStrIgnoreCase(text, testStrs);
    }

    public static String getContainsStrIgnoreCase(CharSequence text, CharSequence ... testStrs) {
        if (StringKit.isEmpty(text) || ArrayKit.isEmpty(testStrs)) {
            return null;
        }
        for (CharSequence testStr : testStrs) {
            if (!StringKit.containsIgnoreCase(text, testStr)) continue;
            return testStr.toString();
        }
        return null;
    }

    public static boolean isSurround(CharSequence text, CharSequence prefix, CharSequence suffix) {
        if (StringKit.isBlank(text)) {
            return false;
        }
        if (text.length() < prefix.length() + suffix.length()) {
            return false;
        }
        String str2 = text.toString();
        return str2.startsWith(prefix.toString()) && str2.endsWith(suffix.toString());
    }

    public static boolean isSurround(CharSequence text, char prefix, char suffix) {
        if (StringKit.isBlank(text)) {
            return false;
        }
        if (text.length() < 2) {
            return false;
        }
        return text.charAt(0) == prefix && text.charAt(text.length() - 1) == suffix;
    }

    public static String rightPad(String text, int size, String padStr) {
        if (null == text) {
            return null;
        }
        if (StringKit.isEmpty(padStr)) {
            padStr = " ";
        }
        int padLen = padStr.length();
        int strLen = text.length();
        int pads = size - strLen;
        if (pads <= 0) {
            return text;
        }
        if (padLen == 1 && pads <= 8192) {
            return StringKit.rightPad(text, size, padStr.charAt(0));
        }
        if (pads == padLen) {
            return text.concat(padStr);
        }
        if (pads < padLen) {
            return text.concat(padStr.substring(0, pads));
        }
        char[] padding = new char[pads];
        char[] padChars = padStr.toCharArray();
        for (int i = 0; i < pads; ++i) {
            padding[i] = padChars[i % padLen];
        }
        return text.concat(new String(padding));
    }

    public static String rightPad(String text, int size, char padChar) {
        if (null == text) {
            return null;
        }
        int pads = size - text.length();
        if (pads <= 0) {
            return text;
        }
        if (pads > 8192) {
            return StringKit.rightPad(text, size, String.valueOf(padChar));
        }
        return text.concat(StringKit.repeat(padChar, pads));
    }

    public static String left(String text, int len) {
        if (null == text) {
            return null;
        }
        if (len < 0) {
            return "";
        }
        if (text.length() <= len) {
            return text;
        }
        return text.substring(0, len);
    }

    public static String right(String text, int len) {
        if (null == text) {
            return null;
        }
        if (len < 0) {
            return "";
        }
        if (text.length() <= len) {
            return text;
        }
        return text.substring(text.length() - len);
    }

    public static String mid(String text, int pos, int len) {
        if (null == text) {
            return null;
        }
        if (len < 0 || pos > text.length()) {
            return "";
        }
        if (pos < 0) {
            pos = 0;
        }
        if (text.length() <= pos + len) {
            return text.substring(pos);
        }
        return text.substring(pos, pos + len);
    }

    public static String leftPad(String text, int size) {
        return StringKit.leftPad(text, size, ' ');
    }

    public static String leftPad(String text, int size, char padChar) {
        if (null == text) {
            return null;
        }
        int pads = size - text.length();
        if (pads <= 0) {
            return text;
        }
        if (pads > 8192) {
            return StringKit.leftPad(text, size, String.valueOf(padChar));
        }
        return StringKit.repeat(padChar, pads).concat(text);
    }

    public static String leftPad(String text, int size, String padStr) {
        if (null == text) {
            return null;
        }
        if (StringKit.isEmpty(padStr)) {
            padStr = " ";
        }
        int padLen = padStr.length();
        int strLen = text.length();
        int pads = size - strLen;
        if (pads <= 0) {
            return text;
        }
        if (padLen == 1 && pads <= 8192) {
            return StringKit.leftPad(text, size, padStr.charAt(0));
        }
        if (pads == padLen) {
            return padStr.concat(text);
        }
        if (pads < padLen) {
            return padStr.substring(0, pads).concat(text);
        }
        char[] padding = new char[pads];
        char[] padChars = padStr.toCharArray();
        for (int i = 0; i < pads; ++i) {
            padding[i] = padChars[i % padLen];
        }
        return new String(padding).concat(text);
    }

    public static int length(CharSequence cs) {
        return null == cs ? 0 : cs.length();
    }

    public static String buildString(Object original, String middle, int prefixLength) {
        if (ObjectKit.isNull(original)) {
            return null;
        }
        String string = original.toString();
        int stringLength = string.length();
        String prefix = stringLength >= prefixLength ? string.substring(0, prefixLength) : string.substring(0, stringLength);
        String suffix = "";
        int suffixLength = stringLength - prefix.length() - middle.length();
        if (suffixLength > 0) {
            suffix = string.substring(stringLength - suffixLength);
        }
        return prefix + middle + suffix;
    }

    public static String concat(boolean isNullToEmpty, CharSequence ... texts) {
        TextBuilder sb = new TextBuilder();
        for (CharSequence text : texts) {
            sb.append(isNullToEmpty ? StringKit.nullToEmpty(text) : text);
        }
        return sb.toString();
    }

    public static boolean isUpperCase(CharSequence text) {
        if (null == text) {
            return false;
        }
        int len = text.length();
        for (int i = 0; i < len; ++i) {
            if (!Character.isLowerCase(text.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isLowerCase(CharSequence text) {
        if (null == text) {
            return false;
        }
        int len = text.length();
        for (int i = 0; i < len; ++i) {
            if (!Character.isUpperCase(text.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static int byteLength(CharSequence cs, Charset charset) {
        return null == cs ? 0 : cs.toString().getBytes(charset).length;
    }

    public static String swapCase(String text) {
        if (StringKit.isEmpty(text)) {
            return text;
        }
        char[] buffer = text.toCharArray();
        for (int i = 0; i < buffer.length; ++i) {
            char ch = buffer[i];
            if (Character.isUpperCase(ch)) {
                buffer[i] = Character.toLowerCase(ch);
                continue;
            }
            if (Character.isTitleCase(ch)) {
                buffer[i] = Character.toLowerCase(ch);
                continue;
            }
            if (!Character.isLowerCase(ch)) continue;
            buffer[i] = Character.toUpperCase(ch);
        }
        return new String(buffer);
    }

    public static String fillBefore(String text, char filledChar, int len) {
        return StringKit.fill(text, filledChar, len, true);
    }

    public static String fillAfter(String strVal, char charVal, int len) {
        return StringKit.fill(strVal, charVal, len, false);
    }

    public static String fill(String strVal, char charVal, int len, boolean isPre) {
        int strLen = strVal.length();
        if (strLen > len) {
            return strVal;
        }
        String filled = StringKit.repeat(charVal, len - strLen);
        return isPre ? filled.concat(strVal) : strVal.concat(filled);
    }

    public static String fill(int count, char charVal) {
        if (count < 0) {
            throw new IllegalArgumentException("count must be greater than or equal 0.");
        }
        char[] chs = new char[count];
        for (int i = 0; i < count; ++i) {
            chs[i] = charVal;
        }
        return new String(chs);
    }

    public static String fill(int count, String strVal) {
        if (count < 0) {
            throw new IllegalArgumentException("count must be greater than or equal 0.");
        }
        StringBuilder sb = new StringBuilder(count);
        for (int i = 0; i < count; ++i) {
            sb.append(strVal);
        }
        return sb.toString();
    }

    public static StringBuilder builder() {
        return new StringBuilder();
    }

    public static TextBuilder builders() {
        return new TextBuilder();
    }

    public static StringBuilder builder(int capacity) {
        return new StringBuilder(capacity);
    }

    public static TextBuilder builders(int capacity) {
        return new TextBuilder(capacity);
    }

    public static StringBuilder builder(CharSequence ... texts) {
        StringBuilder sb = new StringBuilder();
        for (CharSequence text : texts) {
            sb.append(text);
        }
        return sb;
    }

    public static TextBuilder builders(CharSequence ... texts) {
        return new TextBuilder(texts);
    }

    public static StringReader getReader(CharSequence text) {
        if (null == text) {
            return null;
        }
        return new StringReader(text.toString());
    }

    public static StringWriter getWriter() {
        return new StringWriter();
    }

    public static int count(CharSequence content, CharSequence strForSearch) {
        if (StringKit.hasEmpty(content, strForSearch) || strForSearch.length() > content.length()) {
            return 0;
        }
        int count = 0;
        int idx = 0;
        String content2 = content.toString();
        String strForSearch2 = strForSearch.toString();
        while ((idx = content2.indexOf(strForSearch2, idx)) > -1) {
            ++count;
            idx += strForSearch.length();
        }
        return count;
    }

    public static int count(CharSequence content, char charForSearch) {
        int count = 0;
        if (StringKit.isEmpty(content)) {
            return 0;
        }
        int contentLength = content.length();
        for (int i = 0; i < contentLength; ++i) {
            if (charForSearch != content.charAt(i)) continue;
            ++count;
        }
        return count;
    }

    public static Map<String, Long> count(String text, String separator) {
        return StringKit.count(Collections.singletonList(text), separator);
    }

    public static Map<String, Long> count(String text, String separator, boolean isValueDesc) {
        return StringKit.count(Collections.singletonList(text), separator, isValueDesc);
    }

    public static Map<String, Long> count(List<String> list, String separator) {
        HashMap<String, Long> countMap = MapKit.newHashMap();
        for (String text : list) {
            String[] words;
            for (String word : words = text.split(separator)) {
                countMap.put(word, countMap.getOrDefault(word, 0L) + 1L);
            }
        }
        return countMap;
    }

    public static Map<String, Long> count(List<String> list, String separator, boolean isValueDesc) {
        return MapKit.sort(StringKit.count(list, separator), isValueDesc);
    }

    public static String[] cut(CharSequence text, int partLength) {
        if (null == text) {
            return null;
        }
        int len = text.length();
        if (len < partLength) {
            return new String[]{text.toString()};
        }
        int part = MathKit.count(len, partLength);
        String[] array = new String[part];
        String str2 = text.toString();
        for (int i = 0; i < part; ++i) {
            array[i] = str2.substring(i * partLength, i == part - 1 ? len : partLength + i * partLength);
        }
        return array;
    }

    public static String brief(CharSequence text, int maxLength) {
        if (null == text) {
            return null;
        }
        int strLength = text.length();
        if (maxLength <= 0 || strLength <= maxLength) {
            return text.toString();
        }
        switch (maxLength) {
            case 1: {
                return String.valueOf(text.charAt(0));
            }
            case 2: {
                return text.charAt(0) + ".";
            }
            case 3: {
                return text.charAt(0) + "." + text.charAt(text.length() - 1);
            }
        }
        int w = maxLength / 2;
        String str2 = text.toString();
        return StringKit.format("{}...{}", str2.substring(0, maxLength - w), str2.substring(strLength - w + 3));
    }

    public static String firstCharToLower(String text) {
        char firstChar = text.charAt(0);
        if (firstChar >= 'A' && firstChar <= 'Z') {
            char[] arr = text.toCharArray();
            arr[0] = (char)(arr[0] + 32);
            return new String(arr);
        }
        return text;
    }

    public static String firstCharToUpper(String text) {
        char firstChar = text.charAt(0);
        if (firstChar >= 'a' && firstChar <= 'z') {
            char[] arr = text.toCharArray();
            arr[0] = (char)(arr[0] - 32);
            return new String(arr);
        }
        return text;
    }

    public static String cleanText(String txt) {
        if (null == txt) {
            return null;
        }
        return Pattern.compile("[`'\"|/,;()-+*%#\u00b7\u2022\ufffd\u3000\\s]").matcher(txt).replaceAll("");
    }

    public static String cleanIdentifier(String param) {
        if (null == param) {
            return null;
        }
        StringBuilder paramBuilder = new StringBuilder();
        for (int i = 0; i < param.length(); ++i) {
            char c = param.charAt(i);
            if (!Character.isJavaIdentifierPart(c)) continue;
            paramBuilder.append(c);
        }
        return paramBuilder.toString();
    }

    public static String upperCase(String text) {
        if (null == text) {
            return null;
        }
        return text.toUpperCase();
    }

    public static String upperCase(String text, Locale locale) {
        if (null == text) {
            return null;
        }
        return text.toUpperCase(locale);
    }

    public static String lowerCase(String text) {
        if (null == text) {
            return null;
        }
        return text.toLowerCase();
    }

    public static String lowerCase(String text, Locale locale) {
        if (null == text) {
            return null;
        }
        return text.toLowerCase(locale);
    }

    public static String capitalize(String text) {
        int codepoint;
        int newCodePoint;
        int strLen;
        if (null == text || (strLen = text.length()) == 0) {
            return text;
        }
        int firstCodepoint = text.codePointAt(0);
        if (firstCodepoint == (newCodePoint = Character.toTitleCase(firstCodepoint))) {
            return text;
        }
        int[] newCodePoints = new int[strLen];
        int outOffset = 0;
        newCodePoints[outOffset++] = newCodePoint;
        for (int inOffset = Character.charCount(firstCodepoint); inOffset < strLen; inOffset += Character.charCount(codepoint)) {
            codepoint = text.codePointAt(inOffset);
            newCodePoints[outOffset++] = codepoint;
        }
        return new String(newCodePoints, 0, outOffset);
    }

    public static String uncapitalize(String text) {
        int codepoint;
        int newCodePoint;
        int strLen;
        if (null == text || (strLen = text.length()) == 0) {
            return text;
        }
        int firstCodepoint = text.codePointAt(0);
        if (firstCodepoint == (newCodePoint = Character.toLowerCase(firstCodepoint))) {
            return text;
        }
        int[] newCodePoints = new int[strLen];
        int outOffset = 0;
        newCodePoints[outOffset++] = newCodePoint;
        for (int inOffset = Character.charCount(firstCodepoint); inOffset < strLen; inOffset += Character.charCount(codepoint)) {
            codepoint = text.codePointAt(inOffset);
            newCodePoints[outOffset++] = codepoint;
        }
        return new String(newCodePoints, 0, outOffset);
    }

    public static boolean endsWithAny(CharSequence text, CharSequence ... word) {
        if (StringKit.isEmpty(text) || ArrayKit.isEmpty(word)) {
            return false;
        }
        for (CharSequence val : word) {
            if (!StringKit.endWith(text, val)) continue;
            return true;
        }
        return false;
    }

    private static String appendIfMissing(String text, CharSequence suffix, boolean ignoreCase, CharSequence ... suffixes) {
        if (null == text || StringKit.isEmpty(suffix) || StringKit.endWith(text, suffix, ignoreCase)) {
            return StringKit.toString(text);
        }
        if (null != suffixes && suffixes.length > 0) {
            for (CharSequence s : suffixes) {
                if (!StringKit.endWith(text, s, ignoreCase)) continue;
                return text;
            }
        }
        return text.concat(suffix.toString());
    }

    public static String appendIfMissing(String text, CharSequence suffix, CharSequence ... suffixes) {
        return StringKit.appendIfMissing(text, suffix, false, suffixes);
    }

    public static String appendIfMissingIgnoreCase(String text, CharSequence suffix, CharSequence ... suffixes) {
        return StringKit.appendIfMissing(text, suffix, true, suffixes);
    }

    private static String prependIfMissing(String text, CharSequence prefix, boolean ignoreCase, CharSequence ... prefixes) {
        if (null == text || StringKit.isEmpty(prefix) || StringKit.startWith(text, prefix, ignoreCase)) {
            return StringKit.toString(text);
        }
        if (null != prefixes && prefixes.length > 0) {
            for (CharSequence s : prefixes) {
                if (!StringKit.startWith(text, s, ignoreCase)) continue;
                return text;
            }
        }
        return prefix.toString().concat(text);
    }

    public static String prependIfMissing(String text, CharSequence prefix, CharSequence ... prefixes) {
        return StringKit.prependIfMissing(text, prefix, false, prefixes);
    }

    public static String prependIfMissingIgnoreCase(String text, CharSequence prefix, CharSequence ... prefixes) {
        return StringKit.prependIfMissing(text, prefix, true, prefixes);
    }

    public static String maxLength(CharSequence string, int length) {
        Assert.isTrue(length > 0);
        if (null == string) {
            return null;
        }
        if (string.length() <= length) {
            return string.toString();
        }
        return StringKit.sub(string, 0, length) + "...";
    }

    public static String center(CharSequence text, int size) {
        return StringKit.center(text, size, ' ');
    }

    public static String center(CharSequence text, int size, char padChar) {
        if (null == text || size <= 0) {
            return StringKit.toString(text);
        }
        int strLen = text.length();
        int pads = size - strLen;
        if (pads <= 0) {
            return text.toString();
        }
        text = StringKit.padPre(text, strLen + pads / 2, padChar);
        text = StringKit.padAfter(text, size, padChar);
        return text.toString();
    }

    public static String center(CharSequence text, int size, CharSequence padStr) {
        int strLen;
        int pads;
        if (null == text || size <= 0) {
            return StringKit.toString(text);
        }
        if (StringKit.isEmpty(padStr)) {
            padStr = " ";
        }
        if ((pads = size - (strLen = text.length())) <= 0) {
            return text.toString();
        }
        text = StringKit.padPre(text, strLen + pads / 2, padStr);
        text = StringKit.padAfter(text, size, padStr);
        return text.toString();
    }

    public static String padPre(CharSequence text, int minLength, CharSequence padStr) {
        if (null == text) {
            return null;
        }
        int strLen = text.length();
        if (strLen == minLength) {
            return text.toString();
        }
        if (strLen > minLength) {
            return StringKit.subPre(text, minLength);
        }
        return StringKit.repeatByLength(padStr, minLength - strLen).concat(text.toString());
    }

    public static String padPre(CharSequence text, int minLength, char padChar) {
        if (null == text) {
            return null;
        }
        int strLen = text.length();
        if (strLen == minLength) {
            return text.toString();
        }
        if (strLen > minLength) {
            return StringKit.subPre(text, minLength);
        }
        return StringKit.repeat(padChar, minLength - strLen).concat(text.toString());
    }

    public static String padAfter(CharSequence text, int minLength, char padChar) {
        if (null == text) {
            return null;
        }
        int strLen = text.length();
        if (strLen == minLength) {
            return text.toString();
        }
        if (strLen > minLength) {
            return StringKit.sub(text, strLen - minLength, strLen);
        }
        return text.toString().concat(StringKit.repeat(padChar, minLength - strLen));
    }

    public static String padAfter(CharSequence text, int minLength, CharSequence padStr) {
        if (null == text) {
            return null;
        }
        int strLen = text.length();
        if (strLen == minLength) {
            return text.toString();
        }
        if (strLen > minLength) {
            return StringKit.subByLength(text, minLength);
        }
        return text.toString().concat(StringKit.repeatByLength(padStr, minLength - strLen));
    }

    public static boolean equalsCharAt(CharSequence text, int position, char c) {
        if (null == text || position < 0) {
            return false;
        }
        return text.length() > position && c == text.charAt(position);
    }

    public static String sort(String text) {
        if (StringKit.isEmpty(text) || "".equalsIgnoreCase(text)) {
            return null;
        }
        char[] strArray = text.toCharArray();
        Arrays.sort(strArray);
        return String.valueOf(strArray);
    }

    public static String filter(CharSequence text, Filter<Character> filter) {
        if (null == text || null == filter) {
            return StringKit.toString(text);
        }
        int len = text.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = text.charAt(i);
            if (!filter.accept(Character.valueOf(c))) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public static double similar(String str1, String str2) {
        return Similarity.similar(str1, str2);
    }

    public static String similar(String str1, String str2, int scale) {
        return Similarity.similar(str1, str2, scale);
    }

    public static String newLine(String content, int length) {
        String stVal = "";
        if (length > 0) {
            if (content.length() > length) {
                int rows = (content.length() + length - 1) / length;
                for (int i = 0; i < rows; ++i) {
                    stVal = i == rows - 1 ? stVal + content.substring(i * length) : stVal + content.substring(i * length, i * length + length) + "\r\n";
                }
            } else {
                stVal = content;
            }
        }
        return stVal;
    }

    public <T extends CharSequence> T firstNonNull(T ... texts) {
        return (T)((CharSequence)ArrayKit.firstNonNull(texts));
    }

    public <T extends CharSequence> T firstNonEmpty(T ... texts) {
        return (T)ArrayKit.firstNonNull(StringKit::isNotEmpty, texts);
    }

    public <T extends CharSequence> T firstNonBlank(T ... texts) {
        return (T)ArrayKit.firstNonNull(StringKit::isNotBlank, texts);
    }

    public CharSequence cover(String text, int start, int len, Character character) {
        if (start < 0 || len > text.length()) {
            throw new IndexOutOfBoundsException();
        }
        int end = start + len;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            sb.append(start <= i && i < end ? character.charValue() : text.charAt(i));
        }
        return sb;
    }
}

