/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.crypto.symmetric;

import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import org.aoju.bus.core.lang.Algorithm;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.crypto.Builder;
import org.aoju.bus.crypto.Mode;
import org.aoju.bus.crypto.Padding;
import org.aoju.bus.crypto.symmetric.Crypto;

public class DESede
extends Crypto {
    private static final long serialVersionUID = 1L;

    public DESede() {
        super(Algorithm.DESEDE);
    }

    public DESede(byte[] key) {
        super(Algorithm.DESEDE, key);
    }

    public DESede(Mode mode, Padding padding) {
        this(mode.name(), padding.name());
    }

    public DESede(Mode mode, Padding padding, byte[] key) {
        this(mode, padding, key, null);
    }

    public DESede(Mode mode, Padding padding, byte[] key, byte[] iv) {
        this(mode.name(), padding.name(), key, iv);
    }

    public DESede(Mode mode, Padding padding, SecretKey key) {
        this(mode, padding, key, null);
    }

    public DESede(Mode mode, Padding padding, SecretKey key, IvParameterSpec iv) {
        this(mode.name(), padding.name(), key, iv);
    }

    public DESede(String mode, String padding) {
        this(mode, padding, (byte[])null);
    }

    public DESede(String mode, String padding, byte[] key) {
        this(mode, padding, key, null);
    }

    public DESede(String mode, String padding, byte[] key, byte[] iv) {
        this(mode, padding, Builder.generateKey(Algorithm.DESEDE.getValue(), key), null == iv ? null : new IvParameterSpec(iv));
    }

    public DESede(String mode, String padding, SecretKey key) {
        this(mode, padding, key, null);
    }

    public DESede(String mode, String padding, SecretKey key, IvParameterSpec iv) {
        super(StringKit.format("{}/{}/{}", Algorithm.DESEDE.getValue(), mode, padding), key, iv);
    }
}

