/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.mac.hardware;

import com.sun.jna.Native;
import com.sun.jna.Structure;
import com.sun.jna.platform.mac.SystemB;
import com.sun.jna.ptr.IntByReference;
import java.util.function.Supplier;
import org.aoju.bus.core.annotation.ThreadSafe;
import org.aoju.bus.core.lang.tuple.Pair;
import org.aoju.bus.health.Builder;
import org.aoju.bus.health.Memoize;
import org.aoju.bus.health.builtin.hardware.AbstractVirtualMemory;
import org.aoju.bus.health.mac.SysctlKit;
import org.aoju.bus.health.mac.hardware.MacGlobalMemory;
import org.aoju.bus.logger.Logger;

@ThreadSafe
final class MacVirtualMemory
extends AbstractVirtualMemory {
    private final MacGlobalMemory global;
    private final Supplier<Pair<Long, Long>> usedTotal = Memoize.memoize(MacVirtualMemory::querySwapUsage, Memoize.defaultExpiration());
    private final Supplier<Pair<Long, Long>> inOut = Memoize.memoize(MacVirtualMemory::queryVmStat, Memoize.defaultExpiration());

    MacVirtualMemory(MacGlobalMemory macGlobalMemory) {
        this.global = macGlobalMemory;
    }

    private static Pair<Long, Long> querySwapUsage() {
        long swapUsed = 0L;
        long swapTotal = 0L;
        SystemB.XswUsage xswUsage = new SystemB.XswUsage();
        if (SysctlKit.sysctl("vm.swapusage", (Structure)xswUsage)) {
            swapUsed = xswUsage.xsu_used;
            swapTotal = xswUsage.xsu_total;
        }
        return Pair.of(swapUsed, swapTotal);
    }

    private static Pair<Long, Long> queryVmStat() {
        long swapPagesIn = 0L;
        long swapPagesOut = 0L;
        SystemB.VMStatistics vmStats = new SystemB.VMStatistics();
        if (0 == SystemB.INSTANCE.host_statistics(SystemB.INSTANCE.mach_host_self(), 2, (Structure)vmStats, new IntByReference(vmStats.size() / SystemB.INT_SIZE))) {
            swapPagesIn = Builder.unsignedIntToLong(vmStats.pageins);
            swapPagesOut = Builder.unsignedIntToLong(vmStats.pageouts);
        } else {
            Logger.error("Failed to get host VM info. Error code: {}", Native.getLastError());
        }
        return Pair.of(swapPagesIn, swapPagesOut);
    }

    @Override
    public long getSwapUsed() {
        return this.usedTotal.get().getLeft();
    }

    @Override
    public long getSwapTotal() {
        return this.usedTotal.get().getRight();
    }

    @Override
    public long getVirtualMax() {
        return this.global.getTotal() + this.getSwapTotal();
    }

    @Override
    public long getVirtualInUse() {
        return this.global.getTotal() - this.global.getAvailable() + this.getSwapUsed();
    }

    @Override
    public long getSwapPagesIn() {
        return this.inOut.get().getLeft();
    }

    @Override
    public long getSwapPagesOut() {
        return this.inOut.get().getRight();
    }
}

