/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.unix.openbsd.hardware;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.aoju.bus.core.lang.tuple.Pair;
import org.aoju.bus.core.lang.tuple.Triple;
import org.aoju.bus.health.Builder;
import org.aoju.bus.health.Executor;
import org.aoju.bus.health.Memoize;
import org.aoju.bus.health.builtin.hardware.AbstractCentralProcessor;
import org.aoju.bus.health.builtin.hardware.CentralProcessor;
import org.aoju.bus.health.unix.openbsd.OpenBsdLibc;
import org.aoju.bus.health.unix.openbsd.OpenBsdSysctlKit;

public class OpenBsdCentralProcessor
extends AbstractCentralProcessor {
    private static final Pattern DMESG_CPU = Pattern.compile("cpu(\\d+): smt (\\d+), core (\\d+), package (\\d+)");
    private final Supplier<Pair<Long, Long>> vmStats = Memoize.memoize(OpenBsdCentralProcessor::queryVmStats, Memoize.defaultExpiration());

    private static Triple<Integer, Integer, Integer> cpuidToFamilyModelStepping(int cpuid) {
        int family = cpuid >> 16 & 0xFF0 | cpuid >> 8 & 0xF;
        int model = cpuid >> 12 & 0xF0 | cpuid >> 4 & 0xF;
        int stepping = cpuid & 0xF;
        return Triple.of(family, model, stepping);
    }

    private static Pair<Long, Long> queryVmStats() {
        long contextSwitches = 0L;
        long interrupts = 0L;
        List<String> vmstat = Executor.runNative("vmstat -s");
        for (String line : vmstat) {
            if (line.endsWith("cpu context switches")) {
                contextSwitches = Builder.getFirstIntValue(line);
                continue;
            }
            if (!line.endsWith("interrupts")) continue;
            interrupts = Builder.getFirstIntValue(line);
        }
        return Pair.of(contextSwitches, interrupts);
    }

    private static long[] cpTimeToTicks(Memory m, boolean force64bit) {
        int arraySize;
        long longBytes = force64bit ? 8L : (long)Native.LONG_SIZE;
        int n = arraySize = null == m ? 0 : (int)(m.size() / longBytes);
        if (force64bit && null != m) {
            return m.getLongArray(0L, arraySize);
        }
        long[] ticks = new long[arraySize];
        for (int i = 0; i < arraySize; ++i) {
            ticks[i] = m.getNativeLong((long)i * longBytes).longValue();
        }
        return ticks;
    }

    @Override
    protected CentralProcessor.ProcessorIdentifier queryProcessorId() {
        String cpuVendor = OpenBsdSysctlKit.sysctl("machdep.cpuvendor", "");
        int[] mib = new int[]{6, 2};
        String cpuName = OpenBsdSysctlKit.sysctl(mib, "");
        int cpuid = Builder.hexStringToInt(OpenBsdSysctlKit.sysctl("machdep.cpuid", ""), 0);
        int cpufeature = Builder.hexStringToInt(OpenBsdSysctlKit.sysctl("machdep.cpufeature", ""), 0);
        Triple<Integer, Integer, Integer> cpu = OpenBsdCentralProcessor.cpuidToFamilyModelStepping(cpuid);
        String cpuFamily = cpu.getLeft().toString();
        String cpuModel = cpu.getMiddle().toString();
        String cpuStepping = cpu.getRight().toString();
        long cpuFreq = Builder.parseHertz(cpuName);
        if (cpuFreq < 0L) {
            cpuFreq = this.queryMaxFreq();
        }
        mib[1] = 1;
        String machine = OpenBsdSysctlKit.sysctl(mib, "");
        boolean cpu64bit = null != machine && machine.contains("64") || Executor.getFirstAnswer("uname -m").trim().contains("64");
        String processorID = String.format("%08x%08x", cpufeature, cpuid);
        return new CentralProcessor.ProcessorIdentifier(cpuVendor, cpuName, cpuFamily, cpuModel, cpuStepping, processorID, cpu64bit, cpuFreq);
    }

    @Override
    protected long queryMaxFreq() {
        return this.queryCurrentFreq()[0];
    }

    @Override
    protected long[] queryCurrentFreq() {
        long[] freq = new long[1];
        int[] mib = new int[]{6, 12};
        freq[0] = OpenBsdSysctlKit.sysctl(mib, 0L) * 1000000L;
        return freq;
    }

    @Override
    protected List<CentralProcessor.LogicalProcessor> initProcessorCounts() {
        HashMap<Integer, Integer> coreMap = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> packageMap = new HashMap<Integer, Integer>();
        for (String line : Executor.runNative("dmesg")) {
            Matcher m = DMESG_CPU.matcher(line);
            if (!m.matches()) continue;
            int cpu = Builder.parseIntOrDefault(m.group(1), 0);
            coreMap.put(cpu, Builder.parseIntOrDefault(m.group(3), 0));
            packageMap.put(cpu, Builder.parseIntOrDefault(m.group(4), 0));
        }
        int logicalProcessorCount = OpenBsdSysctlKit.sysctl("hw.ncpuonline", 1);
        if (logicalProcessorCount < coreMap.keySet().size()) {
            logicalProcessorCount = coreMap.keySet().size();
        }
        ArrayList<CentralProcessor.LogicalProcessor> logProcs = new ArrayList<CentralProcessor.LogicalProcessor>(logicalProcessorCount);
        for (int i = 0; i < logicalProcessorCount; ++i) {
            logProcs.add(new CentralProcessor.LogicalProcessor(i, coreMap.getOrDefault(i, 0), packageMap.getOrDefault(i, 0)));
        }
        return logProcs;
    }

    @Override
    protected long queryContextSwitches() {
        return this.vmStats.get().getLeft();
    }

    @Override
    protected long queryInterrupts() {
        return this.vmStats.get().getRight();
    }

    @Override
    protected long[] querySystemCpuLoadTicks() {
        long[] ticks = new long[CentralProcessor.TickType.values().length];
        int[] mib = new int[]{1, 40};
        Memory m = OpenBsdSysctlKit.sysctl(mib);
        long[] cpuTicks = OpenBsdCentralProcessor.cpTimeToTicks(m, false);
        if (cpuTicks.length >= 5) {
            ticks[CentralProcessor.TickType.USER.getIndex()] = cpuTicks[0];
            ticks[CentralProcessor.TickType.NICE.getIndex()] = cpuTicks[1];
            ticks[CentralProcessor.TickType.SYSTEM.getIndex()] = cpuTicks[2];
            int offset = cpuTicks.length > 5 ? 1 : 0;
            ticks[CentralProcessor.TickType.IRQ.getIndex()] = cpuTicks[3 + offset];
            ticks[CentralProcessor.TickType.IDLE.getIndex()] = cpuTicks[4 + offset];
        }
        return ticks;
    }

    @Override
    protected long[][] queryProcessorCpuLoadTicks() {
        long[][] ticks = new long[this.getLogicalProcessorCount()][CentralProcessor.TickType.values().length];
        int[] mib = new int[3];
        mib[0] = 1;
        mib[1] = 71;
        for (int cpu = 0; cpu < this.getLogicalProcessorCount(); ++cpu) {
            mib[2] = cpu;
            Memory m = OpenBsdSysctlKit.sysctl(mib);
            long[] cpuTicks = OpenBsdCentralProcessor.cpTimeToTicks(m, true);
            if (cpuTicks.length < 5) continue;
            ticks[cpu][CentralProcessor.TickType.USER.getIndex()] = cpuTicks[0];
            ticks[cpu][CentralProcessor.TickType.NICE.getIndex()] = cpuTicks[1];
            ticks[cpu][CentralProcessor.TickType.SYSTEM.getIndex()] = cpuTicks[2];
            int offset = cpuTicks.length > 5 ? 1 : 0;
            ticks[cpu][CentralProcessor.TickType.IRQ.getIndex()] = cpuTicks[3 + offset];
            ticks[cpu][CentralProcessor.TickType.IDLE.getIndex()] = cpuTicks[4 + offset];
        }
        return ticks;
    }

    @Override
    public double[] getSystemLoadAverage(int nelem) {
        if (nelem < 1 || nelem > 3) {
            throw new IllegalArgumentException("Must include from one to three elements.");
        }
        double[] average = new double[nelem];
        int retval = OpenBsdLibc.INSTANCE.getloadavg(average, nelem);
        if (retval < nelem) {
            Arrays.fill(average, -1.0);
        }
        return average;
    }
}

