/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.unix.openbsd.hardware;

import java.util.function.Supplier;
import org.aoju.bus.health.Memoize;
import org.aoju.bus.health.builtin.hardware.AbstractComputerSystem;
import org.aoju.bus.health.builtin.hardware.Baseboard;
import org.aoju.bus.health.builtin.hardware.Firmware;
import org.aoju.bus.health.unix.UnixBaseboard;
import org.aoju.bus.health.unix.openbsd.OpenBsdSysctlKit;
import org.aoju.bus.health.unix.openbsd.hardware.OpenBsdFirmware;

public class OpenBsdComputerSystem
extends AbstractComputerSystem {
    private final Supplier<String> manufacturer = Memoize.memoize(OpenBsdComputerSystem::queryManufacturer);
    private final Supplier<String> model = Memoize.memoize(OpenBsdComputerSystem::queryModel);
    private final Supplier<String> serialNumber = Memoize.memoize(OpenBsdComputerSystem::querySerialNumber);
    private final Supplier<String> uuid = Memoize.memoize(OpenBsdComputerSystem::queryUUID);

    private static String queryManufacturer() {
        return OpenBsdSysctlKit.sysctl("hw.vendor", "unknown");
    }

    private static String queryModel() {
        return OpenBsdSysctlKit.sysctl("hw.version", "unknown");
    }

    private static String querySerialNumber() {
        return OpenBsdSysctlKit.sysctl("hw.serialno", "unknown");
    }

    private static String queryUUID() {
        return OpenBsdSysctlKit.sysctl("hw.uuid", "unknown");
    }

    @Override
    public String getManufacturer() {
        return this.manufacturer.get();
    }

    @Override
    public String getModel() {
        return this.model.get();
    }

    @Override
    public String getSerialNumber() {
        return this.serialNumber.get();
    }

    @Override
    public String getHardwareUUID() {
        return this.uuid.get();
    }

    @Override
    protected Firmware createFirmware() {
        return new OpenBsdFirmware();
    }

    @Override
    protected Baseboard createBaseboard() {
        return new UnixBaseboard(this.manufacturer.get(), this.model.get(), this.serialNumber.get(), OpenBsdSysctlKit.sysctl("hw.product", "unknown"));
    }
}

