/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.unix.openbsd.hardware;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.aoju.bus.core.annotation.ThreadSafe;
import org.aoju.bus.core.lang.RegEx;
import org.aoju.bus.core.lang.tuple.Triple;
import org.aoju.bus.health.Builder;
import org.aoju.bus.health.Executor;
import org.aoju.bus.health.Memoize;
import org.aoju.bus.health.builtin.hardware.AbstractSensors;

@ThreadSafe
final class OpenBsdSensors
extends AbstractSensors {
    private final Supplier<Triple<Double, int[], Double>> tempFanVolts = Memoize.memoize(OpenBsdSensors::querySensors, Memoize.defaultExpiration());

    OpenBsdSensors() {
    }

    private static Triple<Double, int[], Double> querySensors() {
        double volts = 0.0;
        ArrayList<Double> cpuTemps = new ArrayList<Double>();
        ArrayList<Double> allTemps = new ArrayList<Double>();
        ArrayList<Integer> fanRPMs = new ArrayList<Integer>();
        for (String line : Executor.runNative("systat -ab sensors")) {
            String[] split = RegEx.SPACES.split(line);
            if (split.length <= 1) continue;
            if (split[0].contains("cpu")) {
                if (split[0].contains("temp0")) {
                    cpuTemps.add(Builder.parseDoubleOrDefault(split[1], Double.NaN));
                    continue;
                }
                if (!split[0].contains("volt0")) continue;
                volts = Builder.parseDoubleOrDefault(split[1], 0.0);
                continue;
            }
            if (split[0].contains("temp0")) {
                allTemps.add(Builder.parseDoubleOrDefault(split[1], Double.NaN));
                continue;
            }
            if (!split[0].contains("fan")) continue;
            fanRPMs.add(Builder.parseIntOrDefault(split[1], 0));
        }
        double temp = cpuTemps.isEmpty() ? OpenBsdSensors.listAverage(allTemps) : OpenBsdSensors.listAverage(cpuTemps);
        int[] fans = new int[fanRPMs.size()];
        for (int i = 0; i < fans.length; ++i) {
            fans[i] = (Integer)fanRPMs.get(i);
        }
        return Triple.of(temp, fans, volts);
    }

    private static double listAverage(List<Double> doubles) {
        double sum = 0.0;
        int count = 0;
        for (Double d : doubles) {
            if (d.isNaN()) continue;
            sum += d.doubleValue();
            ++count;
        }
        return count > 0 ? sum / (double)count : 0.0;
    }

    @Override
    public double queryCpuTemperature() {
        return this.tempFanVolts.get().getLeft();
    }

    @Override
    public int[] queryFanSpeeds() {
        return this.tempFanVolts.get().getMiddle();
    }

    @Override
    public double queryCpuVoltage() {
        return this.tempFanVolts.get().getRight();
    }
}

