/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.unix.solaris.drivers;

import com.sun.jna.platform.unix.solaris.LibKstat;
import org.aoju.bus.core.annotation.ThreadSafe;
import org.aoju.bus.core.lang.tuple.Pair;
import org.aoju.bus.health.unix.solaris.KstatKit;

@ThreadSafe
public final class SystemPages {
    private SystemPages() {
    }

    public static Pair<Long, Long> queryAvailableTotal() {
        long memAvailable = 0L;
        long memTotal = 0L;
        try (KstatKit.KstatChain kc = KstatKit.openChain();){
            LibKstat.Kstat ksp = KstatKit.KstatChain.lookup(null, -1, "system_pages");
            if (null != ksp && KstatKit.KstatChain.read(ksp)) {
                memAvailable = KstatKit.dataLookupLong(ksp, "availrmem");
                memTotal = KstatKit.dataLookupLong(ksp, "physmem");
            }
        }
        return Pair.of(memAvailable, memTotal);
    }
}

