/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.toolkit.CollKit;
import org.aoju.bus.core.toolkit.MapKit;
import org.aoju.bus.core.toolkit.ObjectKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.core.toolkit.XmlKit;
import org.aoju.bus.http.Httpz;
import org.aoju.bus.http.Protocol;
import org.aoju.bus.http.magic.HttpResponse;
import org.aoju.bus.http.magic.PostBuilder;

public class SoapX {
    private static final String CONTENT_TYPE_SOAP11_TEXT_XML = "text/xml;charset=";
    private static final String CONTENT_TYPE_SOAP12_SOAP_XML = "application/soap+xml;charset=";
    private String charset = "UTF-8";
    private String version = "HTTP/1.1";
    private Protocol protocol;
    private String url;
    private String namespaceURI;
    private MessageFactory factory;
    private SOAPMessage message;
    private SOAPBodyElement methodEle;
    private Map<String, String> headers = new HashMap<String, String>();

    public SoapX(String url) {
        this(url, Protocol.SOAP_1_1);
    }

    public SoapX(String url, Protocol protocol) {
        this(url, protocol, null);
    }

    public SoapX(String url, Protocol protocol, String namespaceURI) {
        this.url = url;
        this.namespaceURI = namespaceURI;
        this.protocol = protocol;
        try {
            this.factory = MessageFactory.newInstance((String)this.protocol.toString());
            this.message = this.factory.createMessage();
        }
        catch (SOAPException e) {
            throw new InstrumentException(e);
        }
    }

    public static SoapX create(String url) {
        return new SoapX(url);
    }

    public static SoapX create(String url, Protocol protocol) {
        return new SoapX(url, protocol);
    }

    public static SoapX create(String url, Protocol protocol, String namespaceURI) {
        return new SoapX(url, protocol, namespaceURI);
    }

    public SoapX url(String url) {
        this.url = url;
        return this;
    }

    public SoapX charset(String charset) {
        if (null != charset) {
            this.charset = charset;
        }
        try {
            this.message.setProperty("javax.xml.soap.character-set-encoding", (Object)this.charset);
            this.message.setProperty("javax.xml.soap.write-xml-declaration", (Object)"true");
        }
        catch (SOAPException sOAPException) {
            // empty catch block
        }
        return this;
    }

    public SoapX method(Name name, Map<String, Object> params) {
        return this.method(new QName(name.getURI(), name.getLocalName(), name.getPrefix()), params);
    }

    public SoapX method(QName name, Map<String, Object> params) {
        this.method(name);
        String prefix = name.getPrefix();
        SOAPBodyElement methodEle = this.methodEle;
        for (Map.Entry<String, Object> entry : MapKit.wrap(params)) {
            this.param((SOAPElement)methodEle, entry.getKey(), entry.getValue(), prefix);
        }
        return this;
    }

    public SoapX method(String methodName) {
        return this.method(methodName, ObjectKit.defaultIfNull(this.namespaceURI, ""));
    }

    public SoapX method(String methodName, String namespaceURI) {
        List<String> methodNameList = StringKit.split((CharSequence)methodName, ':');
        QName qName = 2 == methodNameList.size() ? new QName(namespaceURI, methodNameList.get(1), methodNameList.get(0)) : new QName(namespaceURI, methodName);
        return this.method(qName);
    }

    public SoapX method(QName name) {
        try {
            this.methodEle = this.message.getSOAPBody().addBodyElement(name);
        }
        catch (SOAPException e) {
            throw new InstrumentException(e);
        }
        return this;
    }

    public SoapX param(String name, Object value) {
        return this.param(name, value, true);
    }

    public SoapX param(String name, Object value, boolean useMethodPrefix) {
        this.param((SOAPElement)this.methodEle, name, value, useMethodPrefix ? this.methodEle.getPrefix() : null);
        return this;
    }

    public SoapX param(Map<String, Object> params) {
        return this.param(params, true);
    }

    public SoapX param(Map<String, Object> params, boolean useMethodPrefix) {
        for (Map.Entry<String, Object> entry : MapKit.wrap(params)) {
            this.param(entry.getKey(), entry.getValue(), useMethodPrefix);
        }
        return this;
    }

    public SOAPElement param(SOAPElement ele, String name, Object value, String prefix) {
        SOAPElement childEle;
        try {
            childEle = StringKit.isNotBlank(prefix) ? ele.addChildElement(name, prefix) : ele.addChildElement(name);
        }
        catch (SOAPException e) {
            throw new InstrumentException(e);
        }
        if (null != value) {
            if (value instanceof SOAPElement) {
                try {
                    ele.addChildElement((SOAPElement)value);
                }
                catch (SOAPException e) {
                    throw new InstrumentException(e);
                }
            } else if (value instanceof Map) {
                Iterator iterator = ((Map)value).entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry obj;
                    Map.Entry entry = obj = iterator.next();
                    this.param(childEle, entry.getKey().toString(), entry.getValue(), prefix);
                }
            } else {
                childEle.setValue(value.toString());
            }
        }
        return childEle;
    }

    public String version() {
        return this.version;
    }

    public SoapX version(String version) {
        this.version = version;
        return this;
    }

    public SoapX headers(String name, String value, boolean isOverride) {
        if (null != name && null != value) {
            String values = this.headers.get(name.trim());
            if (isOverride || StringKit.isEmpty(values)) {
                this.headers.put(name.trim(), value);
            }
        }
        return this;
    }

    public Map<String, String> headers() {
        return Collections.unmodifiableMap(this.headers);
    }

    public SoapX headers(String name, String value) {
        return this.headers(name, value, true);
    }

    public SoapX headers(Map<String, String> headers, boolean isOverride) {
        if (CollKit.isEmpty(headers)) {
            return this;
        }
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            this.headers(entry.getKey(), StringKit.nullToEmpty(entry.getValue()), isOverride);
        }
        return this;
    }

    public SoapX headers(Map<String, String> headers) {
        if (CollKit.isEmpty(headers)) {
            return this;
        }
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            this.headers(entry.getKey(), StringKit.nullToEmpty(entry.getValue()), false);
        }
        return this;
    }

    public SOAPHeaderElement addSOAPHeader(QName name, String actorURI, String roleUri, Boolean mustUnderstand, Boolean relay) {
        SOAPHeaderElement ele = this.addSOAPHeader(name);
        try {
            if (StringKit.isNotBlank(roleUri)) {
                ele.setRole(roleUri);
            }
            if (null != relay) {
                ele.setRelay(relay.booleanValue());
            }
        }
        catch (SOAPException e) {
            throw new InstrumentException(e);
        }
        if (StringKit.isNotBlank(actorURI)) {
            ele.setActor(actorURI);
        }
        if (null != mustUnderstand) {
            ele.setMustUnderstand(mustUnderstand.booleanValue());
        }
        return ele;
    }

    public SOAPHeaderElement addSOAPHeader(String localName) {
        return this.addSOAPHeader(new QName(localName));
    }

    public SOAPHeaderElement addSOAPHeader(String localName, String value) {
        SOAPHeaderElement soapHeaderElement = this.addSOAPHeader(localName);
        soapHeaderElement.setTextContent(value);
        return soapHeaderElement;
    }

    public SOAPHeaderElement addSOAPHeader(QName name) {
        SOAPHeaderElement ele;
        try {
            ele = this.message.getSOAPHeader().addHeaderElement(name);
        }
        catch (SOAPException e) {
            throw new InstrumentException(e);
        }
        return ele;
    }

    public String toString(SOAPMessage message, boolean format, String charset) {
        String result;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            message.writeTo((OutputStream)out);
            result = out.toString(charset);
        }
        catch (IOException | SOAPException e) {
            throw new InstrumentException(e);
        }
        return format ? XmlKit.format(result) : result;
    }

    public SoapX reset() {
        try {
            this.message = this.factory.createMessage();
        }
        catch (SOAPException e) {
            throw new InstrumentException(e);
        }
        this.methodEle = null;
        return this;
    }

    public SOAPBodyElement getMethodEle() {
        return this.methodEle;
    }

    public SOAPMessage getMessage() {
        return this.message;
    }

    public String getMessage(boolean format) {
        return this.toString(this.message, format, this.charset);
    }

    public SoapX removeHeader(String name) {
        if (name != null) {
            this.headers.remove(name.trim());
        }
        return this;
    }

    public SoapX write(OutputStream out) {
        try {
            this.message.writeTo(out);
        }
        catch (IOException | SOAPException e) {
            throw new InstrumentException(e);
        }
        return this;
    }

    public SOAPMessage send() {
        try {
            HttpResponse res = this.transpond();
            MimeHeaders headers = new MimeHeaders();
            for (Map.Entry<String, List<String>> entry : res.headers().toMultimap().entrySet()) {
                if (!StringKit.isNotEmpty(entry.getKey())) continue;
                headers.setHeader(entry.getKey(), (String)CollKit.get((Collection)entry.getValue(), 0));
            }
            this.message = this.factory.createMessage(headers, res.body().byteStream());
            return this.message;
        }
        catch (IOException | SOAPException e) {
            throw new InstrumentException(e);
        }
    }

    public String send(boolean format) {
        String result = "";
        try {
            HttpResponse response = this.transpond();
            if (null != response.body()) {
                byte[] bytes = response.body().bytes();
                result = new String(bytes, this.charset);
            }
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
        return format ? XmlKit.format(result) : result;
    }

    public HttpResponse transpond() {
        try {
            this.headers("Content-Type", this.getContentType());
            return ((PostBuilder)((PostBuilder)Httpz.post().url(this.url)).headers(this.headers)).body(this.getMessage(false)).build().execute();
        }
        catch (Exception e) {
            throw new InstrumentException(e);
        }
    }

    public String getContentType() {
        switch (this.protocol) {
            case SOAP_1_1: {
                return CONTENT_TYPE_SOAP11_TEXT_XML.concat(this.charset);
            }
            case SOAP_1_2: {
                return CONTENT_TYPE_SOAP12_SOAP_XML.concat(this.charset);
            }
        }
        throw new InstrumentException("Unsupported protocol: " + (Object)((Object)this.protocol));
    }
}

