/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.http.bodys;

import java.io.IOException;
import org.aoju.bus.core.io.Buffer;
import org.aoju.bus.core.io.BufferSink;
import org.aoju.bus.http.Request;
import org.aoju.bus.http.bodys.OutputStreamBody;

public final class BufferedBody
extends OutputStreamBody {
    final Buffer buffer = new Buffer();
    long contentLength = -1L;

    public BufferedBody(long expectedContentLength) {
        this.initOutputStream(this.buffer, expectedContentLength);
    }

    @Override
    public long contentLength() {
        return this.contentLength;
    }

    @Override
    public Request prepareToSendRequest(Request request) throws IOException {
        if (null != request.header("Content-Length")) {
            return request;
        }
        this.outputStream().close();
        this.contentLength = this.buffer.size();
        return request.newBuilder().removeHeader("Transfer-Encoding").header("Content-Length", Long.toString(this.buffer.size())).build();
    }

    @Override
    public void writeTo(BufferSink sink) {
        this.buffer.copyTo(sink.buffer(), 0L, this.buffer.size());
    }
}

