/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.plugin;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.GeneralSecurityException;
import java.text.MessageFormat;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.image.Args;
import org.aoju.bus.image.Builder;
import org.aoju.bus.image.Centre;
import org.aoju.bus.image.Node;
import org.aoju.bus.image.Status;
import org.aoju.bus.image.galaxy.data.Attributes;
import org.aoju.bus.image.galaxy.data.Sequence;
import org.aoju.bus.image.galaxy.data.VR;
import org.aoju.bus.image.metric.Connection;
import org.aoju.bus.image.plugin.CFind;
import org.aoju.bus.image.plugin.FindSCU;
import org.aoju.bus.image.plugin.MppsSCU;
import org.aoju.bus.image.plugin.StgSCU;
import org.aoju.bus.image.plugin.StoreSCU;
import org.aoju.bus.logger.Logger;

public class Modality {
    public static String calledAET;

    public static Status process(Node callingNode, Node calledNode, Args ... keys) {
        return Modality.process(null, callingNode, calledNode, 0, keys);
    }

    public static Status process(Args args, Node callingNode, Node calledNode, Args ... keys) {
        return Modality.process(args, callingNode, calledNode, 0, keys);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public static Status process(Args args, Node callingNode, Node calledNode, int cancelAfter, Args ... keys) {
        if (null == callingNode || null == calledNode) {
            throw new IllegalArgumentException("callingNode or calledNode cannot be null!");
        }
        try {
            Throwable throwable = null;
            try (FindSCU findSCU = new FindSCU();){
                Status status;
                Connection remote = findSCU.getRemoteConnection();
                Connection conn = findSCU.getConnection();
                args.configureBind(findSCU.getAAssociateRQ(), remote, calledNode);
                args.configureBind(findSCU.getApplicationEntity(), conn, callingNode);
                Centre centre = new Centre(findSCU.getDevice());
                args.configure(conn);
                args.configureTLS(conn, remote);
                findSCU.setInformationModel(Modality.getInformationModel(args), args.getTsuidOrder(), args.getTypes());
                Modality.addKeys(findSCU, keys);
                findSCU.setCancelAfter(cancelAfter);
                findSCU.setPriority(args.getPriority());
                centre.start(true);
                try {
                    Status dcmState = findSCU.getState();
                    long t1 = System.currentTimeMillis();
                    findSCU.open();
                    long t2 = System.currentTimeMillis();
                    findSCU.query();
                    Builder.forceGettingAttributes(dcmState, findSCU);
                    long t3 = System.currentTimeMillis();
                    String timeMsg = MessageFormat.format("DICOM C-Find connected in {2}ms from {0} to {1}. Query in {3}ms.", findSCU.getAAssociateRQ().getCallingAET(), findSCU.getAAssociateRQ().getCalledAET(), t2 - t1, t3 - t2);
                    status = Status.build(dcmState, timeMsg, null);
                }
                catch (Exception e) {
                    Status status2;
                    block23: {
                        block24: {
                            Logger.error("findscu", e);
                            Builder.forceGettingAttributes(findSCU.getState(), findSCU);
                            status2 = Status.build(findSCU.getState(), null, e);
                            Builder.close(findSCU);
                            centre.stop();
                            if (findSCU == null) break block23;
                            if (throwable == null) break block24;
                            try {
                                findSCU.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            break block23;
                        }
                        findSCU.close();
                    }
                    return status2;
                    {
                        catch (Throwable throwable3) {
                            try {
                                Builder.close(findSCU);
                                centre.stop();
                                throw throwable3;
                            }
                            catch (Throwable throwable4) {
                                throwable = throwable4;
                                throw throwable4;
                            }
                        }
                    }
                }
                Builder.close(findSCU);
                centre.stop();
                return status;
            }
        }
        catch (Exception e) {
            Logger.error("findscu", e);
            return new Status(49152, "DICOM Find failed :" + e.getMessage(), null);
        }
    }

    private static void addKeys(FindSCU findSCU, Args[] keys) {
        for (Args p : keys) {
            int[] pSeq = p.getParentSeqTags();
            if (null == pSeq || pSeq.length == 0) {
                CFind.addAttributes(findSCU.getKeys(), p);
                continue;
            }
            Attributes parent = findSCU.getKeys();
            for (int value : pSeq) {
                Sequence lastSeq = parent.getSequence(value);
                if (null == lastSeq || lastSeq.isEmpty()) {
                    lastSeq = parent.newSequence(value, 1);
                    lastSeq.add(new Attributes());
                }
                parent = (Attributes)lastSeq.get(0);
            }
            CFind.addAttributes(parent, p);
        }
    }

    private static FindSCU.InformationModel getInformationModel(Args options) {
        Object model = options.getInformationModel();
        if (model instanceof FindSCU.InformationModel) {
            return (FindSCU.InformationModel)((Object)model);
        }
        return FindSCU.InformationModel.MWL;
    }

    public static void setTlsParams(Connection remote, Connection conn) {
        remote.setTlsProtocols(conn.getTlsProtocols());
        remote.setTlsCipherSuites(conn.getTlsCipherSuites());
    }

    private static void addReferencedPerformedProcedureStepSequence(String mppsiuid, StoreSCU storescu) {
        Attributes attrs = storescu.getAttributes();
        Sequence seq = attrs.newSequence(528657, 1);
        Attributes item = new Attributes(2);
        item.setString(528720, VR.UI, "1.2.840.10008.3.1.2.3.3");
        item.setString(528725, VR.UI, mppsiuid);
        seq.add(item);
    }

    private static void nullifyReferencedPerformedProcedureStepSequence(StoreSCU storescu) {
        Attributes attrs = storescu.getAttributes();
        attrs.setNull(528657, VR.SQ);
    }

    private static void sendStgCmt(StgSCU stgcmtscu) throws IOException, InterruptedException, InstrumentException, GeneralSecurityException {
        Modality.printNextStepMessage("Will now send Storage Commitment to " + calledAET);
        try {
            stgcmtscu.open();
            stgcmtscu.sendRequests();
        }
        finally {
            stgcmtscu.close();
        }
    }

    private static void sendMpps(MppsSCU mppsscu, boolean sendNSet) throws IOException, InterruptedException, InstrumentException, GeneralSecurityException {
        try {
            Modality.printNextStepMessage("Will now send MPPS N-CREATE to " + calledAET);
            mppsscu.open();
            mppsscu.createMpps();
            if (sendNSet) {
                Modality.printNextStepMessage("Will now send MPPS N-SET to " + calledAET);
                mppsscu.updateMpps();
            }
        }
        finally {
            mppsscu.close();
        }
    }

    private static void sendMppsNSet(MppsSCU mppsscu) throws IOException, InterruptedException, InstrumentException, GeneralSecurityException {
        try {
            Modality.printNextStepMessage("Will now send MPPS N-SET to " + calledAET);
            mppsscu.open();
            mppsscu.updateMpps();
        }
        finally {
            mppsscu.close();
        }
    }

    private static void printNextStepMessage(String message) throws IOException {
        Logger.info("===========================================================", new Object[0]);
        Logger.info(message + ". Press <enter> to continue.", new Object[0]);
        Logger.info("===========================================================", new Object[0]);
        new BufferedReader(new InputStreamReader(System.in)).read();
    }

    private static void sendObjects(StoreSCU storescu) throws IOException, InterruptedException, InstrumentException, GeneralSecurityException {
        Modality.printNextStepMessage("Will now send DICOM object(s) to " + calledAET);
        try {
            storescu.open();
            storescu.sendFiles();
        }
        finally {
            storescu.close();
        }
    }

    public static void setCalledAET(String calledAET) {
        Modality.calledAET = calledAET;
    }
}

