/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.office.support.excel.cell.values;

import org.aoju.bus.core.toolkit.DateKit;
import org.aoju.bus.office.Builder;
import org.aoju.bus.office.support.excel.cell.CellValue;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.util.NumberToTextConverter;

public class NumericCellValue
implements CellValue<Object> {
    private final Cell cell;

    public NumericCellValue(Cell cell) {
        this.cell = cell;
    }

    @Override
    public Object getValue() {
        double value = this.cell.getNumericCellValue();
        CellStyle style = this.cell.getCellStyle();
        if (null != style) {
            long longPart;
            if (Builder.isDateFormat(this.cell)) {
                return DateKit.date(this.cell.getDateCellValue());
            }
            String format = style.getDataFormatString();
            if (null != format && format.indexOf(46) < 0 && (double)(longPart = (long)value) == value) {
                return longPart;
            }
        }
        return Double.parseDouble(NumberToTextConverter.toText((double)value));
    }
}

