/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.office.support.excel.sax;

import java.util.List;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.lang.function.Func1;
import org.aoju.bus.office.support.excel.sax.RowHandler;

public abstract class AbstractRowHandler<T>
implements RowHandler {
    protected final int startRowIndex;
    protected final int endRowIndex;
    protected Func1<List<Object>, T> convertFunc;

    public AbstractRowHandler(int startRowIndex, int endRowIndex) {
        this.startRowIndex = startRowIndex;
        this.endRowIndex = endRowIndex;
    }

    @Override
    public void handle(int sheetIndex, long rowIndex, List<Object> rowList) {
        Assert.notNull(this.convertFunc);
        if (rowIndex < (long)this.startRowIndex || rowIndex > (long)this.endRowIndex) {
            return;
        }
        this.handleData(sheetIndex, rowIndex, this.convertFunc.callWithRuntimeException(rowList));
    }

    public abstract void handleData(int var1, long var2, T var4);
}

