/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.storage.provider;

import com.qiniu.common.QiniuException;
import com.qiniu.http.Response;
import com.qiniu.storage.BucketManager;
import com.qiniu.storage.Configuration;
import com.qiniu.storage.Region;
import com.qiniu.storage.UploadManager;
import com.qiniu.util.Auth;
import java.io.File;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.file.Path;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.storage.Builder;
import org.aoju.bus.storage.Context;
import org.aoju.bus.storage.magic.Attachs;
import org.aoju.bus.storage.magic.Message;
import org.aoju.bus.storage.provider.AbstractProvider;

public class QiniuYunOssProvider
extends AbstractProvider {
    private UploadManager uploadManager;
    private BucketManager bucketManager;
    private Auth auth;

    public QiniuYunOssProvider(Context context) {
        this.context = context;
        Assert.notBlank(this.context.getPrefix(), "[prefix] not defined", new Object[0]);
        Assert.notBlank(this.context.getBucket(), "[bucket] not defined", new Object[0]);
        Assert.notBlank(this.context.getAccessKey(), "[accessKey] not defined", new Object[0]);
        Assert.notBlank(this.context.getSecretKey(), "[secretKey] not defined", new Object[0]);
        Assert.notBlank(this.context.getRegion(), "[region] not defined", new Object[0]);
        Assert.notNull(this.context.isSecure(), "[secure] not defined", new Object[0]);
        this.auth = Auth.create((String)this.context.getAccessKey(), (String)this.context.getSecretKey());
        Region region = Region.autoRegion((String)this.context.getRegion());
        Configuration c = new Configuration(region);
        this.uploadManager = new UploadManager(c);
        this.bucketManager = new BucketManager(this.auth, c);
    }

    @Override
    public Message download(String fileKey) {
        String path = this.getFullPath(fileKey);
        if (this.context.isSecure()) {
            path = this.auth.privateDownloadUrl(path, 3600L);
        }
        try {
            String encodedFileName = URLEncoder.encode(fileKey, "UTF-8");
            String format = String.format("%s/%s", path, encodedFileName);
            return Message.builder().errcode(Builder.ErrorCode.SUCCESS.getCode()).errmsg(Builder.ErrorCode.SUCCESS.getMsg()).build();
        }
        catch (UnsupportedEncodingException e) {
            Logger.error("file download failed", e.getMessage());
            return Message.builder().errcode(Builder.ErrorCode.FAILURE.getCode()).errmsg(Builder.ErrorCode.FAILURE.getMsg()).build();
        }
    }

    @Override
    public Message download(String bucket, String fileName) {
        return Message.builder().errcode(Builder.ErrorCode.FAILURE.getCode()).errmsg(Builder.ErrorCode.FAILURE.getMsg()).build();
    }

    @Override
    public Message download(String bucket, String fileName, File file) {
        return Message.builder().errcode(Builder.ErrorCode.FAILURE.getCode()).errmsg(Builder.ErrorCode.FAILURE.getMsg()).build();
    }

    @Override
    public Message download(String fileName, File file) {
        return Message.builder().errcode(Builder.ErrorCode.FAILURE.getCode()).errmsg(Builder.ErrorCode.FAILURE.getMsg()).build();
    }

    @Override
    public Message list() {
        return Message.builder().errcode(Builder.ErrorCode.FAILURE.getCode()).errmsg(Builder.ErrorCode.FAILURE.getMsg()).build();
    }

    @Override
    public Message rename(String oldName, String newName) {
        return Message.builder().errcode(Builder.ErrorCode.FAILURE.getCode()).errmsg(Builder.ErrorCode.FAILURE.getMsg()).build();
    }

    @Override
    public Message rename(String bucket, String oldName, String newName) {
        return Message.builder().errcode(Builder.ErrorCode.FAILURE.getCode()).errmsg(Builder.ErrorCode.FAILURE.getMsg()).build();
    }

    @Override
    public Message upload(String fileName, byte[] content) {
        return this.upload(this.context.getBucket(), fileName, content);
    }

    @Override
    public Message upload(String bucket, String fileName, InputStream content) {
        try {
            String upToken = this.auth.uploadToken(bucket);
            Response response = this.uploadManager.put(content, fileName, upToken, null, null);
            if (!response.isOK()) {
                return Message.builder().errcode(Builder.ErrorCode.FAILURE.getCode()).errmsg(Builder.ErrorCode.FAILURE.getMsg()).build();
            }
            return Message.builder().errcode(Builder.ErrorCode.SUCCESS.getCode()).errmsg(Builder.ErrorCode.SUCCESS.getMsg()).data(Attachs.builder().name(fileName).size(StringKit.toString(response.body().length)).path(response.url())).build();
        }
        catch (QiniuException e) {
            Logger.error("file upload failed", e.getMessage());
            return Message.builder().errcode(Builder.ErrorCode.FAILURE.getCode()).errmsg(Builder.ErrorCode.FAILURE.getMsg()).build();
        }
    }

    @Override
    public Message upload(String bucket, String fileName, byte[] content) {
        try {
            String upToken = this.auth.uploadToken(bucket, fileName);
            Response response = this.uploadManager.put(content, fileName, upToken);
            if (!response.isOK()) {
                return Message.builder().errcode(Builder.ErrorCode.FAILURE.getCode()).errmsg(Builder.ErrorCode.FAILURE.getMsg()).build();
            }
            return Message.builder().errcode(Builder.ErrorCode.SUCCESS.getCode()).errmsg(Builder.ErrorCode.SUCCESS.getMsg()).data(Attachs.builder().size(StringKit.toString(response.body().length)).name(fileName).path(response.url())).build();
        }
        catch (QiniuException e) {
            Logger.error("file upload failed", e.getMessage());
            return Message.builder().errcode(Builder.ErrorCode.FAILURE.getCode()).errmsg(Builder.ErrorCode.FAILURE.getMsg()).build();
        }
    }

    @Override
    public Message remove(String fileKey) {
        try {
            if (fileKey.contains("/")) {
                fileKey = fileKey.replace(this.context.getPrefix(), "");
            }
            this.bucketManager.delete(this.context.getBucket(), fileKey);
            return Message.builder().errcode(Builder.ErrorCode.SUCCESS.getCode()).errmsg(Builder.ErrorCode.SUCCESS.getMsg()).build();
        }
        catch (QiniuException e) {
            Logger.error("file remove failed", e.getMessage());
            return Message.builder().errcode(Builder.ErrorCode.FAILURE.getCode()).errmsg(Builder.ErrorCode.FAILURE.getMsg()).build();
        }
    }

    @Override
    public Message remove(String bucket, String fileName) {
        try {
            this.bucketManager.delete(bucket, fileName);
            return Message.builder().errcode(Builder.ErrorCode.SUCCESS.getCode()).errmsg(Builder.ErrorCode.SUCCESS.getMsg()).build();
        }
        catch (QiniuException e) {
            Logger.error("file remove failed", e.getMessage());
            return Message.builder().errcode(Builder.ErrorCode.FAILURE.getCode()).errmsg(Builder.ErrorCode.FAILURE.getMsg()).build();
        }
    }

    @Override
    public Message remove(String bucket, Path path) {
        return this.remove(bucket, path.toString());
    }
}

