/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.convert;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.DoubleAdder;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Function;
import org.aoju.bus.core.convert.AbstractConverter;
import org.aoju.bus.core.toolkit.BooleanKit;
import org.aoju.bus.core.toolkit.ByteKit;
import org.aoju.bus.core.toolkit.DateKit;
import org.aoju.bus.core.toolkit.MathKit;
import org.aoju.bus.core.toolkit.StringKit;

public class NumberConverter
extends AbstractConverter<Number> {
    private static final long serialVersionUID = 1L;
    private final Class<? extends Number> targetType;

    public NumberConverter() {
        this.targetType = Number.class;
    }

    public NumberConverter(Class<? extends Number> clazz) {
        this.targetType = null == clazz ? Number.class : clazz;
    }

    protected static Number convert(Object value, Class<?> targetType, Function<Object, String> toStrFunc) {
        if (value instanceof Enum) {
            return NumberConverter.convert(((Enum)value).ordinal(), targetType, toStrFunc);
        }
        if (Byte.class == targetType) {
            if (value instanceof Number) {
                return ((Number)value).byteValue();
            }
            if (value instanceof Boolean) {
                return BooleanKit.toByteObj((Boolean)value);
            }
            String valueStr = toStrFunc.apply(value);
            try {
                return StringKit.isBlank(valueStr) ? null : Byte.valueOf(valueStr);
            }
            catch (NumberFormatException e) {
                return MathKit.parseNumber(valueStr).byteValue();
            }
        }
        if (Short.class == targetType) {
            if (value instanceof Number) {
                return ((Number)value).shortValue();
            }
            if (value instanceof Boolean) {
                return BooleanKit.toShortObj((Boolean)value);
            }
            if (value instanceof byte[]) {
                return ByteKit.getShort((byte[])value);
            }
            String valueStr = toStrFunc.apply(value);
            try {
                return StringKit.isBlank(valueStr) ? null : Short.valueOf(valueStr);
            }
            catch (NumberFormatException e) {
                return MathKit.parseNumber(valueStr).shortValue();
            }
        }
        if (Integer.class == targetType) {
            if (value instanceof Number) {
                return ((Number)value).intValue();
            }
            if (value instanceof Boolean) {
                return BooleanKit.toInteger((Boolean)value);
            }
            if (value instanceof Date) {
                return (int)((Date)value).getTime();
            }
            if (value instanceof Calendar) {
                return (int)((Calendar)value).getTimeInMillis();
            }
            if (value instanceof TemporalAccessor) {
                return (int)DateKit.toInstant((TemporalAccessor)value).toEpochMilli();
            }
            if (value instanceof byte[]) {
                return ByteKit.getInt((byte[])value);
            }
            String valueStr = toStrFunc.apply(value);
            return StringKit.isBlank(valueStr) ? null : Integer.valueOf(MathKit.parseInt(valueStr));
        }
        if (AtomicInteger.class == targetType) {
            Number number = NumberConverter.convert(value, Integer.class, toStrFunc);
            if (null != number) {
                AtomicInteger intValue = new AtomicInteger();
                intValue.set(number.intValue());
                return intValue;
            }
        } else {
            if (Long.class == targetType) {
                if (value instanceof Number) {
                    return ((Number)value).longValue();
                }
                if (value instanceof Boolean) {
                    return BooleanKit.toLongObj((Boolean)value);
                }
                if (value instanceof Date) {
                    return ((Date)value).getTime();
                }
                if (value instanceof Calendar) {
                    return ((Calendar)value).getTimeInMillis();
                }
                if (value instanceof TemporalAccessor) {
                    return DateKit.toInstant((TemporalAccessor)value).toEpochMilli();
                }
                if (value instanceof byte[]) {
                    return ByteKit.getLong((byte[])value);
                }
                String valueStr = toStrFunc.apply(value);
                return StringKit.isBlank(valueStr) ? null : Long.valueOf(MathKit.parseLong(valueStr));
            }
            if (AtomicLong.class == targetType) {
                Number number = NumberConverter.convert(value, Long.class, toStrFunc);
                if (null != number) {
                    AtomicLong longValue = new AtomicLong();
                    longValue.set(number.longValue());
                    return longValue;
                }
            } else if (LongAdder.class == targetType) {
                Number number = NumberConverter.convert(value, Long.class, toStrFunc);
                if (null != number) {
                    LongAdder longValue = new LongAdder();
                    longValue.add(number.longValue());
                    return longValue;
                }
            } else {
                if (Float.class == targetType) {
                    if (value instanceof Number) {
                        return Float.valueOf(((Number)value).floatValue());
                    }
                    if (value instanceof Boolean) {
                        return BooleanKit.toFloatObj((Boolean)value);
                    }
                    if (value instanceof byte[]) {
                        return Float.valueOf((float)ByteKit.getDouble((byte[])value));
                    }
                    String valueStr = toStrFunc.apply(value);
                    return StringKit.isBlank(valueStr) ? null : Float.valueOf(MathKit.parseFloat(valueStr));
                }
                if (Double.class == targetType) {
                    if (value instanceof Number) {
                        return ((Number)value).doubleValue();
                    }
                    if (value instanceof Boolean) {
                        return BooleanKit.toDoubleObj((Boolean)value);
                    }
                    if (value instanceof byte[]) {
                        return ByteKit.getDouble((byte[])value);
                    }
                    String valueStr = toStrFunc.apply(value);
                    return StringKit.isBlank(valueStr) ? null : Double.valueOf(MathKit.parseDouble(valueStr));
                }
                if (DoubleAdder.class == targetType) {
                    Number number = NumberConverter.convert(value, Long.class, toStrFunc);
                    if (null != number) {
                        DoubleAdder doubleAdder = new DoubleAdder();
                        doubleAdder.add(number.doubleValue());
                        return doubleAdder;
                    }
                } else {
                    if (BigDecimal.class == targetType) {
                        return NumberConverter.toBigDecimal(value, toStrFunc);
                    }
                    if (BigInteger.class == targetType) {
                        return NumberConverter.toBigInteger(value, toStrFunc);
                    }
                    if (Number.class == targetType) {
                        if (value instanceof Number) {
                            return (Number)value;
                        }
                        if (value instanceof Boolean) {
                            return BooleanKit.toInteger((Boolean)value);
                        }
                        String valueStr = toStrFunc.apply(value);
                        return StringKit.isBlank(valueStr) ? (Number)null : (Number)MathKit.parseNumber(valueStr);
                    }
                }
            }
        }
        throw new UnsupportedOperationException(StringKit.format((CharSequence)"Unsupport Number type: {}", targetType.getName()));
    }

    private static BigDecimal toBigDecimal(Object value, Function<Object, String> strFunc) {
        if (value instanceof Number) {
            return MathKit.toBigDecimal((Number)value);
        }
        if (value instanceof Boolean) {
            return new BigDecimal((Boolean)value != false ? 1 : 0);
        }
        if (value instanceof byte[]) {
            return MathKit.toBigDecimal(ByteKit.getDouble((byte[])value));
        }
        return MathKit.toBigDecimal(strFunc.apply(value));
    }

    private static BigInteger toBigInteger(Object value, Function<Object, String> strFunc) {
        if (value instanceof Long) {
            return BigInteger.valueOf((Long)value);
        }
        if (value instanceof Boolean) {
            return BigInteger.valueOf((Boolean)value != false ? 1L : 0L);
        }
        if (value instanceof byte[]) {
            return BigInteger.valueOf(ByteKit.getLong((byte[])value));
        }
        return MathKit.toBigInteger(strFunc.apply(value));
    }

    @Override
    protected Number convertInternal(Object value) {
        return NumberConverter.convert(value, this.targetType, this::convertString);
    }

    @Override
    protected String convertString(Object value) {
        char c;
        String result = StringKit.trim(super.convertString(value));
        if (StringKit.isNotEmpty(result) && ((c = Character.toUpperCase(result.charAt(result.length() - 1))) == 'D' || c == 'L' || c == 'F')) {
            return StringKit.subPre(result, -1);
        }
        return result;
    }

    @Override
    public Class<Number> getTargetType() {
        return this.targetType;
    }
}

