/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.date;

import org.aoju.bus.core.lang.Fields;
import org.aoju.bus.core.toolkit.DateKit;

public class NonTimer {
    private final boolean isNano;
    private long time;

    public NonTimer() {
        this(false);
    }

    public NonTimer(boolean isNano) {
        this.isNano = isNano;
        this.start();
    }

    public long start() {
        this.time = DateKit.timestamp(this.isNano);
        return this.time;
    }

    public long intervalRestart() {
        long now = DateKit.timestamp(this.isNano);
        long d = now - this.time;
        this.time = now;
        return d;
    }

    public NonTimer restart() {
        this.time = DateKit.timestamp(this.isNano);
        return this;
    }

    public long interval() {
        return DateKit.timestamp(this.isNano) - this.time;
    }

    public long intervalMs() {
        return this.isNano ? this.interval() / 1000000L : this.interval();
    }

    public long intervalSecond() {
        return this.intervalMs() / Fields.Units.SECOND.getUnit();
    }

    public long intervalMinute() {
        return this.intervalMs() / Fields.Units.MINUTE.getUnit();
    }

    public long intervalHour() {
        return this.intervalMs() / Fields.Units.HOUR.getUnit();
    }

    public long intervalDay() {
        return this.intervalMs() / Fields.Units.DAY.getUnit();
    }

    public long intervalWeek() {
        return this.intervalMs() / Fields.Units.WEEK.getUnit();
    }
}

