/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.toolkit;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.net.FileNameMap;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.file.AccessDeniedException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import org.aoju.bus.core.collection.EnumerationIterator;
import org.aoju.bus.core.io.LineHandler;
import org.aoju.bus.core.io.file.FileCopier;
import org.aoju.bus.core.io.file.FileMode;
import org.aoju.bus.core.io.file.FileReader;
import org.aoju.bus.core.io.file.FileWriter;
import org.aoju.bus.core.io.file.LineSeparator;
import org.aoju.bus.core.io.file.Tailer;
import org.aoju.bus.core.io.file.visitor.DeleteVisitor;
import org.aoju.bus.core.io.file.visitor.MoveVisitor;
import org.aoju.bus.core.io.resource.ClassPathResource;
import org.aoju.bus.core.io.resource.FileResource;
import org.aoju.bus.core.io.resource.Resource;
import org.aoju.bus.core.io.streams.BOMInputStream;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.lang.FileType;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.toolkit.ArrayKit;
import org.aoju.bus.core.toolkit.CharsKit;
import org.aoju.bus.core.toolkit.ClassKit;
import org.aoju.bus.core.toolkit.CollKit;
import org.aoju.bus.core.toolkit.IoKit;
import org.aoju.bus.core.toolkit.ObjectKit;
import org.aoju.bus.core.toolkit.PatternKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.core.toolkit.UriKit;
import org.aoju.bus.core.toolkit.ZipKit;

public class FileKit {
    private static final Pattern FILE_NAME_INVALID_PATTERN_WIN = Pattern.compile("[\\\\/:*?\"<>|]");

    public static boolean isWindows() {
        return '\\' == File.separatorChar;
    }

    public static boolean isEmpty(File file) {
        if (null == file || !file.exists()) {
            return true;
        }
        if (file.isDirectory()) {
            String[] subFiles = file.list();
            return ArrayKit.isEmpty(subFiles);
        }
        if (file.isFile()) {
            return file.length() <= 0L;
        }
        return false;
    }

    public static boolean isNotEmpty(File file) {
        return false == FileKit.isEmpty(file);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isDirEmpty(Path dirPath) {
        try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(dirPath);){
            boolean bl = false == dirStream.iterator().hasNext();
            return bl;
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
    }

    public static boolean isDirEmpty(File dir) {
        return FileKit.isDirEmpty(dir.toPath());
    }

    public static File[] ls(String path) {
        if (null == path) {
            return null;
        }
        File file = FileKit.file(path = FileKit.getAbsolutePath(path));
        if (file.isDirectory()) {
            return file.listFiles();
        }
        throw new InstrumentException(StringKit.format((CharSequence)"Path [{}] is not directory!", path));
    }

    public static boolean isFile(String path) {
        return null != path && FileKit.file(path).isFile();
    }

    public static boolean isFile(File file) {
        return null != file && file.isFile();
    }

    public static boolean isFile(Path path, boolean isFollowLinks) {
        LinkOption[] linkOptionArray;
        if (null == path) {
            return false;
        }
        if (isFollowLinks) {
            linkOptionArray = new LinkOption[]{};
        } else {
            LinkOption[] linkOptionArray2 = new LinkOption[1];
            linkOptionArray = linkOptionArray2;
            linkOptionArray2[0] = LinkOption.NOFOLLOW_LINKS;
        }
        LinkOption[] options = linkOptionArray;
        return Files.isRegularFile(path, options);
    }

    public static boolean isDirectory(String path) {
        return null != path && FileKit.file(path).isDirectory();
    }

    public static boolean isDirectory(Path path) {
        return FileKit.isDirectory(path, false);
    }

    public static boolean isDirectory(File file) {
        return null != file && file.isDirectory();
    }

    public static boolean isDirectory(Path path, boolean isFollowLinks) {
        LinkOption[] linkOptionArray;
        if (null == path) {
            return false;
        }
        if (isFollowLinks) {
            linkOptionArray = new LinkOption[]{};
        } else {
            LinkOption[] linkOptionArray2 = new LinkOption[1];
            linkOptionArray = linkOptionArray2;
            linkOptionArray2[0] = LinkOption.NOFOLLOW_LINKS;
        }
        LinkOption[] options = linkOptionArray;
        return Files.isDirectory(path, options);
    }

    public static File file(String path) {
        if (StringKit.isBlank(path)) {
            throw new NullPointerException("File path is blank!");
        }
        return new File(FileKit.getAbsolutePath(path));
    }

    public static File file(String ... names) {
        if (ArrayKit.isEmpty(names)) {
            return null;
        }
        File file = null;
        for (String name : names) {
            file = null == file ? FileKit.file(name) : FileKit.file(file, name);
        }
        return file;
    }

    public static File file(URI uri) {
        if (null == uri) {
            throw new NullPointerException("File uri is null!");
        }
        return new File(uri);
    }

    public static File file(URL url) {
        return new File(UriKit.toURI(url));
    }

    public static File file(String parent, String path) {
        return FileKit.file(new File(parent), path);
    }

    public static File file(File parent, String path) {
        if (StringKit.isBlank(path)) {
            throw new NullPointerException("File path is blank!");
        }
        return FileKit.checkSlip(parent, FileKit.buildFile(parent, path));
    }

    public static File file(File directory, String ... names) {
        Assert.notNull(directory, "Directory must not be null", new Object[0]);
        if (ArrayKit.isEmpty(names)) {
            return directory;
        }
        File file = directory;
        for (String name : names) {
            if (null == name) continue;
            file = FileKit.file(file, name);
        }
        return file;
    }

    public static List<File> loopFiles(String path) {
        return FileKit.loopFiles(FileKit.file(path));
    }

    public static List<File> loopFiles(File file) {
        return FileKit.loopFiles(file, null);
    }

    public static List<File> loopFiles(String path, FileFilter fileFilter) {
        return FileKit.loopFiles(FileKit.file(path), fileFilter);
    }

    public static List<File> loopFiles(File file, FileFilter fileFilter) {
        ArrayList<File> fileList = new ArrayList<File>();
        if (null == file) {
            return fileList;
        }
        if (!file.exists()) {
            return fileList;
        }
        if (file.isDirectory()) {
            File[] subFiles = file.listFiles();
            if (ArrayKit.isNotEmpty(subFiles)) {
                for (File tmp : subFiles) {
                    fileList.addAll(FileKit.loopFiles(tmp, fileFilter));
                }
            }
        } else if (null == fileFilter || fileFilter.accept(file)) {
            fileList.add(file);
        }
        return fileList;
    }

    public static List<File> loopFiles(Path path, FileFilter fileFilter) {
        return FileKit.loopFiles(path, -1, fileFilter);
    }

    public static List<File> loopFiles(Path path, int maxDepth, final FileFilter fileFilter) {
        final ArrayList<File> fileList = new ArrayList<File>();
        if (null == path || !Files.exists(path, new LinkOption[0])) {
            return fileList;
        }
        if (!FileKit.isDirectory(path)) {
            File file = path.toFile();
            if (null == fileFilter || fileFilter.accept(file)) {
                fileList.add(file);
            }
            return fileList;
        }
        FileKit.walkFiles(path, maxDepth, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) {
                File file = path.toFile();
                if (null == fileFilter || fileFilter.accept(file)) {
                    fileList.add(file);
                }
                return FileVisitResult.CONTINUE;
            }
        });
        return fileList;
    }

    public static void walkFiles(Path start, FileVisitor<? super Path> visitor) {
        FileKit.walkFiles(start, -1, visitor);
    }

    public static void walkFiles(File file, Consumer<File> consumer) {
        if (file.isDirectory()) {
            File[] subFiles = file.listFiles();
            if (ArrayKit.isNotEmpty(subFiles)) {
                for (File tmp : subFiles) {
                    FileKit.walkFiles(tmp, consumer);
                }
            }
        } else {
            consumer.accept(file);
        }
    }

    public static void walkFiles(Path start, int maxDepth, FileVisitor<? super Path> visitor) {
        if (maxDepth < 0) {
            maxDepth = Integer.MAX_VALUE;
        }
        try {
            Files.walkFileTree(start, EnumSet.noneOf(FileVisitOption.class), maxDepth, visitor);
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
    }

    public static boolean exists(String path) {
        return null != path && FileKit.file(path).exists();
    }

    public static boolean exists(File file) {
        return null != file && file.exists();
    }

    public static boolean exists(String directory, String regexp) {
        File file = new File(directory);
        if (!file.exists()) {
            return false;
        }
        String[] fileList = file.list();
        if (null == fileList) {
            return false;
        }
        for (String fileName : fileList) {
            if (!fileName.matches(regexp)) continue;
            return true;
        }
        return false;
    }

    public static boolean exists(Path path, boolean isFollowLinks) {
        LinkOption[] linkOptionArray;
        if (isFollowLinks) {
            linkOptionArray = new LinkOption[]{};
        } else {
            LinkOption[] linkOptionArray2 = new LinkOption[1];
            linkOptionArray = linkOptionArray2;
            linkOptionArray2[0] = LinkOption.NOFOLLOW_LINKS;
        }
        LinkOption[] options = linkOptionArray;
        return Files.exists(path, options);
    }

    public static boolean newerThan(File file, File reference) {
        if (null == reference || !reference.exists()) {
            return true;
        }
        return FileKit.newerThan(file, reference.lastModified());
    }

    public static boolean newerThan(File file, long timeMillis) {
        if (null == file || !file.exists()) {
            return false;
        }
        return file.lastModified() > timeMillis;
    }

    public static File touch(String path) throws InstrumentException {
        if (null == path) {
            return null;
        }
        return FileKit.touch(FileKit.file(path));
    }

    public static File touch(File file) throws InstrumentException {
        if (null == file) {
            return null;
        }
        if (!file.exists()) {
            FileKit.mkdir(file.getParentFile());
            try {
                file.createNewFile();
            }
            catch (Exception e) {
                throw new InstrumentException(e);
            }
        }
        return file;
    }

    public static File touch(File parent, String path) throws InstrumentException {
        return FileKit.touch(FileKit.file(parent, path));
    }

    public static File touch(String parent, String path) throws InstrumentException {
        return FileKit.touch(FileKit.file(parent, path));
    }

    public static boolean delete(String fullFileOrDirPath) throws InstrumentException {
        return FileKit.delete(FileKit.file(fullFileOrDirPath));
    }

    public static boolean delete(File file) throws InstrumentException {
        boolean isOk;
        if (null == file || !file.exists()) {
            return true;
        }
        if (file.isDirectory() && !(isOk = FileKit.clean(file))) {
            return false;
        }
        try {
            Files.delete(file.toPath());
        }
        catch (AccessDeniedException access) {
            return file.delete();
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
        return true;
    }

    public static boolean delete(Path path) throws InstrumentException {
        block6: {
            if (Files.notExists(path, new LinkOption[0])) {
                return true;
            }
            try {
                if (FileKit.isDirectory(path)) {
                    Files.walkFileTree(path, DeleteVisitor.INSTANCE);
                    break block6;
                }
                try {
                    Files.delete(path);
                }
                catch (AccessDeniedException access) {
                    return path.toFile().delete();
                }
            }
            catch (IOException e) {
                throw new InstrumentException(e);
            }
        }
        return true;
    }

    public static boolean clean(String dirPath) throws InstrumentException {
        return FileKit.clean(FileKit.file(dirPath));
    }

    public static boolean clean(File directory) throws InstrumentException {
        File[] files;
        if (null == directory || !directory.exists() || !directory.isDirectory()) {
            return true;
        }
        for (File childFile : files = directory.listFiles()) {
            boolean isOk = FileKit.delete(childFile);
            if (isOk) continue;
            return false;
        }
        return true;
    }

    public static File mkdir(String dirPath) {
        if (null == dirPath) {
            return null;
        }
        File dir = FileKit.file(dirPath);
        return FileKit.mkdir(dir);
    }

    public static File mkdir(File dir) {
        if (null == dir) {
            return null;
        }
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return dir;
    }

    public static Path mkdir(Path dir) {
        if (null != dir && !FileKit.exists(dir, false)) {
            try {
                Files.createDirectories(dir, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new InstrumentException(e);
            }
        }
        return dir;
    }

    public static File createTempFile(File dir) throws InstrumentException {
        return FileKit.createTempFile("create", null, dir, true);
    }

    public static File createTempFile(File dir, boolean isReCreat) throws InstrumentException {
        return FileKit.createTempFile("create", null, dir, isReCreat);
    }

    public static File createTempFile(String prefix, String suffix, File dir, boolean isReCreat) throws InstrumentException {
        int exceptionsCount = 0;
        while (true) {
            try {
                File file = File.createTempFile(prefix, suffix, FileKit.mkdir(dir)).getCanonicalFile();
                if (isReCreat) {
                    file.delete();
                    file.createNewFile();
                }
                return file;
            }
            catch (IOException ex) {
                if (++exceptionsCount < 50) continue;
                throw new InstrumentException(ex);
            }
            break;
        }
    }

    public static File copyFile(String src, String dest, StandardCopyOption ... options) throws InstrumentException {
        Assert.notBlank(src, "Source File path is blank !", new Object[0]);
        Assert.notBlank(dest, "Destination File path is blank !", new Object[0]);
        return FileKit.copyFile(Paths.get(src, new String[0]), Paths.get(dest, new String[0]), options).toFile();
    }

    public static File copyFile(File src, File dest, StandardCopyOption ... options) throws InstrumentException {
        Assert.notNull(src, "Source File is null !", new Object[0]);
        if (!src.exists()) {
            throw new InstrumentException("File not exist: " + src);
        }
        Assert.notNull(dest, "Destination File or directory is null !", new Object[0]);
        if (FileKit.equals(src, dest)) {
            throw new InstrumentException("Files '{}' and '{}' are equal", src, dest);
        }
        return FileKit.copyFile(src.toPath(), dest.toPath(), options).toFile();
    }

    public static Path copyFile(Path src, Path dest, StandardCopyOption ... options) throws InstrumentException {
        Assert.notNull(src, "Source File is null !", new Object[0]);
        Assert.notNull(dest, "Dest File or directory is null !", new Object[0]);
        Path destPath = FileKit.isDirectory(dest) ? dest.resolve(src.getFileName()) : dest;
        try {
            return Files.copy(src, destPath, (CopyOption[])options);
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
    }

    public static long copyFile(File input, OutputStream output) throws IOException {
        try (FileInputStream fis = new FileInputStream(input);){
            long l = IoKit.copy((InputStream)fis, output);
            return l;
        }
    }

    public static File copyFile(File src, File dest, boolean isOverride) throws InstrumentException {
        return FileCopier.create(src, dest).setCopyContentIfDir(true).setOnlyCopyFile(true).setOverride(isOverride).copy();
    }

    public static File copy(String srcPath, String destPath, boolean isOverride) throws InstrumentException {
        return FileKit.copy(FileKit.file(srcPath), FileKit.file(destPath), isOverride);
    }

    public static File copy(File src, File dest, boolean isOverride) throws InstrumentException {
        return FileCopier.create(src, dest).setOverride(isOverride).copy();
    }

    public static File copyContent(File src, File dest, boolean isOverride) throws InstrumentException {
        return FileCopier.create(src, dest).setCopyContentIfDir(true).setOverride(isOverride).copy();
    }

    public static File rename(File file, String newName, boolean isOverride) {
        return FileKit.rename(file, newName, false, isOverride);
    }

    public static Path rename(Path path, String newName, boolean isOverride) {
        return FileKit.move(path, path.resolveSibling(newName), isOverride);
    }

    public static File rename(File file, String newName, boolean isRetainExt, boolean isOverride) {
        String suffix;
        if (isRetainExt && StringKit.isNotBlank(suffix = FileKit.getSuffix(file))) {
            newName = newName.concat(".").concat(suffix);
        }
        return FileKit.rename(file.toPath(), newName, isOverride).toFile();
    }

    public static void move(File src, File target, boolean isOverride) throws InstrumentException {
        FileKit.move(src.toPath(), target.toPath(), isOverride);
    }

    public static Path move(Path src, Path target, boolean isOverride) {
        CopyOption[] copyOptionArray;
        Assert.notNull(src, "Src path must be not null !", new Object[0]);
        Assert.notNull(target, "Target path must be not null !", new Object[0]);
        if (isOverride) {
            CopyOption[] copyOptionArray2 = new CopyOption[1];
            copyOptionArray = copyOptionArray2;
            copyOptionArray2[0] = StandardCopyOption.REPLACE_EXISTING;
        } else {
            copyOptionArray = new CopyOption[]{};
        }
        CopyOption[] options = copyOptionArray;
        FileKit.mkdir(target.getParent());
        try {
            return Files.move(src, target, options);
        }
        catch (IOException e) {
            try {
                Files.walkFileTree(src, new MoveVisitor(src, target, options));
                FileKit.delete(src);
            }
            catch (IOException e2) {
                throw new InstrumentException(e2);
            }
            return target;
        }
    }

    public static String getCanonicalPath(File file) {
        if (null == file) {
            return null;
        }
        try {
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
    }

    public static String getAbsolutePath(String path) {
        return FileKit.getAbsolutePath(path, null);
    }

    public static String getAbsolutePath(String path, Class<?> baseClass) {
        String normalPath;
        if (null == path) {
            normalPath = "";
        } else {
            normalPath = FileKit.normalize(path);
            if (FileKit.isAbsolutePath(normalPath)) {
                return normalPath;
            }
        }
        URL url = FileKit.getResource(normalPath, baseClass);
        if (null != url) {
            return FileKit.normalize(UriKit.getDecodedPath(url));
        }
        String classPath = ClassKit.getClassPath();
        if (null == classPath) {
            return path;
        }
        return FileKit.normalize(classPath.concat(path));
    }

    public static String getAbsolutePath(File file) {
        if (null == file) {
            return null;
        }
        try {
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            return file.getAbsolutePath();
        }
    }

    public static boolean isAbsolutePath(String path) {
        if (StringKit.isEmpty(path)) {
            return false;
        }
        return '/' == path.charAt(0) || path.matches("^[a-zA-Z]:[/\\\\].*");
    }

    public static boolean equals(File file1, File file2) throws InstrumentException {
        Assert.notNull(file1);
        Assert.notNull(file2);
        if (!file1.exists() || !file2.exists()) {
            return false == file1.exists() && false == file2.exists() && FileKit.pathEquals(file1, file2);
        }
        try {
            return Files.isSameFile(file1.toPath(), file2.toPath());
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
    }

    public static String readFile(File file) {
        BufferedReader reader = null;
        try {
            String tempString;
            reader = new BufferedReader(new java.io.FileReader(file));
            String all = "";
            while (null != (tempString = reader.readLine())) {
                all = all + tempString;
            }
            reader.close();
            String string = all;
            return string;
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
        finally {
            if (null != reader) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static List<String> listFileNames(String path) throws InstrumentException {
        List<String> files2;
        if (null == path) {
            return new ArrayList<String>(0);
        }
        int index = path.lastIndexOf(".jar!");
        if (index < 0) {
            File[] files2;
            ArrayList<String> paths = new ArrayList<String>();
            for (File file : files2 = FileKit.ls(path)) {
                if (!file.isFile()) continue;
                paths.add(file.getName());
            }
            return paths;
        }
        path = FileKit.getAbsolutePath(path);
        index += ".jar!".length();
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(path.substring(0, index));
            files2 = ZipKit.listFileNames(jarFile, StringKit.removePrefix(path.substring(index + 1), "/"));
        }
        catch (IOException e) {
            try {
                throw new InstrumentException(StringKit.format((CharSequence)"Can not read file path of [{}]", path), e);
            }
            catch (Throwable throwable) {
                IoKit.close(jarFile);
                throw throwable;
            }
        }
        IoKit.close(jarFile);
        return files2;
    }

    public static File newFile(String path) {
        return new File(path);
    }

    public static String getTmpDirPath() {
        return System.getProperty("java.io.tmpdir");
    }

    public static File getTmpDir() {
        return FileKit.file(FileKit.getTmpDirPath());
    }

    public static String getUserHomePath() {
        return System.getProperty("user.home");
    }

    public static File getUserHomeDir() {
        return FileKit.file(FileKit.getUserHomePath());
    }

    public static int indexOfSuffix(String filename) {
        if (null == filename) {
            return -1;
        }
        int extensionPos = filename.lastIndexOf(".");
        int lastSeparator = FileKit.indexOfLastSeparator(filename);
        return lastSeparator > extensionPos ? -1 : extensionPos;
    }

    public static int indexOfLastSeparator(String filename) {
        if (null == filename) {
            return -1;
        }
        int lastUnixPos = filename.lastIndexOf("/");
        int lastWindowsPos = filename.lastIndexOf("\\");
        return Math.max(lastUnixPos, lastWindowsPos);
    }

    public static Date lastModifiedTime(File file) {
        if (!FileKit.exists(file)) {
            return null;
        }
        return new Date(file.lastModified());
    }

    public static Date lastModifiedTime(String path) {
        return FileKit.lastModifiedTime(new File(path));
    }

    public static long size(File file) {
        if (null == file || !file.exists() || FileKit.isSymlink(file)) {
            return 0L;
        }
        if (file.isDirectory()) {
            long size = 0L;
            File[] subFiles = file.listFiles();
            if (ArrayKit.isEmpty(subFiles)) {
                return 0L;
            }
            for (int i = 0; i < subFiles.length; ++i) {
                size += FileKit.size(subFiles[i]);
            }
            return size;
        }
        return file.length();
    }

    public static boolean isSymlink(File file) {
        return Files.isSymbolicLink(file.toPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean contentEquals(File file1, File file2) throws InstrumentException {
        boolean file1Exists = file1.exists();
        if (file1Exists != file2.exists()) {
            return false;
        }
        if (!file1Exists) {
            return true;
        }
        if (file1.isDirectory() || file2.isDirectory()) {
            throw new InstrumentException("Can't compare directories, only file");
        }
        if (file1.length() != file2.length()) {
            return false;
        }
        if (FileKit.equals(file1, file2)) {
            return true;
        }
        BufferedInputStream input1 = null;
        BufferedInputStream input2 = null;
        try {
            input1 = FileKit.getInputStream(file1);
            input2 = FileKit.getInputStream(file2);
            boolean bl = IoKit.contentEquals(input1, input2);
            return bl;
        }
        finally {
            IoKit.close(input1);
            IoKit.close(input2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean contentEqualsIgnoreEOL(File file1, File file2, Charset charset) throws InstrumentException {
        boolean bl;
        boolean file1Exists = file1.exists();
        if (file1Exists != file2.exists()) {
            return false;
        }
        if (!file1Exists) {
            return true;
        }
        if (file1.isDirectory() || file2.isDirectory()) {
            throw new InstrumentException("Can't compare directories, only file");
        }
        if (FileKit.equals(file1, file2)) {
            return true;
        }
        BufferedReader input1 = null;
        BufferedReader input2 = null;
        try {
            input1 = FileKit.getReader(file1, charset);
            input2 = FileKit.getReader(file2, charset);
            bl = IoKit.contentEqualsIgnoreEOL(input1, input2);
        }
        catch (Throwable throwable) {
            IoKit.close(input1);
            IoKit.close(input2);
            throw throwable;
        }
        IoKit.close(input1);
        IoKit.close(input2);
        return bl;
    }

    public static boolean pathEquals(File file1, File file2) {
        block8: {
            if (FileKit.isWindows()) {
                try {
                    if (StringKit.equalsIgnoreCase(file1.getCanonicalPath(), file2.getCanonicalPath())) {
                        return true;
                    }
                    break block8;
                }
                catch (Exception e) {
                    if (StringKit.equalsIgnoreCase(file1.getAbsolutePath(), file2.getAbsolutePath())) {
                        return true;
                    }
                    break block8;
                }
            }
            try {
                if (StringKit.equals(file1.getCanonicalPath(), file2.getCanonicalPath())) {
                    return true;
                }
            }
            catch (Exception e) {
                if (!StringKit.equals(file1.getAbsolutePath(), file2.getAbsolutePath())) break block8;
                return true;
            }
        }
        return false;
    }

    public static int lastIndexOfSeparator(String filePath) {
        if (StringKit.isNotEmpty(filePath)) {
            int i = filePath.length();
            while (i-- >= 0) {
                char c = filePath.charAt(i);
                if (!CharsKit.isFileSeparator(c)) continue;
                return i;
            }
        }
        return -1;
    }

    public static boolean isModified(File file, long lastModifyTime) {
        if (null == file || !file.exists()) {
            return true;
        }
        return file.lastModified() != lastModifyTime;
    }

    public static String normalize(String path) {
        if (null == path) {
            return null;
        }
        String pathToUse = StringKit.removePrefixIgnoreCase(path, "classpath:");
        if (StringKit.startWith((CharSequence)(pathToUse = StringKit.removePrefixIgnoreCase(pathToUse, "file:")), "~")) {
            pathToUse = FileKit.getUserHomePath() + pathToUse.substring(1);
        }
        pathToUse = pathToUse.replaceAll("[/\\\\]+", "/");
        pathToUse = StringKit.trim(pathToUse, -1);
        if (path.startsWith("\\\\")) {
            pathToUse = "\\" + pathToUse;
        }
        String prefix = "";
        int prefixIndex = pathToUse.indexOf(":");
        if (prefixIndex > -1) {
            prefix = pathToUse.substring(0, prefixIndex + 1);
            if (StringKit.startWith((CharSequence)prefix, '/')) {
                prefix = prefix.substring(1);
            }
            if (!prefix.contains("/")) {
                pathToUse = pathToUse.substring(prefixIndex + 1);
            } else {
                prefix = "";
            }
        }
        if (pathToUse.startsWith("/")) {
            prefix = prefix + "/";
            pathToUse = pathToUse.substring(1);
        }
        List<String> pathList = StringKit.split((CharSequence)pathToUse, '/');
        LinkedList<String> pathElements = new LinkedList<String>();
        int tops = 0;
        for (int i = pathList.size() - 1; i >= 0; --i) {
            String element = pathList.get(i);
            if (".".equals(element)) continue;
            if ("..".equals(element)) {
                ++tops;
                continue;
            }
            if (tops > 0) {
                --tops;
                continue;
            }
            pathElements.add(0, element);
        }
        if (tops > 0 && StringKit.isEmpty(prefix)) {
            while (tops-- > 0) {
                pathElements.add(0, "..");
            }
        }
        return prefix + CollKit.join(pathElements, (CharSequence)"/");
    }

    public static String subPath(String rootDir, File file) {
        try {
            return FileKit.subPath(rootDir, file.getCanonicalPath());
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
    }

    public static String subPath(String dirPath, String filePath) {
        if (StringKit.isNotEmpty(dirPath) && StringKit.isNotEmpty(filePath)) {
            dirPath = StringKit.removeSuffix(FileKit.normalize(dirPath), "/");
            filePath = FileKit.normalize(filePath);
            String result = StringKit.removePrefixIgnoreCase(filePath, dirPath);
            return StringKit.removePrefix(result, "/");
        }
        return filePath;
    }

    public static Path getPathEle(Path path, int index) {
        return FileKit.subPath(path, index, index == -1 ? path.getNameCount() : index + 1);
    }

    public static Path getLastPathEle(Path path) {
        return FileKit.getPathEle(path, path.getNameCount() - 1);
    }

    public static Path subPath(Path path, int fromIndex, int toIndex) {
        if (null == path) {
            return null;
        }
        int len = path.getNameCount();
        if (fromIndex < 0) {
            if ((fromIndex = len + fromIndex) < 0) {
                fromIndex = 0;
            }
        } else if (fromIndex > len) {
            fromIndex = len;
        }
        if (toIndex < 0) {
            if ((toIndex = len + toIndex) < 0) {
                toIndex = len;
            }
        } else if (toIndex > len) {
            toIndex = len;
        }
        if (toIndex < fromIndex) {
            int tmp = fromIndex;
            fromIndex = toIndex;
            toIndex = tmp;
        }
        if (fromIndex == toIndex) {
            return null;
        }
        return path.subpath(fromIndex, toIndex);
    }

    public static String getName(File file) {
        return null != file ? file.getName() : null;
    }

    public static String getName(String filePath) {
        if (null == filePath) {
            return filePath;
        }
        int len = filePath.length();
        if (0 == len) {
            return filePath;
        }
        if (CharsKit.isFileSeparator(filePath.charAt(len - 1))) {
            --len;
        }
        int begin = 0;
        for (int i = len - 1; i > -1; --i) {
            char c = filePath.charAt(i);
            if (!CharsKit.isFileSeparator(c)) continue;
            begin = i + 1;
            break;
        }
        return filePath.substring(begin, len);
    }

    public static String getName(Path path) {
        if (null == path) {
            return null;
        }
        return path.getFileName().toString();
    }

    public static String getSuffix(File file) {
        if (null == file) {
            return null;
        }
        if (file.isDirectory()) {
            return null;
        }
        return FileKit.getSuffix(file.getName());
    }

    public static String getSuffix(String fileName) {
        if (null == fileName) {
            return null;
        }
        int index = fileName.lastIndexOf(".");
        if (index == -1) {
            return "";
        }
        String ext = fileName.substring(index + 1);
        return StringKit.containsAny((CharSequence)ext, '/', '\\') ? "" : ext;
    }

    public static String getPrefix(File file) {
        if (file.isDirectory()) {
            return file.getName();
        }
        return FileKit.getPrefix(file.getName());
    }

    public static String getPrefix(String fileName) {
        if (null == fileName) {
            return fileName;
        }
        int len = fileName.length();
        if (0 == len) {
            return fileName;
        }
        if (CharsKit.isFileSeparator(fileName.charAt(len - 1))) {
            --len;
        }
        int begin = 0;
        int end = len;
        for (int i = len - 1; i > -1; --i) {
            char c = fileName.charAt(i);
            if (len == end && '.' == c) {
                end = i;
            }
            if (0 != begin && begin <= end || !CharsKit.isFileSeparator(c)) continue;
            begin = i + 1;
            break;
        }
        return fileName.substring(begin, end);
    }

    public static boolean endsWith(File file, String suffix) {
        return file.getPath().toLowerCase().endsWith(suffix);
    }

    public static String getType(File file) throws InstrumentException {
        return FileType.getType(file);
    }

    public static BasicFileAttributes getAttributes(Path path, boolean isFollowLinks) throws InstrumentException {
        LinkOption[] linkOptionArray;
        if (null == path) {
            return null;
        }
        if (isFollowLinks) {
            linkOptionArray = new LinkOption[]{};
        } else {
            LinkOption[] linkOptionArray2 = new LinkOption[1];
            linkOptionArray = linkOptionArray2;
            linkOptionArray2[0] = LinkOption.NOFOLLOW_LINKS;
        }
        LinkOption[] options = linkOptionArray;
        try {
            return Files.readAttributes(path, BasicFileAttributes.class, options);
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
    }

    public static BufferedInputStream getInputStream(Path path) throws InstrumentException {
        try {
            return new BufferedInputStream(Files.newInputStream(path, new OpenOption[0]));
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
    }

    public static BufferedInputStream getInputStream(File file) throws InstrumentException {
        return new BufferedInputStream(IoKit.toStream(file));
    }

    public static BufferedInputStream getInputStream(String path) throws InstrumentException {
        return FileKit.getInputStream(FileKit.file(path));
    }

    public static BOMInputStream getBOMInputStream(File file) throws InstrumentException {
        try {
            return new BOMInputStream(new FileInputStream(file));
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
    }

    public static BufferedReader getBOMReader(File file) {
        return IoKit.getReader(FileKit.getBOMInputStream(file));
    }

    public static BufferedReader getReader(Path path) throws InstrumentException {
        return FileKit.getReader(path, org.aoju.bus.core.lang.Charset.UTF_8);
    }

    public static BufferedReader getReader(File file) throws InstrumentException {
        return FileKit.getReader(file, org.aoju.bus.core.lang.Charset.UTF_8);
    }

    public static BufferedReader getReader(String path) throws InstrumentException {
        return FileKit.getReader(path, org.aoju.bus.core.lang.Charset.UTF_8);
    }

    public static BufferedReader getReader(Path path, Charset charset) throws InstrumentException {
        return IoKit.getReader((InputStream)FileKit.getInputStream(path), charset);
    }

    public static BufferedReader getReader(File file, String charsetName) throws InstrumentException {
        return IoKit.getReader((InputStream)FileKit.getInputStream(file), charsetName);
    }

    public static BufferedReader getReader(File file, Charset charset) throws InstrumentException {
        return IoKit.getReader((InputStream)FileKit.getInputStream(file), charset);
    }

    public static BufferedReader getReader(String path, String charsetName) throws InstrumentException {
        return FileKit.getReader(FileKit.file(path), charsetName);
    }

    public static BufferedReader getReader(String path, Charset charset) throws InstrumentException {
        return FileKit.getReader(FileKit.file(path), charset);
    }

    public static byte[] readBytes(File file) throws InstrumentException {
        return FileReader.create(file).readBytes();
    }

    public static byte[] readBytes(String filePath) throws InstrumentException {
        return FileKit.readBytes(FileKit.file(filePath));
    }

    public static String readString(File file) throws InstrumentException {
        return FileKit.readString(file, org.aoju.bus.core.lang.Charset.UTF_8);
    }

    public static String readString(String path) throws InstrumentException {
        return FileKit.readString(path, org.aoju.bus.core.lang.Charset.UTF_8);
    }

    public static String readString(File file, String charsetName) throws InstrumentException {
        return FileKit.readString(file, org.aoju.bus.core.lang.Charset.charset(charsetName));
    }

    public static String readString(File file, Charset charset) throws InstrumentException {
        return FileReader.create(file, charset).readString();
    }

    public static String readString(String path, String charsetName) throws InstrumentException {
        return FileKit.readString(FileKit.file(path), charsetName);
    }

    public static String readString(String path, Charset charset) throws InstrumentException {
        return FileKit.readString(FileKit.file(path), charset);
    }

    public static String readString(URL url, String charset) throws InstrumentException {
        if (null == url) {
            throw new NullPointerException("Empty url provided!");
        }
        InputStream in = null;
        try {
            in = url.openStream();
            String string = IoKit.read(in, charset);
            return string;
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
        finally {
            IoKit.close(in);
        }
    }

    public static <T extends Collection<String>> T readLines(String path, T collection) throws InstrumentException {
        return FileKit.readLines(path, org.aoju.bus.core.lang.Charset.UTF_8, collection);
    }

    public static <T extends Collection<String>> T readLines(String path, String charset, T collection) throws InstrumentException {
        return FileKit.readLines(FileKit.file(path), charset, collection);
    }

    public static <T extends Collection<String>> T readLines(String path, Charset charset, T collection) throws InstrumentException {
        return FileKit.readLines(FileKit.file(path), charset, collection);
    }

    public static <T extends Collection<String>> T readLines(File file, T collection) throws InstrumentException {
        return FileKit.readLines(file, org.aoju.bus.core.lang.Charset.UTF_8, collection);
    }

    public static <T extends Collection<String>> T readLines(File file, String charset, T collection) throws InstrumentException {
        return FileReader.create(file, org.aoju.bus.core.lang.Charset.charset(charset)).readLines(collection);
    }

    public static <T extends Collection<String>> T readLines(File file, Charset charset, T collection) throws InstrumentException {
        return FileReader.create(file, charset).readLines(collection);
    }

    public static <T extends Collection<String>> T readLines(URL url, T collection) throws InstrumentException {
        return FileKit.readLines(url, org.aoju.bus.core.lang.Charset.UTF_8, collection);
    }

    public static <T extends Collection<String>> T readLines(URL url, String charsetName, T collection) throws InstrumentException {
        return FileKit.readLines(url, org.aoju.bus.core.lang.Charset.charset(charsetName), collection);
    }

    public static <T extends Collection<String>> T readLines(URL url, Charset charset, T collection) throws InstrumentException {
        InputStream in = null;
        try {
            in = url.openStream();
            T t = IoKit.readLines(in, charset, collection);
            return t;
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
        finally {
            IoKit.close(in);
        }
    }

    public static List<String> readLines(URL url) throws InstrumentException {
        return FileKit.readLines(url, org.aoju.bus.core.lang.Charset.UTF_8);
    }

    public static List<String> readLines(URL url, String charset) throws InstrumentException {
        return FileKit.readLines(url, charset, new ArrayList());
    }

    public static List<String> readLines(URL url, Charset charset) throws InstrumentException {
        return FileKit.readLines(url, charset, new ArrayList());
    }

    public static List<String> readLines(String path) throws InstrumentException {
        return FileKit.readLines(path, org.aoju.bus.core.lang.Charset.UTF_8);
    }

    public static List<String> readLines(String path, String charset) throws InstrumentException {
        return FileKit.readLines(path, charset, new ArrayList());
    }

    public static List<String> readLines(String path, Charset charset) throws InstrumentException {
        return FileKit.readLines(path, charset, new ArrayList());
    }

    public static List<String> readLines(File file) throws InstrumentException {
        return FileKit.readLines(file, org.aoju.bus.core.lang.Charset.UTF_8);
    }

    public static List<String> readLines(File file, String charset) throws InstrumentException {
        return FileKit.readLines(file, charset, new ArrayList());
    }

    public static List<String> readLines(File file, Charset charset) throws InstrumentException {
        return FileKit.readLines(file, charset, new ArrayList());
    }

    public static void readLines(File file, LineHandler lineHandler) throws InstrumentException {
        FileKit.readLines(file, org.aoju.bus.core.lang.Charset.UTF_8, lineHandler);
    }

    public static void readLines(File file, Charset charset, LineHandler lineHandler) throws InstrumentException {
        FileReader.create(file, charset).readLines(lineHandler);
    }

    public static void readLines(RandomAccessFile file, Charset charset, LineHandler lineHandler) {
        try {
            String line;
            while (null != (line = file.readLine())) {
                lineHandler.handle(org.aoju.bus.core.lang.Charset.convert(line, org.aoju.bus.core.lang.Charset.ISO_8859_1, charset));
            }
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
    }

    public static void readLine(RandomAccessFile file, Charset charset, LineHandler lineHandler) {
        String line = FileKit.readLine(file, charset);
        if (null != line) {
            lineHandler.handle(line);
        }
    }

    public static String readLine(RandomAccessFile file, Charset charset) {
        String line;
        try {
            line = file.readLine();
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
        if (null != line) {
            return org.aoju.bus.core.lang.Charset.convert(line, org.aoju.bus.core.lang.Charset.ISO_8859_1, charset);
        }
        return null;
    }

    public static <T> T load(String path, FileReader.ReaderHandler<T> readerHandler) throws InstrumentException {
        return FileKit.load(path, org.aoju.bus.core.lang.Charset.UTF_8, readerHandler);
    }

    public static <T> T load(String path, String charset, FileReader.ReaderHandler<T> readerHandler) throws InstrumentException {
        return FileReader.create(FileKit.file(path), org.aoju.bus.core.lang.Charset.charset(charset)).read(readerHandler);
    }

    public static <T> T load(String path, Charset charset, FileReader.ReaderHandler<T> readerHandler) throws InstrumentException {
        return FileReader.create(FileKit.file(path), charset).read(readerHandler);
    }

    public static <T> T load(File file, FileReader.ReaderHandler<T> readerHandler) throws InstrumentException {
        return FileKit.load(file, org.aoju.bus.core.lang.Charset.UTF_8, readerHandler);
    }

    public static <T> T load(File file, Charset charset, FileReader.ReaderHandler<T> readerHandler) throws InstrumentException {
        return FileReader.create(file, charset).read(readerHandler);
    }

    public static BufferedOutputStream getOutputStream(File file) throws InstrumentException {
        try {
            return new BufferedOutputStream(new FileOutputStream(FileKit.touch(file)));
        }
        catch (Exception e) {
            throw new InstrumentException(e);
        }
    }

    public static BufferedOutputStream getOutputStream(String path) throws InstrumentException {
        return FileKit.getOutputStream(FileKit.touch(path));
    }

    public static BufferedWriter getWriter(String path, String charsetName, boolean isAppend) throws InstrumentException {
        return FileKit.getWriter(FileKit.touch(path), Charset.forName(charsetName), isAppend);
    }

    public static BufferedWriter getWriter(String path, Charset charset, boolean isAppend) throws InstrumentException {
        return FileKit.getWriter(FileKit.touch(path), charset, isAppend);
    }

    public static BufferedWriter getWriter(File file, String charsetName, boolean isAppend) throws InstrumentException {
        return FileKit.getWriter(file, Charset.forName(charsetName), isAppend);
    }

    public static BufferedWriter getWriter(File file, Charset charset, boolean isAppend) throws InstrumentException {
        return FileWriter.create(file, charset).getWriter(isAppend);
    }

    public static PrintWriter getPrintWriter(String path, String charset, boolean isAppend) throws InstrumentException {
        return new PrintWriter(FileKit.getWriter(path, charset, isAppend));
    }

    public static PrintWriter getPrintWriter(String path, Charset charset, boolean isAppend) throws InstrumentException {
        return new PrintWriter(FileKit.getWriter(path, charset, isAppend));
    }

    public static PrintWriter getPrintWriter(File file, String charset, boolean isAppend) throws InstrumentException {
        return new PrintWriter(FileKit.getWriter(file, charset, isAppend));
    }

    public static PrintWriter getPrintWriter(File file, Charset charset, boolean isAppend) throws InstrumentException {
        return new PrintWriter(FileKit.getWriter(file, charset, isAppend));
    }

    public static String getLineSeparator() {
        return System.lineSeparator();
    }

    public static File writeString(String content, String path) throws InstrumentException {
        return FileKit.writeString(content, path, org.aoju.bus.core.lang.Charset.UTF_8);
    }

    public static File writeString(String content, File file) throws InstrumentException {
        return FileKit.writeString(content, file, org.aoju.bus.core.lang.Charset.UTF_8);
    }

    public static File writeString(String content, String path, String charset) throws InstrumentException {
        return FileKit.writeString(content, FileKit.touch(path), charset);
    }

    public static File writeString(String content, String path, Charset charset) throws InstrumentException {
        return FileKit.writeString(content, FileKit.touch(path), charset);
    }

    public static File writeString(String content, File file, String charset) throws InstrumentException {
        return FileWriter.create(file, org.aoju.bus.core.lang.Charset.charset(charset)).write(content);
    }

    public static File writeString(String content, File file, Charset charset) throws InstrumentException {
        return FileWriter.create(file, charset).write(content);
    }

    public static File appendString(String content, String path) throws InstrumentException {
        return FileKit.appendString(content, path, org.aoju.bus.core.lang.Charset.UTF_8);
    }

    public static File appendString(String content, String path, String charset) throws InstrumentException {
        return FileKit.appendString(content, FileKit.touch(path), charset);
    }

    public static File appendString(String content, String path, Charset charset) throws InstrumentException {
        return FileKit.appendString(content, FileKit.touch(path), charset);
    }

    public static File appendString(String content, File file) throws InstrumentException {
        return FileKit.appendString(content, file, org.aoju.bus.core.lang.Charset.UTF_8);
    }

    public static File appendString(String content, File file, String charset) throws InstrumentException {
        return FileWriter.create(file, org.aoju.bus.core.lang.Charset.charset(charset)).append(content);
    }

    public static File appendString(String content, File file, Charset charset) throws InstrumentException {
        return FileWriter.create(file, charset).append(content);
    }

    public static <T> File writeLines(Collection<T> list, String path) throws InstrumentException {
        return FileKit.writeLines(list, path, org.aoju.bus.core.lang.Charset.UTF_8);
    }

    public static <T> File writeLines(Collection<T> list, File file) throws InstrumentException {
        return FileKit.writeLines(list, file, org.aoju.bus.core.lang.Charset.UTF_8);
    }

    public static <T> File writeLines(Collection<T> list, String path, String charset) throws InstrumentException {
        return FileKit.writeLines(list, path, charset, false);
    }

    public static <T> File writeLines(Collection<T> list, String path, Charset charset) throws InstrumentException {
        return FileKit.writeLines(list, path, charset, false);
    }

    public static <T> File writeLines(Collection<T> list, File file, String charset) throws InstrumentException {
        return FileKit.writeLines(list, file, charset, false);
    }

    public static <T> File writeLines(Collection<T> list, File file, Charset charset) throws InstrumentException {
        return FileKit.writeLines(list, file, charset, false);
    }

    public static <T> File appendLines(Collection<T> list, File file) throws InstrumentException {
        return FileKit.appendLines(list, file, org.aoju.bus.core.lang.Charset.UTF_8);
    }

    public static <T> File appendLines(Collection<T> list, String path) throws InstrumentException {
        return FileKit.appendLines(list, path, org.aoju.bus.core.lang.Charset.UTF_8);
    }

    public static <T> File appendLines(Collection<T> list, String path, String charset) throws InstrumentException {
        return FileKit.writeLines(list, path, charset, true);
    }

    public static <T> File appendLines(Collection<T> list, File file, String charset) throws InstrumentException {
        return FileKit.writeLines(list, file, charset, true);
    }

    public static <T> File appendLines(Collection<T> list, String path, Charset charset) throws InstrumentException {
        return FileKit.writeLines(list, path, charset, true);
    }

    public static <T> File appendLines(Collection<T> list, File file, Charset charset) throws InstrumentException {
        return FileKit.writeLines(list, file, charset, true);
    }

    public static <T> File writeLines(Collection<T> list, String path, String charset, boolean isAppend) throws InstrumentException {
        return FileKit.writeLines(list, FileKit.file(path), charset, isAppend);
    }

    public static <T> File writeLines(Collection<T> list, String path, Charset charset, boolean isAppend) throws InstrumentException {
        return FileKit.writeLines(list, FileKit.file(path), charset, isAppend);
    }

    public static <T> File writeLines(Collection<T> list, File file, String charset, boolean isAppend) throws InstrumentException {
        return FileWriter.create(file, org.aoju.bus.core.lang.Charset.charset(charset)).writeLines(list, isAppend);
    }

    public static <T> File writeLines(Collection<T> list, File file, Charset charset, boolean isAppend) throws InstrumentException {
        return FileWriter.create(file, charset).writeLines(list, isAppend);
    }

    public static File writeMap(Map<?, ?> map, File file, String kvSeparator, boolean isAppend) throws InstrumentException {
        return FileWriter.create(file, org.aoju.bus.core.lang.Charset.UTF_8).writeMap(map, kvSeparator, isAppend);
    }

    public static File writeMap(Map<?, ?> map, File file, Charset charset, String kvSeparator, boolean isAppend) throws InstrumentException {
        return FileWriter.create(file, charset).writeMap(map, kvSeparator, isAppend);
    }

    public static File writeBytes(byte[] data, String path) throws InstrumentException {
        return FileKit.writeBytes(data, FileKit.touch(path));
    }

    public static File writeBytes(byte[] data, File dest) throws InstrumentException {
        return FileKit.writeBytes(data, dest, 0, data.length, false);
    }

    public static File writeBytes(byte[] data, File dest, int off, int len, boolean isAppend) throws InstrumentException {
        return FileWriter.create(dest).write(data, off, len, isAppend);
    }

    public static File writeFromStream(InputStream in, File dest) throws InstrumentException {
        return FileKit.writeFromStream(in, dest, true);
    }

    public static File writeFromStream(InputStream in, File dest, boolean isCloseIn) throws InstrumentException {
        return FileWriter.create(dest).writeFromStream(in, isCloseIn);
    }

    public static File writeFromStream(InputStream in, String path) throws InstrumentException {
        return FileKit.writeFromStream(in, FileKit.touch(path));
    }

    public static long writeToStream(File file, OutputStream out) throws InstrumentException {
        return FileReader.create(file).writeToStream(out);
    }

    public static long writeToStream(String path, OutputStream out) throws InstrumentException {
        return FileKit.writeToStream(FileKit.touch(path), out);
    }

    public static String readableFileSize(File file) {
        return FileKit.readableFileSize(file.length());
    }

    public static String readableFileSize(long size) {
        if (size <= 0L) {
            return "0";
        }
        String[] units = new String[]{"B", "kB", "MB", "GB", "TB", "EB"};
        int digitGroups = (int)(Math.log10(size) / Math.log10(1024.0));
        return new DecimalFormat("#,##0.##").format((double)size / Math.pow(1024.0, digitGroups)) + " " + units[digitGroups];
    }

    public static File convertCharset(File file, Charset srcCharset, Charset destCharset) {
        return org.aoju.bus.core.lang.Charset.convert(file, srcCharset, destCharset);
    }

    public static File convertLineSeparator(File file, Charset charset, LineSeparator lineSeparator) {
        List<String> lines = FileKit.readLines(file, charset);
        return FileWriter.create(file, charset).writeLines(lines, lineSeparator, false);
    }

    public static String cleanInvalid(String fileName) {
        return StringKit.isBlank(fileName) ? fileName : PatternKit.delAll(FILE_NAME_INVALID_PATTERN_WIN, fileName);
    }

    public static boolean containsInvalid(String fileName) {
        return !StringKit.isBlank(fileName) && PatternKit.contains(FILE_NAME_INVALID_PATTERN_WIN, (CharSequence)fileName);
    }

    public static long checksumCRC32(File file) throws InstrumentException {
        return FileKit.checksum(file, new CRC32()).getValue();
    }

    public static Checksum checksum(File file, Checksum checksum) throws InstrumentException {
        Assert.notNull(file, "File is null !", new Object[0]);
        if (file.isDirectory()) {
            throw new IllegalArgumentException("Checksums can't be computed on directories");
        }
        try {
            return IoKit.checksum(new FileInputStream(file), checksum);
        }
        catch (FileNotFoundException e) {
            throw new InstrumentException(e);
        }
    }

    public static File getWebRoot() {
        String classPath = ClassKit.getClassPath();
        if (StringKit.isNotBlank(classPath)) {
            return FileKit.getParent(FileKit.file(classPath), 2);
        }
        return null;
    }

    public static String getParent(String filePath, int level) {
        File parent = FileKit.getParent(FileKit.file(filePath), level);
        try {
            return null == parent ? null : parent.getCanonicalPath();
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
    }

    public static File getParent(File file, int level) {
        File parentFile;
        if (level < 1 || null == file) {
            return file;
        }
        try {
            parentFile = file.getCanonicalFile().getParentFile();
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
        if (1 == level) {
            return parentFile;
        }
        return FileKit.getParent(parentFile, level - 1);
    }

    public static File checkSlip(File parentFile, File file) throws IllegalArgumentException {
        if (null != parentFile && null != file) {
            String canonicalPath;
            String parentCanonicalPath;
            try {
                parentCanonicalPath = parentFile.getCanonicalPath();
                canonicalPath = file.getCanonicalPath();
            }
            catch (IOException e) {
                parentCanonicalPath = parentFile.getAbsolutePath();
                canonicalPath = file.getAbsolutePath();
            }
            if (!canonicalPath.startsWith(parentCanonicalPath)) {
                throw new IllegalArgumentException("New file is outside of the parent dir: " + file.getName());
            }
        }
        return file;
    }

    public static String getMediaType(String path) {
        try {
            FileNameMap fileNameMap = URLConnection.getFileNameMap();
            String contentType = fileNameMap.getContentTypeFor(URLEncoder.encode(path, "UTF-8"));
            if (ObjectKit.isNull(contentType)) {
                if (path.endsWith(".css")) {
                    contentType = "text/css";
                } else if (path.endsWith(".js")) {
                    contentType = "application/x-javascript";
                }
            }
            return contentType;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getMediaType(Path file) {
        try {
            return Files.probeContentType(file);
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
    }

    public static String removeSuffix(String filename) {
        if (null == filename) {
            return null;
        }
        int len = filename.length();
        for (int i = 0; i < len; ++i) {
            if (filename.charAt(i) != '\u0000') continue;
            throw new IllegalArgumentException("Null byte present in file/path name. There are no known legitimate use cases for such data, but several injection attacks may use it");
        }
        int index = FileKit.indexOfSuffix(filename);
        if (index == -1) {
            return filename;
        }
        return filename.substring(0, index);
    }

    public static boolean isSuffix(String filename, String suffix) {
        if (null == filename) {
            return false;
        }
        FileKit.failIfNullBytePresent(filename);
        if (null == suffix || suffix.isEmpty()) {
            return FileKit.indexOfSuffix(filename) == -1;
        }
        String fileSuffix = FileKit.getSuffix(filename);
        return fileSuffix.equals(suffix);
    }

    public static boolean isSuffix(String filename, String[] suffixs) {
        if (null == filename) {
            return false;
        }
        FileKit.failIfNullBytePresent(filename);
        if (null == suffixs || suffixs.length == 0) {
            return FileKit.indexOfSuffix(filename) == -1;
        }
        String fileSuffix = FileKit.getSuffix(filename);
        for (String suffix : suffixs) {
            if (!fileSuffix.equals(suffix)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSuffix(String filename, Collection<String> suffixs) {
        if (null == filename) {
            return false;
        }
        FileKit.failIfNullBytePresent(filename);
        if (null == suffixs || suffixs.isEmpty()) {
            return FileKit.indexOfSuffix(filename) == -1;
        }
        String fileSuffix = FileKit.getSuffix(filename);
        for (String suffix : suffixs) {
            if (!fileSuffix.equals(suffix)) continue;
            return true;
        }
        return false;
    }

    private static void failIfNullBytePresent(String path) {
        int len = path.length();
        for (int i = 0; i < len; ++i) {
            if (path.charAt(i) != '\u0000') continue;
            throw new IllegalArgumentException("Null byte present in file/path name. There are no known legitimate use cases for such data, but several injection attacks may use it");
        }
    }

    public static void tail(File file, LineHandler handler) {
        FileKit.tail(file, org.aoju.bus.core.lang.Charset.UTF_8, handler);
    }

    public static void tail(File file, Charset charset, LineHandler handler) {
        new Tailer(file, charset, handler).start();
    }

    public static void tail(File file, Charset charset) {
        FileKit.tail(file, charset, new Tailer.ConsoleLineHandler());
    }

    public static RandomAccessFile createRandomAccessFile(Path path, FileMode mode) {
        return FileKit.createRandomAccessFile(path.toFile(), mode);
    }

    public static RandomAccessFile createRandomAccessFile(File file, FileMode mode) {
        try {
            return new RandomAccessFile(file, mode.name());
        }
        catch (FileNotFoundException e) {
            throw new InstrumentException(e);
        }
    }

    public static String readers(String resource) {
        return FileKit.getResourceObj(resource).readString(org.aoju.bus.core.lang.Charset.UTF_8);
    }

    public static String readers(String resource, Charset charset) {
        return new ClassPathResource(resource).readString(charset);
    }

    public static BufferedReader getReaders(String resurce, Charset charset) {
        return new ClassPathResource(resurce).getReader(charset);
    }

    public static InputStream getStream(String resurce) {
        return new ClassPathResource(resurce).getStream();
    }

    public static InputStream getStreamSafe(String resurce) {
        try {
            return new ClassPathResource(resurce).getStream();
        }
        catch (InstrumentException instrumentException) {
            return null;
        }
    }

    public static URL getResource(String resource) {
        return FileKit.getResource(resource, null);
    }

    public static List<URL> getResources(String resource) {
        Enumeration<URL> resources;
        try {
            resources = ClassKit.getClassLoader().getResources(resource);
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
        return CollKit.newArrayList(resources);
    }

    public static EnumerationIterator<URL> getResourceIter(String resource) {
        Enumeration<URL> resources;
        try {
            resources = ClassKit.getClassLoader().getResources(resource);
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
        return new EnumerationIterator<URL>(resources);
    }

    public static URL getResource(String resource, Class<?> baseClass) {
        resource = StringKit.nullToEmpty(resource);
        URL url = null != baseClass ? baseClass.getResource(resource) : ClassKit.getClassLoader().getResource(resource);
        return null != url ? url : baseClass.getClassLoader().getResource(resource);
    }

    public static Resource getResourceObj(String path) {
        return FileKit.isAbsolutePath(path) ? new FileResource(path) : new ClassPathResource(path);
    }

    public static boolean isType(String fileName, String ... suffix) {
        return StringKit.equalsAnyIgnoreCase(FileKit.getSuffix(fileName), suffix);
    }

    public static boolean isEexist(Path path, boolean isFollowLinks) {
        LinkOption[] linkOptionArray;
        if (isFollowLinks) {
            linkOptionArray = new LinkOption[]{};
        } else {
            LinkOption[] linkOptionArray2 = new LinkOption[1];
            linkOptionArray = linkOptionArray2;
            linkOptionArray2[0] = LinkOption.NOFOLLOW_LINKS;
        }
        LinkOption[] options = linkOptionArray;
        return Files.exists(path, options);
    }

    public static boolean isSub(File parent, File sub) {
        Assert.notNull(parent);
        Assert.notNull(sub);
        return FileKit.isSub(parent.toPath(), sub.toPath());
    }

    public static boolean isSub(Path parent, Path sub) {
        return FileKit.toAbsNormal(sub).startsWith(FileKit.toAbsNormal(parent));
    }

    public static Path toAbsNormal(Path path) {
        Assert.notNull(path);
        return path.toAbsolutePath().normalize();
    }

    public static void addContent(File dir, String content) {
        File[] files = dir.listFiles();
        if (files == null || files.length == 0) {
            return;
        }
        for (File file : files) {
            if (file.isFile()) {
                try {
                    String line;
                    BufferedReader br = new BufferedReader(new java.io.FileReader(file));
                    String text = "";
                    String lineSeperator = System.getProperty("line.separator");
                    while ((line = br.readLine()) != null) {
                        text = text + line + lineSeperator;
                    }
                    br.close();
                    java.io.FileWriter fileWriter = new java.io.FileWriter(file);
                    fileWriter.write(content);
                    fileWriter.write(text);
                    fileWriter.close();
                    continue;
                }
                catch (FileNotFoundException e) {
                    throw new InstrumentException("File NotFound !");
                }
                catch (IOException ex) {
                    throw new InstrumentException("I/O exception of some sort has occurred");
                }
            }
            FileKit.addContent(file, content);
        }
    }

    private static File buildFile(File outFile, String fileName) {
        fileName = fileName.replace('\\', '/');
        if (!FileKit.isWindows() && fileName.lastIndexOf(47, fileName.length() - 2) > 0) {
            List<String> pathParts = StringKit.split((CharSequence)fileName, '/', false, true);
            int lastPartIndex = pathParts.size() - 1;
            for (int i = 0; i < lastPartIndex; ++i) {
                outFile = new File(outFile, pathParts.get(i));
            }
            outFile.mkdirs();
            fileName = pathParts.get(lastPartIndex);
        }
        return new File(outFile, fileName);
    }
}

