/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.toolkit;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import org.aoju.bus.core.compare.PinyinCompare;
import org.aoju.bus.core.convert.Convert;
import org.aoju.bus.core.io.streams.ByteArrayOutputStream;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.lang.Normal;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.text.TextBuilder;
import org.aoju.bus.core.toolkit.ArrayKit;
import org.aoju.bus.core.toolkit.IoKit;
import org.aoju.bus.core.toolkit.IterKit;
import org.aoju.bus.core.toolkit.MapKit;
import org.aoju.bus.core.toolkit.MathKit;
import org.aoju.bus.core.toolkit.ReflectKit;
import org.aoju.bus.core.toolkit.StringKit;

public class ObjectKit {
    public static boolean isNull(Object obj) {
        return null == obj || obj.equals(null);
    }

    public static boolean isNotNull(Object obj) {
        return false == ObjectKit.isNull(obj);
    }

    public static <T> T defaultIfNull(T object, T defaultValue) {
        return ObjectKit.isNull(object) ? defaultValue : object;
    }

    public static <T> T defaultIfNull(Object source, Supplier<? extends T> handle, T defaultValue) {
        if (ObjectKit.isNotNull(source)) {
            return handle.get();
        }
        return defaultValue;
    }

    public static <T> T defaultIfEmpty(String text, Supplier<? extends T> handle, T defaultValue) {
        if (StringKit.isNotEmpty(text)) {
            return handle.get();
        }
        return defaultValue;
    }

    public static <T extends CharSequence> T defaultIfEmpty(T text, T defaultValue) {
        return StringKit.isEmpty(text) ? defaultValue : text;
    }

    public static <T extends CharSequence> T defaultIfBlank(T text, T defaultValue) {
        return StringKit.isBlank(text) ? defaultValue : text;
    }

    public static boolean isTrue(Boolean object) {
        return Boolean.TRUE.equals(object);
    }

    public static boolean isFalse(Boolean object) {
        return null == object || Boolean.FALSE.equals(object);
    }

    public static boolean isArray(Object object) {
        return null != object && object.getClass().isArray();
    }

    public static boolean isEmpty(Object object) {
        if (null == object) {
            return true;
        }
        if (object instanceof CharSequence) {
            return StringKit.isEmpty((CharSequence)object);
        }
        if (object instanceof Map) {
            return MapKit.isEmpty((Map)object);
        }
        if (object instanceof Iterable) {
            return IterKit.isEmpty((Iterable)object);
        }
        if (object instanceof Iterator) {
            return IterKit.isEmpty((Iterator)object);
        }
        if (ArrayKit.isArray(object)) {
            return ArrayKit.isEmpty(object);
        }
        return false;
    }

    public static final boolean isNotEmpty(Object object) {
        return !ObjectKit.isEmpty(object);
    }

    public static boolean isAllEmpty(Object ... objs) {
        return ArrayKit.isAllEmpty(objs);
    }

    public static boolean isAllNotEmpty(Object ... objs) {
        return ArrayKit.isAllNotEmpty(objs);
    }

    public static boolean equals(Object obj1, Object obj2) {
        return ObjectKit.equal(obj1, obj2);
    }

    public static boolean equal(Object obj1, Object obj2) {
        if (obj1 instanceof BigDecimal && obj2 instanceof BigDecimal) {
            return MathKit.equals((BigDecimal)obj1, (BigDecimal)obj2);
        }
        return Objects.equals(obj1, obj2);
    }

    public static boolean equal(byte[] byte1, byte[] byte2) {
        if (byte1 == byte2) {
            return true;
        }
        if (null == byte1 || null == byte2) {
            return false;
        }
        if (byte1.length != byte2.length) {
            return false;
        }
        int result = 0;
        for (int i = 0; i < byte1.length; ++i) {
            result |= byte1[i] ^ byte2[i];
        }
        return result == 0;
    }

    public static boolean notEqual(Object obj1, Object obj2) {
        return false == ObjectKit.equal(obj1, obj2);
    }

    public static int length(Object obj) {
        if (null == obj) {
            return 0;
        }
        if (obj instanceof CharSequence) {
            return ((CharSequence)obj).length();
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).size();
        }
        if (obj instanceof Map) {
            return ((Map)obj).size();
        }
        if (obj instanceof Iterator) {
            Iterator iter = (Iterator)obj;
            int count = 0;
            while (iter.hasNext()) {
                ++count;
                iter.next();
            }
            return count;
        }
        if (obj instanceof Enumeration) {
            Enumeration enumeration = (Enumeration)obj;
            int count = 0;
            while (enumeration.hasMoreElements()) {
                ++count;
                enumeration.nextElement();
            }
            return count;
        }
        if (obj.getClass().isArray()) {
            return Array.getLength(obj);
        }
        return -1;
    }

    public static boolean contains(Object obj, Object element) {
        if (null == obj) {
            return false;
        }
        if (obj instanceof String) {
            if (null == element) {
                return false;
            }
            return ((String)obj).contains(element.toString());
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).contains(element);
        }
        if (obj instanceof Map) {
            return ((Map)obj).containsValue(element);
        }
        if (obj instanceof Iterator) {
            Iterator iter = (Iterator)obj;
            while (iter.hasNext()) {
                Object o = iter.next();
                if (!ObjectKit.equal(o, element)) continue;
                return true;
            }
            return false;
        }
        if (obj instanceof Enumeration) {
            Enumeration enumeration = (Enumeration)obj;
            while (enumeration.hasMoreElements()) {
                Object o = enumeration.nextElement();
                if (!ObjectKit.equal(o, element)) continue;
                return true;
            }
            return false;
        }
        if (obj.getClass().isArray()) {
            int len = Array.getLength(obj);
            for (int i = 0; i < len; ++i) {
                Object o = Array.get(obj, i);
                if (!ObjectKit.equal(o, element)) continue;
                return true;
            }
        }
        return false;
    }

    public static <T> T clone(T obj) {
        T result = ArrayKit.clone(obj);
        if (null == result) {
            result = obj instanceof Cloneable ? ReflectKit.invoke(obj, "clone", new Object[0]) : ObjectKit.cloneByStream(obj);
        }
        return result;
    }

    public static String toString(Object obj) {
        if (null == obj) {
            return "null";
        }
        if (obj instanceof Map) {
            return obj.toString();
        }
        return Convert.toString(obj);
    }

    public static <T> T cloneByStream(T obj) {
        if (null == obj || !(obj instanceof Serializable)) {
            return null;
        }
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        ObjectOutputStream out = null;
        try {
            out = new ObjectOutputStream(byteOut);
            out.writeObject(obj);
            out.flush();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(byteOut.toByteArray()));
            return (T)in.readObject();
        }
        catch (Exception e) {
            throw new InstrumentException(e);
        }
    }

    public static <T extends Comparable<? super T>> int compare(T c1, T c2) {
        return ObjectKit.compare(c1, c2, false);
    }

    public static int compare(String v1, String v2, boolean complete) {
        if (v1 == v2) {
            return 0;
        }
        if (null == v1) {
            return -1;
        }
        if (null == v2) {
            return 1;
        }
        if ((v1 = v1.trim()).equals(v2 = v2.trim())) {
            return 0;
        }
        String[] v1s = v1.split("\\.");
        String[] v2s = v2.split("\\.");
        int v1sLen = v1s.length;
        int v2sLen = v2s.length;
        int len = complete ? Math.max(v1sLen, v2sLen) : Math.min(v1sLen, v2sLen);
        for (int i = 0; i < len; ++i) {
            String c2;
            String c1 = len > v1sLen || null == v1s[i] ? "" : v1s[i];
            int result = c1.compareTo(c2 = len > v2sLen || null == v2s[i] ? "" : v2s[i]);
            if (result == 0) continue;
            return result;
        }
        return 0;
    }

    public static <T extends Comparable<? super T>> int compare(T c1, T c2, boolean isNullGreater) {
        if (c1 == c2) {
            return 0;
        }
        if (null == c1) {
            return isNullGreater ? 1 : -1;
        }
        if (null == c2) {
            return isNullGreater ? -1 : 1;
        }
        return c1.compareTo(c2);
    }

    public static <T> int compare(T c1, T c2, Comparator<T> comparator) {
        if (null == comparator) {
            return ObjectKit.compare((Comparable)c1, (Comparable)c2);
        }
        return comparator.compare(c1, c2);
    }

    public static <T> int compare(T o1, T o2, boolean isNullGreater) {
        if (o1 == o2) {
            return 0;
        }
        if (null == o1) {
            return isNullGreater ? 1 : -1;
        }
        if (null == o2) {
            return isNullGreater ? -1 : 1;
        }
        if (o1 instanceof Comparable && o2 instanceof Comparable) {
            return ((Comparable)o1).compareTo(o2);
        }
        if (o1.equals(o2)) {
            return 0;
        }
        int result = Integer.compare(o1.hashCode(), o2.hashCode());
        if (0 == result) {
            result = ObjectKit.compare(o1.toString(), o2.toString());
        }
        return result;
    }

    public static <T> Comparator<T> compare(Function<T, String> object) {
        return ObjectKit.compare(object, false);
    }

    public static <T> Comparator<T> compare(Function<T, String> object, boolean reverse) {
        Objects.requireNonNull(object);
        PinyinCompare pinyinComparator = new PinyinCompare();
        if (reverse) {
            return (o1, o2) -> pinyinComparator.compare((String)object.apply(o2), (String)object.apply(o1));
        }
        return (o1, o2) -> pinyinComparator.compare((String)object.apply(o1), (String)object.apply(o2));
    }

    public static Field[] getAllFields(Object object) {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        for (Class<?> tempClass = object.getClass(); null != tempClass && !tempClass.getName().equalsIgnoreCase("java.lang.object"); tempClass = tempClass.getSuperclass()) {
            fieldList.addAll(Arrays.asList(tempClass.getDeclaredFields()));
        }
        Field[] fields = new Field[fieldList.size()];
        fieldList.toArray(fields);
        return fields;
    }

    public static byte[] toByte(Object obj) {
        try {
            java.io.ByteArrayOutputStream byteOut = new java.io.ByteArrayOutputStream();
            ObjectOutputStream objOut = new ObjectOutputStream(byteOut);
            objOut.writeObject(obj);
            return byteOut.toByteArray();
        }
        catch (Exception e) {
            throw new InstrumentException(e);
        }
    }

    public static <T> T toObject(String base64) {
        return ObjectKit.toObject(StringKit.base64ToByte(base64));
    }

    public static <T> T toObject(byte[] bts) {
        try {
            ByteArrayInputStream byteIn = new ByteArrayInputStream(bts);
            ObjectInputStream objIn = new ObjectInputStream(byteIn);
            return (T)objIn.readObject();
        }
        catch (Exception e) {
            throw new InstrumentException(e);
        }
    }

    public static Class getClassByName(String classAllName) {
        try {
            return Class.forName(classAllName);
        }
        catch (ClassNotFoundException e) {
            throw new InstrumentException(e);
        }
    }

    public static <T> T initObject(Class<T> clazz, Map<String, Object> attrMap) {
        try {
            T obj = clazz.newInstance();
            if (null != attrMap) {
                Class<T> tempClass = clazz;
                while (!tempClass.equals(Object.class)) {
                    Field[] fs;
                    for (Field f : fs = tempClass.getDeclaredFields()) {
                        f.setAccessible(true);
                        if (Modifier.isFinal(f.getModifiers())) {
                            attrMap.remove(f.getName());
                        }
                        f.setAccessible(false);
                    }
                    tempClass = tempClass.getSuperclass();
                }
                for (String attrName : attrMap.keySet()) {
                    ObjectKit.setAttribute(obj, attrName, attrMap.get(attrName));
                }
            }
            return obj;
        }
        catch (Exception e) {
            throw new InstrumentException(e);
        }
    }

    public static void setAttribute(Object obj, String attrName, Object value) {
        try {
            Class<?> clazz = obj.getClass();
            while (!clazz.equals(Object.class)) {
                try {
                    Field f = clazz.getDeclaredField(attrName);
                    f.setAccessible(true);
                    f.set(obj, value);
                    f.setAccessible(false);
                    return;
                }
                catch (NoSuchFieldException e) {
                    clazz = clazz.getSuperclass();
                }
            }
        }
        catch (Exception e) {
            throw new InstrumentException(e);
        }
    }

    public static Object getAttributeValue(Object obj, String attrName) {
        try {
            Class<?> clazz = obj.getClass();
            while (!clazz.equals(Object.class)) {
                try {
                    Field f = clazz.getDeclaredField(attrName);
                    f.setAccessible(true);
                    Object value = f.get(obj);
                    f.setAccessible(false);
                    return value;
                }
                catch (NoSuchFieldException e) {
                    clazz = clazz.getSuperclass();
                }
            }
            return null;
        }
        catch (Exception e) {
            throw new InstrumentException(e);
        }
    }

    public static Map<String, Object> getFields(Object bean) {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            Class<?> clazz = bean.getClass();
            while (!clazz.equals(Object.class)) {
                Field[] fs;
                for (Field f : fs = clazz.getDeclaredFields()) {
                    if (map.containsKey(f.getName())) continue;
                    f.setAccessible(true);
                    Object value = f.get(bean);
                    f.setAccessible(false);
                    map.put(f.getName(), value);
                }
                clazz = clazz.getSuperclass();
            }
            map.remove("serialVersionUID");
            return map;
        }
        catch (Exception e) {
            throw new InstrumentException(e);
        }
    }

    public static Map<String, Class> getFieldNames(Class clazz) {
        try {
            HashMap<String, Class> attrMap = new HashMap<String, Class>();
            while (!clazz.equals(Object.class)) {
                Field[] fs;
                for (Field f : fs = clazz.getDeclaredFields()) {
                    attrMap.put(f.getName(), f.getType());
                }
                clazz = clazz.getSuperclass();
            }
            attrMap.remove("serialVersionUID");
            return attrMap;
        }
        catch (Exception e) {
            throw new InstrumentException(e);
        }
    }

    public static Map<String, Object> getNotNullFields(Object bean, boolean hasInitValue) {
        try {
            if (hasInitValue) {
                ObjectKit.cleanInitValue(bean);
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            Class<?> clazz = bean.getClass();
            while (!clazz.equals(Object.class)) {
                Field[] fs;
                for (Field f : fs = clazz.getDeclaredFields()) {
                    if (map.containsKey(f.getName())) continue;
                    f.setAccessible(true);
                    Object value = f.get(bean);
                    f.setAccessible(false);
                    if (null == value) continue;
                    map.put(f.getName(), value);
                }
                clazz = clazz.getSuperclass();
            }
            map.remove("serialVersionUID");
            return map;
        }
        catch (Exception e) {
            throw new InstrumentException(e);
        }
    }

    public static Map<String, Object> getNotNullFields(Object bean) {
        return ObjectKit.getNotNullFields(bean, true);
    }

    public static Map<String, List<String>> getNotNullFieldsParam(Object bean) {
        return ObjectKit.getNotNullFieldsParam(bean, true);
    }

    public static Map<String, List<String>> getNotNullFieldsParam(Object bean, boolean hasInitValue) {
        try {
            if (hasInitValue) {
                ObjectKit.cleanInitValue(bean);
            }
            HashMap<String, List<String>> map = new HashMap<String, List<String>>();
            Class<?> clazz = bean.getClass();
            while (!clazz.equals(Object.class)) {
                Field[] fs;
                for (Field f : fs = clazz.getDeclaredFields()) {
                    if (map.containsKey(f.getName())) continue;
                    f.setAccessible(true);
                    Object value = f.get(bean);
                    f.setAccessible(false);
                    if (null == value) continue;
                    ArrayList<String> list = new ArrayList<String>();
                    list.add(String.valueOf(value));
                    map.put(f.getName(), list);
                }
                clazz = clazz.getSuperclass();
            }
            map.remove("serialVersionUID");
            return map;
        }
        catch (Exception e) {
            throw new InstrumentException(e);
        }
    }

    public static Map<String, Object> getNotNullFieldsForStructure(Object bean) {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            Class<?> clazz = bean.getClass();
            while (!clazz.equals(Object.class)) {
                Field[] fs;
                for (Field f : fs = clazz.getDeclaredFields()) {
                    if (map.containsKey(f.getName())) continue;
                    f.setAccessible(true);
                    Object value = f.get(bean);
                    f.setAccessible(false);
                    if (null == value) continue;
                    if (!ObjectKit.isNotStructure(value)) {
                        map.put(f.getName(), ObjectKit.getNotNullFieldsForStructure(value));
                        continue;
                    }
                    map.put(f.getName(), value);
                }
                clazz = clazz.getSuperclass();
            }
            map.remove("serialVersionUID");
            return map;
        }
        catch (Exception e) {
            throw new InstrumentException(e);
        }
    }

    public static <T> Class<T> getGeneric(Class clazz) {
        try {
            Type genType = clazz.getGenericSuperclass();
            if (!(genType instanceof ParameterizedType)) {
                return Object.class;
            }
            Type[] params = ((ParameterizedType)genType).getActualTypeArguments();
            return (Class)params[0];
        }
        catch (Exception e) {
            throw new InstrumentException(e);
        }
    }

    public static <T> T parseByteForObj(byte[] bts) {
        ByteArrayInputStream input = new ByteArrayInputStream(bts);
        ObjectInputStream objectInput = null;
        try {
            objectInput = new ObjectInputStream(input);
            Object object = objectInput.readObject();
            return (T)object;
        }
        catch (Exception e) {
            throw new InstrumentException(e);
        }
        finally {
            try {
                if (null != objectInput) {
                    objectInput.close();
                }
                if (null != input) {
                    input.close();
                }
            }
            catch (IOException e) {
                throw new InstrumentException(e);
            }
        }
    }

    public static byte[] parseObjForByte(Object obj) {
        java.io.ByteArrayOutputStream byteOut = new java.io.ByteArrayOutputStream();
        ObjectOutputStream objOut = null;
        try {
            objOut = new ObjectOutputStream(byteOut);
            objOut.writeObject(obj);
            byte[] byArray = byteOut.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
        finally {
            try {
                if (null != objOut) {
                    objOut.close();
                }
                if (null != byteOut) {
                    byteOut.close();
                }
            }
            catch (IOException e) {
                throw new InstrumentException(e);
            }
        }
    }

    public static <T> T parseToObject(Object value, Class<T> type) {
        Object result = null;
        if (null == value || type == String.class) {
            result = null == value ? null : value.toString();
        } else if (type == Character.class || type == Character.TYPE) {
            char[] chars = value.toString().toCharArray();
            result = chars.length > 0 ? (chars.length > 1 ? (Object)chars : Character.valueOf(chars[0])) : Character.valueOf('\u0000');
        } else if (type == Boolean.class || type == Boolean.TYPE) {
            result = Boolean.parseBoolean(value.toString());
        } else if (type == Double.class || type == Double.TYPE) {
            result = value.toString().equalsIgnoreCase("true") ? Boolean.valueOf(true) : (value.toString().equalsIgnoreCase("false") ? Boolean.valueOf(false) : value);
        } else if (type == Long.class || type == Long.TYPE) {
            result = Long.parseLong(value.toString());
        } else if (type == Integer.class || type == Integer.TYPE) {
            result = Integer.parseInt(value.toString());
        } else if (type == Double.class || type == Double.TYPE) {
            result = Double.parseDouble(value.toString());
        } else if (type == Float.class || type == Float.TYPE) {
            result = Float.valueOf(Float.parseFloat(value.toString()));
        } else if (type == Byte.class || type == Byte.TYPE) {
            result = Byte.parseByte(value.toString());
        } else if (type == Short.class || type == Short.TYPE) {
            result = Short.parseShort(value.toString());
        }
        return (T)result;
    }

    private static boolean isNotStructure(Object value) {
        if (!ObjectKit.isBaseClass(value)) {
            if (value instanceof Collection) {
                return true;
            }
            if (value instanceof Map) {
                return true;
            }
            if (value instanceof Date) {
                return true;
            }
            return value.getClass().isArray();
        }
        return true;
    }

    public static boolean isBaseClass(Object value) {
        if (null == value) {
            return true;
        }
        if (value instanceof Long) {
            return true;
        }
        if (value instanceof Integer) {
            return true;
        }
        if (value instanceof Double) {
            return true;
        }
        if (value instanceof Float) {
            return true;
        }
        if (value instanceof Byte) {
            return true;
        }
        if (value instanceof Boolean) {
            return true;
        }
        if (value instanceof Short) {
            return true;
        }
        if (value instanceof Character) {
            return true;
        }
        return value instanceof String;
    }

    public static <T> T CloneObject(Class<T> clazz, Object bean) {
        try {
            Map<String, Object> attrMap = ObjectKit.getFields(bean);
            return ObjectKit.initObject(clazz, attrMap);
        }
        catch (Exception e) {
            throw new InstrumentException(e);
        }
    }

    public static <T> T CloneObject(T bean) {
        try {
            Map<String, Object> attrMap = ObjectKit.getFields(bean);
            return (T)ObjectKit.initObject(bean.getClass(), attrMap);
        }
        catch (Exception e) {
            throw new InstrumentException(e);
        }
    }

    public static void insertObj(Object baseData, Object newData) {
        try {
            if (null == baseData || null == newData) {
                return;
            }
            Map<String, Object> attrList = ObjectKit.getNotNullFields(newData);
            Set<String> keys = attrList.keySet();
            if (null != keys && keys.size() > 0) {
                for (String key : keys) {
                    if (key.equals("serialVersionUID")) continue;
                    ObjectKit.setAttribute(baseData, key, attrList.get(key));
                }
            }
        }
        catch (Exception e) {
            throw new InstrumentException(e);
        }
    }

    public static <T> void cleanInitValue(T bean) {
        if (null == bean) {
            return;
        }
        try {
            Class<?> clazz = bean.getClass();
            Object obj = clazz.newInstance();
            while (!clazz.equals(Object.class)) {
                Field[] fs;
                for (Field f : fs = clazz.getDeclaredFields()) {
                    if (Modifier.isFinal(f.getModifiers())) continue;
                    f.setAccessible(true);
                    Object initValue = f.get(obj);
                    Object oldValue = f.get(bean);
                    if (null != initValue && initValue.equals(oldValue)) {
                        f.set(bean, null);
                    }
                    f.setAccessible(false);
                }
                clazz = clazz.getSuperclass();
            }
        }
        catch (Exception e) {
            throw new InstrumentException(e);
        }
    }

    public static String identityToString(Object object) {
        if (null == object) {
            return null;
        }
        String name = object.getClass().getName();
        String hexString = Integer.toHexString(System.identityHashCode(object));
        StringBuilder builder = new StringBuilder(name.length() + 1 + hexString.length());
        builder.append(name).append('@').append(hexString);
        return builder.toString();
    }

    public static void identityToString(Appendable appendable, Object object) throws IOException {
        Assert.notNull(object, "Cannot get the toString of a null object", new Object[0]);
        appendable.append(object.getClass().getName()).append('@').append(Integer.toHexString(System.identityHashCode(object)));
    }

    public static void identityToString(TextBuilder builder, Object object) {
        Assert.notNull(object, "Cannot get the toString of a null object", new Object[0]);
        String name = object.getClass().getName();
        String hexString = Integer.toHexString(System.identityHashCode(object));
        builder.ensureCapacity(builder.length() + name.length() + 1 + hexString.length());
        builder.append(name).append('@').append(hexString);
    }

    public static void identityToString(StringBuffer buffer, Object object) {
        Assert.notNull(object, "Cannot get the toString of a null object", new Object[0]);
        String name = object.getClass().getName();
        String hexString = Integer.toHexString(System.identityHashCode(object));
        buffer.ensureCapacity(buffer.length() + name.length() + 1 + hexString.length());
        buffer.append(name).append('@').append(hexString);
    }

    public static void identityToString(StringBuilder builder, Object object) {
        Assert.notNull(object, "Cannot get the toString of a null object", new Object[0]);
        String name = object.getClass().getName();
        String hexString = Integer.toHexString(System.identityHashCode(object));
        builder.ensureCapacity(builder.length() + name.length() + 1 + hexString.length());
        builder.append(name).append('@').append(hexString);
    }

    public static boolean nullSafeEquals(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (null == o1 || null == o2) {
            return false;
        }
        if (o1.equals(o2)) {
            return true;
        }
        if (o1.getClass().isArray() && o2.getClass().isArray()) {
            return ObjectKit.arrayEquals(o1, o2);
        }
        return false;
    }

    private static boolean arrayEquals(Object o1, Object o2) {
        if (o1 instanceof Object[] && o2 instanceof Object[]) {
            return Arrays.equals((Object[])o1, (Object[])o2);
        }
        if (o1 instanceof boolean[] && o2 instanceof boolean[]) {
            return Arrays.equals((boolean[])o1, (boolean[])o2);
        }
        if (o1 instanceof byte[] && o2 instanceof byte[]) {
            return Arrays.equals((byte[])o1, (byte[])o2);
        }
        if (o1 instanceof char[] && o2 instanceof char[]) {
            return Arrays.equals((char[])o1, (char[])o2);
        }
        if (o1 instanceof double[] && o2 instanceof double[]) {
            return Arrays.equals((double[])o1, (double[])o2);
        }
        if (o1 instanceof float[] && o2 instanceof float[]) {
            return Arrays.equals((float[])o1, (float[])o2);
        }
        if (o1 instanceof int[] && o2 instanceof int[]) {
            return Arrays.equals((int[])o1, (int[])o2);
        }
        if (o1 instanceof long[] && o2 instanceof long[]) {
            return Arrays.equals((long[])o1, (long[])o2);
        }
        if (o1 instanceof short[] && o2 instanceof short[]) {
            return Arrays.equals((short[])o1, (short[])o2);
        }
        return false;
    }

    public static Object[] toObjectArray(Object source) {
        if (source instanceof Object[]) {
            return (Object[])source;
        }
        if (null == source) {
            return Normal.EMPTY_OBJECT_ARRAY;
        }
        if (!source.getClass().isArray()) {
            throw new IllegalArgumentException("Source is not an array: " + source);
        }
        int length = Array.getLength(source);
        if (length == 0) {
            return Normal.EMPTY_OBJECT_ARRAY;
        }
        Class<?> wrapperType = Array.get(source, 0).getClass();
        Object[] newArray = (Object[])Array.newInstance(wrapperType, length);
        for (int i = 0; i < length; ++i) {
            newArray[i] = Array.get(source, i);
        }
        return newArray;
    }

    public static <T> byte[] serialize(T obj) {
        if (!(obj instanceof Serializable)) {
            return null;
        }
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        IoKit.writeObjects(byteOut, false, (Serializable)obj);
        return byteOut.toByteArray();
    }

    public static <T> T deserialize(byte[] bytes) {
        return IoKit.readObj(new ByteArrayInputStream(bytes));
    }
}

