/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.extra.pinyin.provider;

import com.github.stuxuhai.jpinyin.PinyinException;
import com.github.stuxuhai.jpinyin.PinyinFormat;
import com.github.stuxuhai.jpinyin.PinyinHelper;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.toolkit.ArrayKit;
import org.aoju.bus.extra.pinyin.provider.AbstractPinyinProvider;

public class JPinyinProvider
extends AbstractPinyinProvider {
    PinyinFormat format;

    public JPinyinProvider() {
        this(null);
    }

    public JPinyinProvider(PinyinFormat format) {
        this.init(format);
    }

    public void init(PinyinFormat format) {
        if (null == format) {
            format = PinyinFormat.WITHOUT_TONE;
        }
        this.format = format;
    }

    @Override
    public String getPinyin(char c) {
        String[] results = PinyinHelper.convertToPinyinArray((char)c, (PinyinFormat)this.format);
        return ArrayKit.isEmpty(results) ? String.valueOf(c) : results[0];
    }

    @Override
    public String getPinyin(String text, String separator) {
        try {
            return PinyinHelper.convertToPinyinString((String)text, (String)separator, (PinyinFormat)this.format);
        }
        catch (PinyinException e) {
            throw new InstrumentException(e);
        }
    }
}

