/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health;

import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.aoju.bus.core.annotation.ThreadSafe;
import org.aoju.bus.health.Config;

@ThreadSafe
public final class Memoize {
    private static final Supplier<Long> DEFAULT_EXPIRATION_NANOS = Memoize.memoize(Memoize::queryExpirationConfig, TimeUnit.MINUTES.toNanos(1L));

    private Memoize() {
    }

    private static long queryExpirationConfig() {
        return TimeUnit.MILLISECONDS.toNanos(Config.get("health.memoize.expiration", 300));
    }

    public static long defaultExpiration() {
        return DEFAULT_EXPIRATION_NANOS.get();
    }

    public static <T> Supplier<T> memoize(final Supplier<T> original, final long ttlNanos) {
        return new Supplier<T>(){
            final Supplier<T> delegate;
            volatile T value;
            volatile long expirationNanos;
            {
                this.delegate = original;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public T get() {
                long nanos = this.expirationNanos;
                long now = System.nanoTime();
                if (nanos == 0L || ttlNanos >= 0L && now - nanos >= 0L) {
                    1 var5_3 = this;
                    synchronized (var5_3) {
                        if (nanos == this.expirationNanos) {
                            Object t = this.delegate.get();
                            this.value = t;
                            nanos = now + ttlNanos;
                            this.expirationNanos = nanos == 0L ? 1L : nanos;
                            return t;
                        }
                    }
                }
                return this.value;
            }
        };
    }

    public static <T> Supplier<T> memoize(Supplier<T> original) {
        return Memoize.memoize(original, -1L);
    }
}

