/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.http.metric.http;

import java.net.URL;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import org.aoju.bus.http.Httpd;
import org.aoju.bus.http.metric.Handshake;
import org.aoju.bus.http.metric.Interceptor;
import org.aoju.bus.http.metric.http.DelegatingConnection;
import org.aoju.bus.http.metric.http.HttpURLConnection;

public final class HttpsURLConnection
extends DelegatingConnection {
    private final HttpURLConnection delegate;

    public HttpsURLConnection(URL url, Httpd client) {
        this(new HttpURLConnection(url, client));
    }

    public HttpsURLConnection(URL url, Httpd client, Interceptor filter) {
        this(new HttpURLConnection(url, client, filter));
    }

    public HttpsURLConnection(HttpURLConnection delegate) {
        super(delegate);
        this.delegate = delegate;
    }

    @Override
    protected Handshake handshake() {
        if (null == this.delegate.call) {
            throw new IllegalStateException("Connection has not yet been established");
        }
        return this.delegate.handshake;
    }

    @Override
    public HostnameVerifier getHostnameVerifier() {
        return this.delegate.client.hostnameVerifier();
    }

    @Override
    public void setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.delegate.client = this.delegate.client.newBuilder().hostnameVerifier(hostnameVerifier).build();
    }

    @Override
    public SSLSocketFactory getSSLSocketFactory() {
        return this.delegate.client.sslSocketFactory();
    }

    @Override
    public void setSSLSocketFactory(SSLSocketFactory sslSocketFactory) {
        if (null == sslSocketFactory) {
            throw new IllegalArgumentException("sslSocketFactory == null");
        }
        this.delegate.client = this.delegate.client.newBuilder().sslSocketFactory(sslSocketFactory).build();
    }
}

