/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.galaxy;

import java.util.Calendar;
import org.aoju.bus.image.galaxy.BinaryPrefix;
import org.aoju.bus.image.galaxy.Property;
import org.aoju.bus.image.galaxy.ScheduleExpression;
import org.aoju.bus.image.galaxy.StorageThreshold;

public class DeleterThreshold
extends StorageThreshold
implements Comparable<DeleterThreshold> {
    protected final ScheduleExpression schedule;

    public DeleterThreshold(String value, long minUsableSpace, ScheduleExpression schedule) {
        super(value, minUsableSpace);
        this.schedule = schedule;
    }

    public static DeleterThreshold valueOf(String s) {
        String[] split1 = Property.split(s, ']');
        switch (split1.length) {
            case 1: {
                return new DeleterThreshold(s, BinaryPrefix.parse(s), null);
            }
            case 2: {
                String[] split2 = Property.split(split1[0], '[');
                if (split2.length != 2) break;
                return new DeleterThreshold(s, BinaryPrefix.parse(split1[split1.length - 1]), ScheduleExpression.valueOf(split2[1]));
            }
        }
        throw new IllegalArgumentException(s);
    }

    public String getPrefix() {
        return this.value.substring(0, this.value.indexOf(93) + 1);
    }

    public boolean match(Calendar cal) {
        return null == this.schedule || this.schedule.contains(cal);
    }

    @Override
    public int compareTo(DeleterThreshold o) {
        return null != this.schedule ? (null != o.schedule ? this.value.compareTo(o.value) : -1) : (null != o.schedule ? 1 : 0);
    }
}

