/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.nimble.codec;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeMap;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageReaderSpi;
import org.aoju.bus.core.lang.Normal;
import org.aoju.bus.core.toolkit.FileKit;
import org.aoju.bus.image.galaxy.Property;
import org.aoju.bus.image.nimble.codec.FormatNameFilterIterator;
import org.aoju.bus.image.nimble.codec.jpeg.PatchJPEGLS;
import org.aoju.bus.logger.Logger;

public class ImageReaderFactory
implements Serializable {
    private static volatile ImageReaderFactory defaultFactory;
    private final TreeMap<String, ImageReaderParam> map = new TreeMap();

    private static String nullify(String s) {
        return null == s || s.isEmpty() || s.equals("*") ? null : s;
    }

    public static ImageReaderFactory getDefault() {
        if (null == defaultFactory) {
            defaultFactory = ImageReaderFactory.initDefault();
        }
        return defaultFactory;
    }

    public static void setDefault(ImageReaderFactory factory) {
        if (null == factory) {
            throw new NullPointerException();
        }
        defaultFactory = factory;
    }

    public static void resetDefault() {
        defaultFactory = null;
    }

    private static ImageReaderFactory initDefault() {
        ImageReaderFactory factory = new ImageReaderFactory();
        URL url = FileKit.getResource("ImageReaderFactory.properties", ImageReaderFactory.class);
        try {
            factory.load(url.openStream());
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load Image Reader Factory configuration from: " + url.toString(), e);
        }
        return factory;
    }

    public static ImageReaderParam getImageReaderParam(String tsuid) {
        return ImageReaderFactory.getDefault().get(tsuid);
    }

    public static boolean canDecompress(String tsuid) {
        return ImageReaderFactory.getDefault().contains(tsuid);
    }

    public static ImageReader getImageReader(ImageReaderParam param) {
        return Boolean.getBoolean("org.aoju.bus.image.nimble.codec.useServiceLoader") ? ImageReaderFactory.getImageReaderFromServiceLoader(param) : ImageReaderFactory.getImageReaderFromImageIOServiceRegistry(param);
    }

    public static ImageReader getImageReaderFromImageIOServiceRegistry(ImageReaderParam param) {
        Iterator<ImageReader> iter = ImageIO.getImageReadersByFormatName(param.formatName);
        if (!iter.hasNext()) {
            throw new RuntimeException("No Reader for format: " + param.formatName + " registered");
        }
        ImageReader reader = iter.next();
        if (null != param.className) {
            while (!param.className.equals(reader.getClass().getName())) {
                if (iter.hasNext()) {
                    reader = iter.next();
                    continue;
                }
                Logger.warn("No preferred Reader {} for format: {} - use {}", param.className, param.formatName, reader.getClass().getName());
                break;
            }
        }
        return reader;
    }

    public static ImageReader getImageReaderFromServiceLoader(ImageReaderParam param) {
        try {
            return ImageReaderFactory.getImageReaderSpi(param).createReaderInstance();
        }
        catch (IOException e) {
            throw new RuntimeException("Error instantiating Reader for format: " + param.formatName, e);
        }
    }

    private static ImageReaderSpi getImageReaderSpi(ImageReaderParam param) {
        FormatNameFilterIterator<ImageReaderSpi> iter = new FormatNameFilterIterator<ImageReaderSpi>(ServiceLoader.load(ImageReaderSpi.class).iterator(), param.formatName);
        if (!iter.hasNext()) {
            throw new RuntimeException("No Reader for format: " + param.formatName + " registered");
        }
        ImageReaderSpi spi = (ImageReaderSpi)iter.next();
        if (null != param.className) {
            while (!param.className.equals(spi.getPluginClassName())) {
                if (iter.hasNext()) {
                    spi = (ImageReaderSpi)iter.next();
                    continue;
                }
                Logger.warn("No preferred Reader {} for format: {} - use {}", param.className, param.formatName, spi.getPluginClassName());
                break;
            }
        }
        return spi;
    }

    public void load(InputStream in) throws IOException {
        Properties props = new Properties();
        props.load(in);
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String[] ss = Property.split((String)entry.getValue(), ':');
            this.map.put((String)entry.getKey(), new ImageReaderParam(ss[0], ss[1], ss[2], ss.length > 3 ? Property.split(ss[3], ';') : Normal.EMPTY_STRING_ARRAY));
        }
    }

    public ImageReaderParam get(String tsuid) {
        return this.map.get(tsuid);
    }

    public boolean contains(String tsuid) {
        return this.map.containsKey(tsuid);
    }

    public ImageReaderParam put(String tsuid, ImageReaderParam param) {
        return this.map.put(tsuid, param);
    }

    public ImageReaderParam remove(String tsuid) {
        return this.map.remove(tsuid);
    }

    public Set<Map.Entry<String, ImageReaderParam>> getEntries() {
        return Collections.unmodifiableMap(this.map).entrySet();
    }

    public void clear() {
        this.map.clear();
    }

    public static class ImageReaderParam
    implements Serializable {
        public final String formatName;
        public final String className;
        public final PatchJPEGLS patchJPEGLS;
        public final Property[] imageReadParams;

        public ImageReaderParam(String formatName, String className, PatchJPEGLS patchJPEGLS, Property[] imageReadParams) {
            this.formatName = formatName;
            this.className = ImageReaderFactory.nullify(className);
            this.patchJPEGLS = patchJPEGLS;
            this.imageReadParams = imageReadParams;
        }

        public ImageReaderParam(String formatName, String className, String patchJPEGLS, String ... imageWriteParams) {
            this(formatName, className, null != patchJPEGLS && !patchJPEGLS.isEmpty() ? PatchJPEGLS.valueOf(patchJPEGLS) : null, Property.valueOf(imageWriteParams));
        }

        public Property[] getImageReadParams() {
            return this.imageReadParams;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (null == o || this.getClass() != o.getClass()) {
                return false;
            }
            ImageReaderParam that = (ImageReaderParam)o;
            if (!this.formatName.equals(that.formatName)) {
                return false;
            }
            if (null != this.className ? !this.className.equals(that.className) : null != that.className) {
                return false;
            }
            if (this.patchJPEGLS != that.patchJPEGLS) {
                return false;
            }
            return Arrays.equals(this.imageReadParams, that.imageReadParams);
        }

        public int hashCode() {
            int result = this.formatName.hashCode();
            result = 31 * result + (null != this.className ? this.className.hashCode() : 0);
            result = 31 * result + (null != this.patchJPEGLS ? this.patchJPEGLS.hashCode() : 0);
            result = 31 * result + Arrays.hashCode(this.imageReadParams);
            return result;
        }

        public String toString() {
            return "ImageReaderParam{formatName='" + this.formatName + '\'' + ", className='" + this.className + '\'' + ", patchJPEGLS=" + (Object)((Object)this.patchJPEGLS) + ", imageReaderParam=" + Arrays.toString(this.imageReadParams) + '}';
        }
    }
}

