/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.notify.provider.aliyun;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.aoju.bus.core.lang.Algorithm;
import org.aoju.bus.core.lang.Charset;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.extra.json.JsonKit;
import org.aoju.bus.notify.Builder;
import org.aoju.bus.notify.Context;
import org.aoju.bus.notify.magic.Message;
import org.aoju.bus.notify.magic.Property;
import org.aoju.bus.notify.provider.AbstractProvider;

public class AliyunProvider<T extends Property, K extends Context>
extends AbstractProvider<T, K> {
    private static final String SUCCESS_RESULT = "OK";

    public AliyunProvider(K properties) {
        super(properties);
    }

    protected String specialUrlEncode(String value) {
        try {
            return URLEncoder.encode(value, "UTF-8").replace("+", "%20").replace("*", "%2A").replace("%7E", "~");
        }
        catch (UnsupportedEncodingException e) {
            throw new InstrumentException("Aliyun specialUrlEncode error");
        }
    }

    protected String getSign(Map<String, String> params) {
        TreeMap<String, String> map = new TreeMap<String, String>(params);
        Iterator it = map.keySet().iterator();
        StringBuilder sortQueryStringTmp = new StringBuilder();
        while (it.hasNext()) {
            String key = (String)it.next();
            sortQueryStringTmp.append("&").append(this.specialUrlEncode(key)).append("=").append(this.specialUrlEncode(params.get(key)));
        }
        String sortedQueryString = sortQueryStringTmp.substring(1);
        String stringToSign = "GET&" + this.specialUrlEncode("/") + "&" + this.specialUrlEncode(sortedQueryString);
        return this.sign(stringToSign);
    }

    protected String sign(String stringToSign) {
        try {
            Mac mac = Mac.getInstance(Algorithm.HMACSHA1.getValue());
            mac.init(new SecretKeySpec((this.properties.getAppSecret() + "&").getBytes(Charset.UTF_8), Algorithm.HMACSHA1.getValue()));
            byte[] signData = mac.doFinal(stringToSign.getBytes(Charset.UTF_8));
            return Base64.getEncoder().encodeToString(signData);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new InstrumentException("Aliyun specialUrlEncode error");
        }
    }

    protected Message checkResponse(String response) {
        String code = (String)JsonKit.getValue(response, "Code");
        return Message.builder().errcode(SUCCESS_RESULT.equals(code) ? Builder.ErrorCode.SUCCESS.getCode() : code).errmsg(code).build();
    }
}

