/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.oauth.provider;

import com.alibaba.fastjson.JSONObject;
import org.aoju.bus.cache.metric.ExtendCache;
import org.aoju.bus.core.lang.Normal;
import org.aoju.bus.core.lang.exception.AuthorizedException;
import org.aoju.bus.oauth.Builder;
import org.aoju.bus.oauth.Context;
import org.aoju.bus.oauth.Registry;
import org.aoju.bus.oauth.magic.AccToken;
import org.aoju.bus.oauth.magic.Callback;
import org.aoju.bus.oauth.magic.Property;
import org.aoju.bus.oauth.provider.AbstractProvider;

public class ToutiaoProvider
extends AbstractProvider {
    public ToutiaoProvider(Context context) {
        super(context, Registry.TOUTIAO);
    }

    public ToutiaoProvider(Context context, ExtendCache extendCache) {
        super(context, Registry.TOUTIAO, extendCache);
    }

    @Override
    public AccToken getAccessToken(Callback callback) {
        JSONObject object = JSONObject.parseObject((String)this.doGetAuthorizationCode(callback.getCode()));
        this.checkResponse(object);
        return AccToken.builder().accessToken(object.getString("access_token")).expireIn(object.getIntValue("expires_in")).openId(object.getString("open_id")).build();
    }

    @Override
    public Property getUserInfo(AccToken accToken) {
        JSONObject jsonObject = JSONObject.parseObject((String)this.doGetUserInfo(accToken));
        this.checkResponse(jsonObject);
        JSONObject object = jsonObject.getJSONObject("data");
        boolean isAnonymousUser = object.getIntValue("uid_type") == 14;
        String anonymousUserName = "\u533f\u540d\u7528\u6237";
        return Property.builder().rawJson(object).uuid(object.getString("uid")).username(isAnonymousUser ? anonymousUserName : object.getString("screen_name")).nickname(isAnonymousUser ? anonymousUserName : object.getString("screen_name")).avatar(object.getString("avatar_url")).remark(object.getString("description")).gender(Normal.Gender.of(object.getString("gender"))).token(accToken).source(this.source.toString()).build();
    }

    @Override
    public String authorize(String state) {
        return Builder.fromUrl(this.source.authorize()).queryParam("response_type", "code").queryParam("client_key", this.context.getAppKey()).queryParam("redirect_uri", this.context.getRedirectUri()).queryParam("auth_only", 1).queryParam("display", 0).queryParam("state", this.getRealState(state)).build();
    }

    @Override
    public String accessTokenUrl(String code) {
        return Builder.fromUrl(this.source.accessToken()).queryParam("code", code).queryParam("client_key", this.context.getAppKey()).queryParam("client_secret", this.context.getAppSecret()).queryParam("grant_type", "authorization_code").build();
    }

    @Override
    public String userInfoUrl(AccToken accToken) {
        return Builder.fromUrl(this.source.userInfo()).queryParam("client_key", this.context.getAppKey()).queryParam("access_token", accToken.getAccessToken()).build();
    }

    private void checkResponse(JSONObject object) {
        if (object.containsKey((Object)"error_code")) {
            throw new AuthorizedException(Error.getErrorCode(object.getString("error_code")).getDesc());
        }
    }

    public static enum Error {
        EC0("0", "\u63a5\u53e3\u8c03\u7528\u6210\u529f"),
        EC1("1", "API\u914d\u7f6e\u9519\u8bef,\u672a\u4f20\u5165Client Key"),
        EC2("2", "API\u914d\u7f6e\u9519\u8bef,Client Key\u9519\u8bef,\u8bf7\u68c0\u67e5\u662f\u5426\u548c\u5f00\u653e\u5e73\u53f0\u7684ClientKey\u4e00\u81f4"),
        EC3("3", "\u6ca1\u6709\u6388\u6743\u4fe1\u606f"),
        EC4("4", "\u54cd\u5e94\u7c7b\u578b\u9519\u8bef"),
        EC5("5", "\u6388\u6743\u7c7b\u578b\u9519\u8bef"),
        EC6("6", "client_secret\u9519\u8bef"),
        EC7("7", "authorize_code\u8fc7\u671f"),
        EC8("8", "\u6307\u5b9aurl\u7684scheme\u4e0d\u662fhttps"),
        EC9("9", "\u63a5\u53e3\u5185\u90e8\u9519\u8bef,\u8bf7\u8054\u7cfb\u5934\u6761\u6280\u672f"),
        EC10("10", "access_token\u8fc7\u671f"),
        EC11("11", "\u7f3a\u5c11access_token"),
        EC12("12", "\u53c2\u6570\u7f3a\u5931"),
        EC13("13", "url\u9519\u8bef"),
        EC21("21", "\u57df\u540d\u4e0e\u767b\u8bb0\u57df\u540d\u4e0d\u5339\u914d"),
        EC999("999", "\u672a\u77e5\u9519\u8bef,\u8bf7\u8054\u7cfb\u5934\u6761\u6280\u672f");

        private final String code;
        private final String desc;

        public static Error getErrorCode(String errorCode) {
            Error[] errorCodes;
            for (Error code : errorCodes = Error.values()) {
                if (code.getCode() != errorCode) continue;
                return code;
            }
            return EC999;
        }

        public String getCode() {
            return this.code;
        }

        public String getDesc() {
            return this.desc;
        }

        private Error(String code, String desc) {
            this.code = code;
            this.desc = desc;
        }
    }
}

