/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.pager.dialect.auto;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import org.aoju.bus.core.lang.exception.PageException;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.pager.AutoDialect;
import org.aoju.bus.pager.dialect.AbstractPaging;
import org.aoju.bus.pager.proxy.PageAutoDialect;
import org.apache.ibatis.mapping.MappedStatement;

public class Early
implements AutoDialect<String> {
    public static final AutoDialect<String> DEFAULT = new Early();

    @Override
    public String extractDialectKey(MappedStatement ms, DataSource dataSource, Properties properties) {
        Connection conn = null;
        try {
            conn = dataSource.getConnection();
            String string = conn.getMetaData().getURL();
            return string;
        }
        catch (SQLException e) {
            throw new PageException(e);
        }
        finally {
            if (conn != null) {
                try {
                    String closeConn = properties.getProperty("closeConn");
                    if (StringKit.isEmpty(closeConn) || Boolean.parseBoolean(closeConn)) {
                        conn.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    @Override
    public AbstractPaging extractDialect(String dialectKey, MappedStatement ms, DataSource dataSource, Properties properties) {
        String dialectStr = PageAutoDialect.fromJdbcUrl(dialectKey);
        if (dialectStr == null) {
            throw new PageException("\u65e0\u6cd5\u81ea\u52a8\u83b7\u53d6\u6570\u636e\u5e93\u7c7b\u578b\uff0c\u8bf7\u901a\u8fc7 dialect \u53c2\u6570\u6307\u5b9a!");
        }
        return PageAutoDialect.instanceDialect(dialectStr, properties);
    }
}

