/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.pager.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.operators.relational.GreaterThan;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.AllColumns;
import net.sf.jsqlparser.statement.select.AllTableColumns;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.LateralSubSelect;
import net.sf.jsqlparser.statement.select.OrderByElement;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.SetOperationList;
import net.sf.jsqlparser.statement.select.SubJoin;
import net.sf.jsqlparser.statement.select.SubSelect;
import net.sf.jsqlparser.statement.select.Top;
import net.sf.jsqlparser.statement.select.ValuesList;
import net.sf.jsqlparser.statement.select.WithItem;
import org.aoju.bus.core.lang.exception.PageException;

public class SqlServerParser {
    public static final String START_ROW = String.valueOf(Long.MIN_VALUE);
    public static final String PAGE_SIZE = String.valueOf(Long.MAX_VALUE);
    protected static final String WRAP_TABLE = "WRAP_OUTER_TABLE";
    protected static final String PAGE_TABLE_NAME = "PAGE_TABLE_ALIAS";
    public static final Alias PAGE_TABLE_ALIAS = new Alias("PAGE_TABLE_ALIAS");
    protected static final String PAGE_ROW_NUMBER = "PAGE_ROW_NUMBER";
    protected static final Column PAGE_ROW_NUMBER_COLUMN = new Column("PAGE_ROW_NUMBER");
    protected static final Top TOP100_PERCENT = new Top();
    protected static final String PAGE_COLUMN_ALIAS_PREFIX = "ROW_ALIAS_";

    public String convertToPageSql(String sql) {
        return this.convertToPageSql(sql, null, null);
    }

    public String convertToPageSql(String sql, Integer offset, Integer limit) {
        Statement stmt;
        try {
            stmt = CCJSqlParserUtil.parse((String)sql);
        }
        catch (Throwable e) {
            throw new PageException("\u4e0d\u652f\u6301\u8be5SQL\u8f6c\u6362\u4e3a\u5206\u9875\u67e5\u8be2!", e);
        }
        if (!(stmt instanceof Select)) {
            throw new PageException("\u5206\u9875\u8bed\u53e5\u5fc5\u987b\u662fSelect\u67e5\u8be2!");
        }
        Select pageSelect = this.getPageSelect((Select)stmt);
        String pageSql = pageSelect.toString();
        if (null != offset) {
            pageSql = pageSql.replace(START_ROW, String.valueOf(offset));
        }
        if (null != limit) {
            pageSql = pageSql.replace(PAGE_SIZE, String.valueOf(limit));
        }
        return pageSql;
    }

    protected Select getPageSelect(Select select) {
        SelectBody selectBody = select.getSelectBody();
        if (selectBody instanceof SetOperationList) {
            selectBody = this.wrapSetOperationList((SetOperationList)selectBody);
        }
        if (((PlainSelect)selectBody).getTop() != null) {
            throw new PageException("\u88ab\u5206\u9875\u7684\u8bed\u53e5\u5df2\u7ecf\u5305\u542b\u4e86Top\uff0c\u4e0d\u80fd\u518d\u901a\u8fc7\u5206\u9875\u63d2\u4ef6\u8fdb\u884c\u5206\u9875\u67e5\u8be2!");
        }
        List<SelectItem> selectItems = this.getSelectItems((PlainSelect)selectBody);
        ArrayList<SelectItem> autoItems = new ArrayList<SelectItem>();
        SelectItem orderByColumn = this.addRowNumber((PlainSelect)selectBody, autoItems);
        ((PlainSelect)selectBody).addSelectItems(autoItems.toArray(new SelectItem[autoItems.size()]));
        this.processSelectBody(selectBody, 0);
        PlainSelect innerSelectBody = new PlainSelect();
        innerSelectBody.addSelectItems(new SelectItem[]{orderByColumn});
        innerSelectBody.addSelectItems(selectItems.toArray(new SelectItem[selectItems.size()]));
        SubSelect fromInnerItem = new SubSelect();
        fromInnerItem.setSelectBody(selectBody);
        fromInnerItem.setAlias(PAGE_TABLE_ALIAS);
        innerSelectBody.setFromItem((FromItem)fromInnerItem);
        Select newSelect = new Select();
        PlainSelect newSelectBody = new PlainSelect();
        Top top = new Top();
        top.setExpression((Expression)new LongValue(Long.MAX_VALUE));
        newSelectBody.setTop(top);
        ArrayList<OrderByElement> orderByElements = new ArrayList<OrderByElement>();
        OrderByElement orderByElement = new OrderByElement();
        orderByElement.setExpression((Expression)PAGE_ROW_NUMBER_COLUMN);
        orderByElements.add(orderByElement);
        newSelectBody.setOrderByElements(orderByElements);
        GreaterThan greaterThan = new GreaterThan();
        greaterThan.setLeftExpression((Expression)PAGE_ROW_NUMBER_COLUMN);
        greaterThan.setRightExpression((Expression)new LongValue(Long.MIN_VALUE));
        newSelectBody.setWhere((Expression)greaterThan);
        newSelectBody.setSelectItems(selectItems);
        SubSelect fromItem = new SubSelect();
        fromItem.setSelectBody((SelectBody)innerSelectBody);
        fromItem.setAlias(PAGE_TABLE_ALIAS);
        newSelectBody.setFromItem((FromItem)fromItem);
        newSelect.setSelectBody((SelectBody)newSelectBody);
        if (this.isNotEmptyList(select.getWithItemsList())) {
            newSelect.setWithItemsList(select.getWithItemsList());
        }
        return newSelect;
    }

    protected SelectBody wrapSetOperationList(SetOperationList setOperationList) {
        SelectBody setSelectBody = (SelectBody)setOperationList.getSelects().get(setOperationList.getSelects().size() - 1);
        if (!(setSelectBody instanceof PlainSelect)) {
            throw new PageException("\u76ee\u524d\u65e0\u6cd5\u5904\u7406\u8be5SQL!");
        }
        PlainSelect plainSelect = (PlainSelect)setSelectBody;
        PlainSelect selectBody = new PlainSelect();
        List<SelectItem> selectItems = this.getSelectItems(plainSelect);
        selectBody.setSelectItems(selectItems);
        SubSelect fromItem = new SubSelect();
        fromItem.setSelectBody((SelectBody)setOperationList);
        fromItem.setAlias(new Alias(WRAP_TABLE));
        selectBody.setFromItem((FromItem)fromItem);
        if (this.isNotEmptyList(plainSelect.getOrderByElements())) {
            selectBody.setOrderByElements(plainSelect.getOrderByElements());
            plainSelect.setOrderByElements(null);
        }
        return selectBody;
    }

    protected List<SelectItem> getSelectItems(PlainSelect plainSelect) {
        ArrayList<SelectItem> selectItems = new ArrayList<SelectItem>();
        for (SelectItem selectItem : plainSelect.getSelectItems()) {
            if (selectItem instanceof SelectExpressionItem) {
                Column column;
                SelectExpressionItem selectExpressionItem = (SelectExpressionItem)selectItem;
                if (null != selectExpressionItem.getAlias()) {
                    column = new Column(selectExpressionItem.getAlias().getName());
                    SelectExpressionItem expressionItem = new SelectExpressionItem((Expression)column);
                    selectItems.add((SelectItem)expressionItem);
                    continue;
                }
                if (selectExpressionItem.getExpression() instanceof Column) {
                    column = (Column)selectExpressionItem.getExpression();
                    if (null != column.getTable()) {
                        Column newColumn = new Column(column.getColumnName());
                        SelectExpressionItem item = new SelectExpressionItem((Expression)newColumn);
                        selectItems.add((SelectItem)item);
                        continue;
                    }
                    selectItems.add(selectItem);
                    continue;
                }
                selectItems.add(selectItem);
                continue;
            }
            if (selectItem instanceof AllTableColumns) {
                selectItems.add((SelectItem)new AllColumns());
                continue;
            }
            selectItems.add(selectItem);
        }
        for (SelectItem selectItem : selectItems) {
            if (!(selectItem instanceof AllColumns)) continue;
            return Collections.singletonList(selectItem);
        }
        return selectItems;
    }

    protected SelectItem addRowNumber(PlainSelect plainSelect, List<SelectItem> autoItems) {
        StringBuilder orderByBuilder = new StringBuilder();
        orderByBuilder.append("ROW_NUMBER() OVER (");
        if (this.isNotEmptyList(plainSelect.getOrderByElements())) {
            orderByBuilder.append(PlainSelect.orderByToString(this.getOrderByElements(plainSelect, autoItems)).substring(1));
            plainSelect.setOrderByElements(null);
        } else {
            orderByBuilder.append("ORDER BY RAND()");
        }
        orderByBuilder.append(") ");
        orderByBuilder.append(PAGE_ROW_NUMBER);
        return new SelectExpressionItem((Expression)new Column(orderByBuilder.toString()));
    }

    protected void processSelectBody(SelectBody selectBody, int level) {
        if (selectBody instanceof PlainSelect) {
            this.processPlainSelect((PlainSelect)selectBody, level + 1);
        } else if (selectBody instanceof WithItem) {
            WithItem withItem = (WithItem)selectBody;
            if (null != withItem.getSubSelect()) {
                this.processSelectBody(withItem.getSubSelect().getSelectBody(), level + 1);
            }
        } else {
            SetOperationList operationList = (SetOperationList)selectBody;
            if (operationList.getSelects() != null && operationList.getSelects().size() > 0) {
                List plainSelects = operationList.getSelects();
                for (SelectBody plainSelect : plainSelects) {
                    this.processSelectBody(plainSelect, level + 1);
                }
            }
        }
    }

    protected void processPlainSelect(PlainSelect plainSelect, int level) {
        if (level > 1 && this.isNotEmptyList(plainSelect.getOrderByElements()) && null == plainSelect.getTop()) {
            plainSelect.setTop(TOP100_PERCENT);
        }
        if (null != plainSelect.getFromItem()) {
            this.processFromItem(plainSelect.getFromItem(), level + 1);
        }
        if (null != plainSelect.getJoins() && plainSelect.getJoins().size() > 0) {
            List joins = plainSelect.getJoins();
            for (Join join : joins) {
                if (null == join.getRightItem()) continue;
                this.processFromItem(join.getRightItem(), level + 1);
            }
        }
    }

    protected void processFromItem(FromItem fromItem, int level) {
        SubSelect subSelect;
        LateralSubSelect lateralSubSelect;
        if (fromItem instanceof SubJoin) {
            SubJoin subJoin = (SubJoin)fromItem;
            if (null != subJoin.getJoinList() && subJoin.getJoinList().size() > 0) {
                for (Join join : subJoin.getJoinList()) {
                    if (null == join.getRightItem()) continue;
                    this.processFromItem(join.getRightItem(), level + 1);
                }
            }
            if (null != subJoin.getLeft()) {
                this.processFromItem(subJoin.getLeft(), level + 1);
            }
        } else if (fromItem instanceof SubSelect) {
            SubSelect subSelect2 = (SubSelect)fromItem;
            if (null != subSelect2.getSelectBody()) {
                this.processSelectBody(subSelect2.getSelectBody(), level + 1);
            }
        } else if (!(fromItem instanceof ValuesList) && fromItem instanceof LateralSubSelect && null != (lateralSubSelect = (LateralSubSelect)fromItem).getSubSelect() && null != (subSelect = lateralSubSelect.getSubSelect()).getSelectBody()) {
            this.processSelectBody(subSelect.getSelectBody(), level + 1);
        }
    }

    public boolean isNotEmptyList(List<?> list) {
        return list != null && list.size() != 0;
    }

    protected OrderByElement cloneOrderByElement(OrderByElement orig, String alias) {
        return this.cloneOrderByElement(orig, (Expression)new Column(alias));
    }

    protected OrderByElement cloneOrderByElement(OrderByElement orig, Expression expression) {
        OrderByElement element = new OrderByElement();
        element.setAsc(orig.isAsc());
        element.setAscDescPresent(orig.isAscDescPresent());
        element.setNullOrdering(orig.getNullOrdering());
        element.setExpression(expression);
        return element;
    }

    protected List<OrderByElement> getOrderByElements(PlainSelect plainSelect, List<SelectItem> autoItems) {
        Alias alias;
        List orderByElements = plainSelect.getOrderByElements();
        ListIterator<OrderByElement> iterator = orderByElements.listIterator();
        HashMap<String, SelectExpressionItem> selectMap = new HashMap<String, SelectExpressionItem>();
        HashSet<String> aliases = new HashSet<String>();
        boolean allColumns = false;
        HashSet<String> allColumnsTables = new HashSet<String>();
        for (SelectItem item : plainSelect.getSelectItems()) {
            if (item instanceof SelectExpressionItem) {
                SelectExpressionItem expItem = (SelectExpressionItem)item;
                selectMap.put(expItem.getExpression().toString(), expItem);
                alias = expItem.getAlias();
                if (null == alias) continue;
                aliases.add(alias.getName());
                continue;
            }
            if (item instanceof AllColumns) {
                allColumns = true;
                continue;
            }
            if (!(item instanceof AllTableColumns)) continue;
            allColumnsTables.add(((AllTableColumns)item).getTable().getName());
        }
        int aliasNo = 1;
        while (iterator.hasNext()) {
            OrderByElement orderByElement = (OrderByElement)iterator.next();
            Expression expression = orderByElement.getExpression();
            SelectExpressionItem selectExpressionItem = (SelectExpressionItem)selectMap.get(expression.toString());
            if (null != selectExpressionItem) {
                alias = selectExpressionItem.getAlias();
                if (null != alias) {
                    iterator.set(this.cloneOrderByElement(orderByElement, alias.getName()));
                    continue;
                }
                if (expression instanceof Column) {
                    ((Column)expression).setTable(null);
                    continue;
                }
                throw new PageException("\u5217 \"" + expression + "\" \u9700\u8981\u5b9a\u4e49\u522b\u540d");
            }
            if (expression instanceof Column) {
                Table table = ((Column)expression).getTable();
                if (table == null) {
                    if (allColumns || allColumnsTables.size() == 1 && plainSelect.getJoins() == null || aliases.contains(((Column)expression).getColumnName())) {
                        continue;
                    }
                } else {
                    String tableName = table.getName();
                    if (allColumns || allColumnsTables.contains(tableName)) {
                        ((Column)expression).setTable(null);
                        continue;
                    }
                }
            }
            String aliasName = PAGE_COLUMN_ALIAS_PREFIX + aliasNo++;
            SelectExpressionItem item = new SelectExpressionItem();
            item.setExpression(expression);
            item.setAlias(new Alias(aliasName));
            autoItems.add((SelectItem)item);
            iterator.set(this.cloneOrderByElement(orderByElement, aliasName));
        }
        return orderByElements;
    }

    static {
        TOP100_PERCENT.setExpression((Expression)new LongValue(100L));
        TOP100_PERCENT.setPercentage(true);
    }
}

