/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.socket.plugins;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.AsynchronousSocketChannel;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.socket.plugins.AbstractPlugin;

public class BlackListPlugin<T>
extends AbstractPlugin<T> {
    private final ConcurrentLinkedQueue<BlackListRule> ipBlackList = new ConcurrentLinkedQueue();

    @Override
    public AsynchronousSocketChannel shouldAccept(AsynchronousSocketChannel channel) {
        InetSocketAddress inetSocketAddress = null;
        try {
            inetSocketAddress = (InetSocketAddress)channel.getRemoteAddress();
        }
        catch (IOException e) {
            Logger.error("get remote address error.", e);
        }
        if (null == inetSocketAddress) {
            return channel;
        }
        for (BlackListRule rule : this.ipBlackList) {
            if (rule.access(inetSocketAddress)) continue;
            return null;
        }
        return channel;
    }

    public void addRule(BlackListRule rule) {
        this.ipBlackList.add(rule);
    }

    public void removeRule(BlackListRule rule) {
        this.ipBlackList.remove(rule);
    }

    public static interface BlackListRule {
        public boolean access(InetSocketAddress var1);
    }
}

