/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.tracer.binding.apache.cxf.interceptor;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBException;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.tracer.Backend;
import org.aoju.bus.tracer.Builder;
import org.aoju.bus.tracer.config.TraceFilterConfig;
import org.aoju.bus.tracer.transport.HttpHeaderTransport;
import org.aoju.bus.tracer.transport.jaxb.TpicMap;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.headers.Header;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.jaxb.JAXBDataBinding;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;

abstract class AbstractTraceOutInterceptor
extends AbstractPhaseInterceptor<Message> {
    protected final Backend backend;
    private final HttpHeaderTransport httpSerializer;
    private final TraceFilterConfig.Channel channel;
    private String profile;

    public AbstractTraceOutInterceptor(String phase, TraceFilterConfig.Channel channel, Backend backend, String profile) {
        super(phase);
        this.channel = channel;
        this.backend = backend;
        this.profile = profile;
        this.httpSerializer = new HttpHeaderTransport();
    }

    public void handleMessage(Message message) {
        if (this.shouldHandleMessage(message)) {
            TraceFilterConfig filterConfiguration = this.backend.getConfiguration(this.profile);
            if (!this.backend.isEmpty() && filterConfiguration.shouldProcessContext(this.channel)) {
                Map<String, String> filteredParams = filterConfiguration.filterDeniedParams(this.backend.copyToMap(), this.channel);
                Logger.debug("Interceptor handles message!", new Object[0]);
                if (Boolean.TRUE.equals(message.getExchange().get((Object)"org.apache.cxf.rest.message"))) {
                    HashMap<String, List<String>> responseHeaders = CastUtils.cast((Map)((Map)message.get((Object)Message.PROTOCOL_HEADERS)));
                    if (null == responseHeaders) {
                        responseHeaders = new HashMap<String, List<String>>();
                        message.put((Object)Message.PROTOCOL_HEADERS, responseHeaders);
                    }
                    String contextAsHeader = this.httpSerializer.render(filteredParams);
                    responseHeaders.put("TPIC", Collections.singletonList(contextAsHeader));
                } else {
                    try {
                        SoapMessage soapMessage = (SoapMessage)message;
                        this.addSoapHeader(filteredParams, soapMessage);
                    }
                    catch (NoClassDefFoundError e) {
                        Logger.error("Should handle SOAP-message but it seems that cxf soap dependency is not on the classpath. Unable to add Builder-Headers: {}", e.getMessage(), e);
                    }
                }
            }
        }
    }

    private void addSoapHeader(Map<String, String> filteredParams, SoapMessage soapMessage) {
        try {
            Header tpicHeader = new Header(Builder.SOAP_HEADER_QNAME, (Object)TpicMap.wrap(filteredParams), (DataBinding)new JAXBDataBinding(new Class[]{TpicMap.class}));
            soapMessage.getHeaders().add(tpicHeader);
        }
        catch (JAXBException e) {
            Logger.warn("Error occured during Builder soap header creation: {}", e.getMessage());
            Logger.debug("Detailed exception", new Object[]{e});
        }
    }

    protected abstract boolean shouldHandleMessage(Message var1);
}

