/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.tracer.transport.jaxb;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlValue;

@XmlRootElement(name="TPIC")
@XmlAccessorType(value=XmlAccessType.NONE)
public final class TpicMap {
    @XmlElement(name="entry")
    public final List<Entry> entries;

    public TpicMap(List<Entry> entries) {
        this.entries = entries;
    }

    private TpicMap() {
        this.entries = null;
    }

    public static TpicMap wrap(Map<String, String> map) {
        ArrayList<Entry> values = new ArrayList<Entry>();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            values.add(new Entry(entry.getKey(), entry.getValue()));
        }
        return new TpicMap(values);
    }

    public Map<String, String> unwrapValues() {
        if (null == this.entries) {
            return Collections.emptyMap();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (Entry value : this.entries) {
            map.put(value.key, value.value);
        }
        return map;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (null == o || this.getClass() != o.getClass()) {
            return false;
        }
        TpicMap tpicMap = (TpicMap)o;
        return !(null != this.entries ? !this.entries.equals(tpicMap.entries) : null != tpicMap.entries);
    }

    public int hashCode() {
        return null != this.entries ? this.entries.hashCode() : 0;
    }

    public static final class Entry {
        @XmlAttribute(name="key", required=true)
        public final String key;
        @XmlValue
        public final String value;

        public Entry(String key, String value) {
            this.key = key;
            this.value = value;
        }

        protected Entry() {
            this.key = null;
            this.value = null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (null == o || this.getClass() != o.getClass()) {
                return false;
            }
            Entry entry = (Entry)o;
            if (null != this.key ? !this.key.equals(entry.key) : null != entry.key) {
                return false;
            }
            return !(null != this.value ? !this.value.equals(entry.value) : null != entry.value);
        }

        public int hashCode() {
            int result = null != this.key ? this.key.hashCode() : 0;
            result = 31 * result + (null != this.value ? this.value.hashCode() : 0);
            return result;
        }
    }
}

