/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.compress;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.function.Consumer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.toolkit.FileKit;
import org.aoju.bus.core.toolkit.IoKit;
import org.aoju.bus.core.toolkit.ZipKit;

public class ZipReader
implements Closeable {
    private ZipFile zipFile;
    private ZipInputStream in;

    public ZipReader(File zipFile, Charset charset) {
        this.zipFile = ZipKit.zipFile(zipFile, charset);
    }

    public ZipReader(ZipFile zipFile) {
        this.zipFile = zipFile;
    }

    public ZipReader(InputStream in, Charset charset) {
        this.in = new ZipInputStream(in, charset);
    }

    public ZipReader(ZipInputStream zin) {
        this.in = zin;
    }

    public static ZipReader of(File zipFile, Charset charset) {
        return new ZipReader(zipFile, charset);
    }

    public static ZipReader of(InputStream in, Charset charset) {
        return new ZipReader(in, charset);
    }

    public InputStream get(String path) {
        if (null != this.zipFile) {
            ZipFile zipFile = this.zipFile;
            ZipEntry entry = zipFile.getEntry(path);
            if (null != entry) {
                return ZipKit.get(zipFile, entry);
            }
        } else {
            throw new UnsupportedOperationException("Zip stream mode not support get!");
        }
        return null;
    }

    public File readTo(File outFile) throws InstrumentException {
        this.read(zipEntry -> {
            File outItemFile = FileKit.file(outFile, zipEntry.getName());
            if (zipEntry.isDirectory()) {
                outItemFile.mkdirs();
            } else {
                InputStream in = null != this.zipFile ? ZipKit.get(this.zipFile, zipEntry) : this.in;
                FileKit.writeFromStream(in, outItemFile, false);
            }
        });
        return outFile;
    }

    public ZipReader read(Consumer<ZipEntry> consumer) throws InstrumentException {
        if (null != this.zipFile) {
            this.readFromZipFile(consumer);
        } else {
            this.readFromStream(consumer);
        }
        return this;
    }

    @Override
    public void close() throws InstrumentException {
        if (null != this.zipFile) {
            IoKit.close(this.zipFile);
        } else {
            IoKit.close(this.in);
        }
    }

    private void readFromZipFile(Consumer<ZipEntry> consumer) {
        Enumeration<? extends ZipEntry> em = this.zipFile.entries();
        while (em.hasMoreElements()) {
            consumer.accept(em.nextElement());
        }
    }

    private void readFromStream(Consumer<ZipEntry> consumer) throws InstrumentException {
        try {
            ZipEntry zipEntry;
            while (null != (zipEntry = this.in.getNextEntry())) {
                consumer.accept(zipEntry);
            }
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
    }
}

