/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.convert;

import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.lang.Normal;
import org.aoju.bus.core.toolkit.ArrayKit;
import org.aoju.bus.core.toolkit.MathKit;
import org.aoju.bus.core.toolkit.ObjectKit;
import org.aoju.bus.core.toolkit.StringKit;

public class NumberFormatter {
    private static final char[] CHINESE_DIGITS_VALUE = new char[]{'\u96f6', '\u4e00', '\u58f9', '\u4e8c', '\u8d30', '\u4e09', '\u53c1', '\u56db', '\u8086', '\u4e94', '\u4f0d', '\u516d', '\u9646', '\u4e03', '\u67d2', '\u516b', '\u634c', '\u4e5d', '\u7396'};
    private static final NameValue[] CHINESE_NAME_VALUE = new NameValue[]{new NameValue(' ', 1, false), new NameValue('\u5341', 10, false), new NameValue('\u62fe', 10, false), new NameValue('\u767e', 100, false), new NameValue('\u4f70', 100, false), new NameValue('\u5343', 1000, false), new NameValue('\u4edf', 1000, false), new NameValue('\u4e07', 10000, true), new NameValue('\u4ebf', 100000000, true)};

    public static String format(int amount, boolean isUseTraditional) {
        Assert.checkBetween(amount, -999, 999, "Number support only: (-999 ~ 999)\uff01", new Object[0]);
        String chinese = NumberFormatter.toChinese(amount, isUseTraditional);
        if (amount < 20 && amount > 10) {
            return chinese.substring(1);
        }
        return chinese;
    }

    public static String format(long amount, boolean isUseTraditional) {
        if (0L == amount) {
            return "\u96f6";
        }
        Assert.checkBetween((double)amount, -9.999999999999998E13, 9.999999999999998E13, "Number support only: (-99999999999999.99 ~ 99999999999999.99)\uff01", new Object[0]);
        StringBuilder chineseStr = new StringBuilder();
        if (amount < 0L) {
            chineseStr.append("\u8d1f");
            amount = -amount;
        }
        chineseStr.append(NumberFormatter.toChinese(amount, isUseTraditional));
        return chineseStr.toString();
    }

    public static String format(double amount, boolean isUseTraditional) {
        return NumberFormatter.format(amount, isUseTraditional, false);
    }

    public static String format(double amount, boolean isUseTraditional, boolean isMoneyMode) {
        if (0.0 == amount) {
            return "\u96f6";
        }
        Assert.checkBetween(amount, -9.999999999999998E13, 9.999999999999998E13, "Number support only: (-99999999999999.99 ~ 99999999999999.99)\uff01", new Object[0]);
        StringBuilder chineseStr = new StringBuilder();
        if (amount < 0.0) {
            chineseStr.append("\u8d1f");
            amount = -amount;
        }
        long yuan = Math.round(amount * 100.0);
        int fen = (int)(yuan % 10L);
        int jiao = (int)((yuan /= 10L) % 10L);
        if (!isMoneyMode || 0L != (yuan /= 10L)) {
            chineseStr.append(NumberFormatter.toChinese(yuan, isUseTraditional));
            if (isMoneyMode) {
                chineseStr.append("\u5143");
            }
        }
        if (0 == jiao && 0 == fen) {
            if (isMoneyMode) {
                chineseStr.append("\u6574");
            }
            return chineseStr.toString();
        }
        if (!isMoneyMode) {
            chineseStr.append("\u70b9");
        }
        if (0L == yuan && 0 == jiao) {
            if (!isMoneyMode) {
                chineseStr.append("\u96f6");
            }
        } else {
            chineseStr.append(NumberFormatter.numberToChinese(jiao, isUseTraditional));
            if (isMoneyMode && 0 != jiao) {
                chineseStr.append("\u89d2");
            }
        }
        if (0 != fen) {
            chineseStr.append(NumberFormatter.numberToChinese(fen, isUseTraditional));
            if (isMoneyMode) {
                chineseStr.append("\u5206");
            }
        }
        return chineseStr.toString();
    }

    public static String toChinese(char c, boolean isUseTraditional) {
        if (c < '0' || c > '9') {
            return String.valueOf(c);
        }
        return String.valueOf(NumberFormatter.numberToChinese(c - 48, isUseTraditional));
    }

    private static String toChinese(long amount, boolean isUseTraditional) {
        String partChinese;
        if (0L == amount) {
            return "\u96f6";
        }
        int[] parts = new int[4];
        int i = 0;
        while (amount != 0L) {
            parts[i] = (int)(amount % 10000L);
            amount /= 10000L;
            ++i;
        }
        StringBuilder chineseStr = new StringBuilder();
        int partValue = parts[0];
        if (partValue > 0) {
            partChinese = NumberFormatter.toChinese(partValue, isUseTraditional);
            chineseStr.insert(0, partChinese);
            if (partValue < 1000) {
                NumberFormatter.addPreZero(chineseStr);
            }
        }
        if ((partValue = parts[1]) > 0) {
            if (partValue % 10 == 0 && parts[0] > 0) {
                NumberFormatter.addPreZero(chineseStr);
            }
            partChinese = NumberFormatter.toChinese(partValue, isUseTraditional);
            chineseStr.insert(0, partChinese + "\u4e07");
            if (partValue < 1000) {
                NumberFormatter.addPreZero(chineseStr);
            }
        } else {
            NumberFormatter.addPreZero(chineseStr);
        }
        if ((partValue = parts[2]) > 0) {
            if (partValue % 10 == 0 && parts[1] > 0) {
                NumberFormatter.addPreZero(chineseStr);
            }
            partChinese = NumberFormatter.toChinese(partValue, isUseTraditional);
            chineseStr.insert(0, partChinese + "\u4ebf");
            if (partValue < 1000) {
                NumberFormatter.addPreZero(chineseStr);
            }
        } else {
            NumberFormatter.addPreZero(chineseStr);
        }
        if ((partValue = parts[3]) > 0) {
            if (parts[2] == 0) {
                chineseStr.insert(0, "\u4ebf");
            }
            partChinese = NumberFormatter.toChinese(partValue, isUseTraditional);
            chineseStr.insert(0, partChinese + "\u4e07");
        }
        if (StringKit.isNotEmpty(chineseStr) && '\u96f6' == chineseStr.charAt(0)) {
            return chineseStr.substring(1);
        }
        return chineseStr.toString();
    }

    private static String toChinese(int amountPart, boolean isUseTraditional) {
        int temp = amountPart;
        StringBuilder chineseStr = new StringBuilder();
        boolean lastIsZero = true;
        int i = 0;
        while (temp > 0) {
            int digit = temp % 10;
            if (digit == 0) {
                if (!lastIsZero) {
                    chineseStr.insert(0, "\u96f6");
                }
                lastIsZero = true;
            } else {
                chineseStr.insert(0, NumberFormatter.numberToChinese(digit, isUseTraditional) + NumberFormatter.getUnitName(i, isUseTraditional));
                lastIsZero = false;
            }
            temp /= 10;
            ++i;
        }
        return chineseStr.toString();
    }

    public static int chineseToNumber(String chinese) {
        int length = chinese.length();
        int result = 0;
        int section = 0;
        int number = 0;
        NameValue unit = null;
        for (int i = 0; i < length; ++i) {
            char c = chinese.charAt(i);
            int num = NumberFormatter.chineseToNumber(c);
            if (num >= 0) {
                if (num == 0) {
                    if (number > 0 && null != unit) {
                        section += number * (unit.value / 10);
                    }
                    unit = null;
                } else if (number > 0) {
                    throw new IllegalArgumentException(StringKit.format((CharSequence)"Bad number '{}{}' at: {}", Character.valueOf(chinese.charAt(i - 1)), Character.valueOf(c), i));
                }
                number = num;
                continue;
            }
            unit = NumberFormatter.chineseToUnit(c);
            if (null == unit) {
                throw new IllegalArgumentException(StringKit.format((CharSequence)"Unknown unit '{}' at: {}", Character.valueOf(c), i));
            }
            if (unit.unit) {
                section = (section + number) * unit.value;
                result += section;
                section = 0;
            } else {
                int unitNumber = number;
                if (0 == number && 0 == i) {
                    unitNumber = 1;
                }
                section += unitNumber * unit.value;
            }
            number = 0;
        }
        if (number > 0 && null != unit) {
            number *= unit.value / 10;
        }
        return result + section + number;
    }

    private static NameValue chineseToUnit(char chinese) {
        for (NameValue chineseNameValue : CHINESE_NAME_VALUE) {
            if (chineseNameValue.name != chinese) continue;
            return chineseNameValue;
        }
        return null;
    }

    private static int chineseToNumber(char chinese) {
        int i;
        if ('\u4e24' == chinese) {
            chinese = (char)20108;
        }
        if ((i = ArrayKit.indexOf(CHINESE_DIGITS_VALUE, chinese)) > 0) {
            return (i + 1) / 2;
        }
        return i;
    }

    private static char numberToChinese(int number, boolean isUseTraditional) {
        if (0 == number) {
            return CHINESE_DIGITS_VALUE[0];
        }
        return CHINESE_DIGITS_VALUE[number * 2 - (isUseTraditional ? 0 : 1)];
    }

    private static String getUnitName(int index, boolean isUseTraditional) {
        if (0 == index) {
            return "";
        }
        return String.valueOf(CHINESE_NAME_VALUE[index * 2 - (isUseTraditional ? 0 : 1)].name);
    }

    private static void addPreZero(StringBuilder chineseStr) {
        if (StringKit.isEmpty(chineseStr)) {
            return;
        }
        char c = chineseStr.charAt(0);
        if ('\u96f6' != c) {
            chineseStr.insert(0, '\u96f6');
        }
    }

    public static String format(Object x) {
        if (null != x) {
            return NumberFormatter.format(x.toString());
        }
        return "";
    }

    private static String format(String x) {
        String lstr;
        int z = x.indexOf(".");
        String rstr = "";
        if (z > -1) {
            lstr = x.substring(0, z);
            rstr = x.substring(z + 1);
        } else {
            lstr = x;
        }
        String lstrrev = StringKit.reverse(lstr);
        String[] a = new String[5];
        switch (lstrrev.length() % 3) {
            case 1: {
                lstrrev = lstrrev + "00";
                break;
            }
            case 2: {
                lstrrev = lstrrev + "0";
            }
        }
        String lm = "";
        for (int i = 0; i < lstrrev.length() / 3; ++i) {
            a[i] = StringKit.reverse(lstrrev.substring(3 * i, 3 * i + 3));
            if (!ObjectKit.equal(a[i], "000")) {
                if (i != 0) {
                    lm = NumberFormatter.transThree(a[i]) + " " + NumberFormatter.parseMore(String.valueOf(i)) + " " + lm;
                    continue;
                }
                lm = NumberFormatter.transThree(a[i]);
                continue;
            }
            lm = lm + NumberFormatter.transThree(a[i]);
        }
        String xs = "";
        if (z > -1) {
            xs = "AND CENTS " + NumberFormatter.transTwo(rstr) + " ";
        }
        return lm.trim() + " " + xs + "ONLY";
    }

    public static String formatSimple(long value) {
        return NumberFormatter.formatSimple(value, true);
    }

    public static String formatSimple(long value, boolean isTwo) {
        if (value < 1000L) {
            return String.valueOf(value);
        }
        int index = -1;
        double res = value;
        while (res > 10.0 && (!isTwo || index < 1)) {
            if (res > 1000.0) {
                res /= 1000.0;
                ++index;
            }
            if (!(res > 10.0)) continue;
            res /= 10.0;
            ++index;
        }
        return String.format("%s%s", MathKit.decimalFormat("#.##", res), Normal.NUMBER_SUFFIX[index]);
    }

    private static String parseFirst(String s) {
        return Normal.EN_NUMBER[Integer.parseInt(s.substring(s.length() - 1))];
    }

    private static String parseTeen(String s) {
        return Normal.NUMBER_TEEN[Integer.parseInt(s) - 10];
    }

    private static String parseTen(String s) {
        return Normal.NUMBER_TEN[Integer.parseInt(s.substring(0, 1)) - 1];
    }

    private static String parseMore(String s) {
        return Normal.NUMBER_MORE[Integer.parseInt(s)];
    }

    private static String transTwo(String text) {
        if (text.length() > 2) {
            text = text.substring(0, 2);
        } else if (text.length() < 2) {
            text = "0" + text;
        }
        String value = text.startsWith("0") ? NumberFormatter.parseFirst(text) : (text.startsWith("1") ? NumberFormatter.parseTeen(text) : (text.endsWith("0") ? NumberFormatter.parseTen(text) : NumberFormatter.parseTen(text) + " " + NumberFormatter.parseFirst(text)));
        return value;
    }

    private static String transThree(String text) {
        String value = text.startsWith("0") ? NumberFormatter.transTwo(text.substring(1)) : (ObjectKit.equal(text.substring(1), "00") ? NumberFormatter.parseFirst(text.substring(0, 1)) + " HUNDRED" : NumberFormatter.parseFirst(text.substring(0, 1)) + " HUNDRED AND " + NumberFormatter.transTwo(text.substring(1)));
        return value;
    }

    private static class NameValue {
        private final char name;
        private final int value;
        private final boolean unit;

        public NameValue(char name, int value, boolean unit) {
            this.name = name;
            this.value = value;
            this.unit = unit;
        }
    }
}

