/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.io.watchers;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.attribute.FileAttribute;
import org.aoju.bus.core.io.watchers.WatchServer;
import org.aoju.bus.core.io.watchers.Watcher;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.toolkit.FileKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.core.toolkit.UriKit;

public class WatchMonitor
extends WatchServer {
    public static final WatchEvent.Kind<?> OVERFLOW = StandardWatchEventKinds.OVERFLOW;
    public static final WatchEvent.Kind<?> ENTRY_MODIFY = StandardWatchEventKinds.ENTRY_MODIFY;
    public static final WatchEvent.Kind<?> ENTRY_CREATE = StandardWatchEventKinds.ENTRY_CREATE;
    public static final WatchEvent.Kind<?> ENTRY_DELETE = StandardWatchEventKinds.ENTRY_DELETE;
    public static final WatchEvent.Kind<?>[] EVENTS_ALL = new WatchEvent.Kind[]{OVERFLOW, ENTRY_MODIFY, ENTRY_CREATE, ENTRY_DELETE};
    private static final long serialVersionUID = 1L;
    private Path path;
    private int maxDepth;
    private Path filePath;
    private Watcher watcher;

    public WatchMonitor(File file, WatchEvent.Kind<?> ... events) {
        this(file.toPath(), events);
    }

    public WatchMonitor(String path, WatchEvent.Kind<?> ... events) {
        this(Paths.get(path, new String[0]), events);
    }

    public WatchMonitor(Path path, WatchEvent.Kind<?> ... events) {
        this(path, 0, events);
    }

    public WatchMonitor(Path path, int maxDepth, WatchEvent.Kind<?> ... events) {
        this.path = path;
        this.maxDepth = maxDepth;
        this.events = events;
        this.init();
    }

    public static WatchMonitor create(URL url, WatchEvent.Kind<?> ... events) {
        return WatchMonitor.create(url, 0, events);
    }

    public static WatchMonitor create(URL url, int maxDepth, WatchEvent.Kind<?> ... events) {
        return WatchMonitor.create(UriKit.toURI(url), maxDepth, events);
    }

    public static WatchMonitor create(URI uri, WatchEvent.Kind<?> ... events) {
        return WatchMonitor.create(uri, 0, events);
    }

    public static WatchMonitor create(URI uri, int maxDepth, WatchEvent.Kind<?> ... events) {
        return WatchMonitor.create(Paths.get(uri), maxDepth, events);
    }

    public static WatchMonitor create(File file, WatchEvent.Kind<?> ... events) {
        return WatchMonitor.create(file, 0, events);
    }

    public static WatchMonitor create(File file, int maxDepth, WatchEvent.Kind<?> ... events) {
        return WatchMonitor.create(file.toPath(), maxDepth, events);
    }

    public static WatchMonitor create(String path, WatchEvent.Kind<?> ... events) {
        return WatchMonitor.create(path, 0, events);
    }

    public static WatchMonitor create(String path, int maxDepth, WatchEvent.Kind<?> ... events) {
        return WatchMonitor.create(Paths.get(path, new String[0]), maxDepth, events);
    }

    public static WatchMonitor create(Path path, WatchEvent.Kind<?> ... events) {
        return WatchMonitor.create(path, 0, events);
    }

    public static WatchMonitor create(Path path, int maxDepth, WatchEvent.Kind<?> ... events) {
        return new WatchMonitor(path, maxDepth, events);
    }

    public static WatchMonitor createAll(URI uri, Watcher watcher) {
        return WatchMonitor.createAll(Paths.get(uri), watcher);
    }

    public static WatchMonitor createAll(URL url, Watcher watcher) {
        try {
            return WatchMonitor.createAll(Paths.get(url.toURI()), watcher);
        }
        catch (URISyntaxException e) {
            throw new InstrumentException(e);
        }
    }

    public static WatchMonitor createAll(File file, Watcher watcher) {
        return WatchMonitor.createAll(file.toPath(), watcher);
    }

    public static WatchMonitor createAll(String path, Watcher watcher) {
        return WatchMonitor.createAll(Paths.get(path, new String[0]), watcher);
    }

    public static WatchMonitor createAll(Path path, Watcher watcher) {
        WatchMonitor watchMonitor = WatchMonitor.create(path, EVENTS_ALL);
        watchMonitor.setWatcher(watcher);
        return watchMonitor;
    }

    @Override
    public void init() throws InstrumentException {
        if (!Files.exists(this.path, LinkOption.NOFOLLOW_LINKS)) {
            String lastPathEleStr;
            Path lastPathEle = FileKit.getLastPathEle(this.path);
            if (null != lastPathEle && StringKit.contains((CharSequence)(lastPathEleStr = lastPathEle.toString()), '.') && !StringKit.endWithIgnoreCase(lastPathEleStr, ".d")) {
                this.filePath = this.path;
                this.path = this.filePath.getParent();
            }
            try {
                Files.createDirectories(this.path, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new InstrumentException(e);
            }
        } else if (Files.isRegularFile(this.path, LinkOption.NOFOLLOW_LINKS)) {
            this.filePath = this.path;
            this.path = this.filePath.getParent();
        }
        super.init();
    }

    public WatchMonitor setWatcher(Watcher watcher) {
        this.watcher = watcher;
        return this;
    }

    @Override
    public void run() {
        this.watch();
    }

    public void watch() {
        this.watch(this.watcher);
    }

    public void watch(Watcher watcher) throws InstrumentException {
        if (this.isClosed) {
            throw new InstrumentException("Watch Monitor is closed !");
        }
        this.registerPath();
        while (!this.isClosed) {
            this.doTakeAndWatch(watcher);
        }
    }

    public WatchMonitor setMaxDepth(int maxDepth) {
        this.maxDepth = maxDepth;
        return this;
    }

    private void doTakeAndWatch(Watcher watcher) {
        super.watch(watcher, watchEvent -> null == this.filePath || this.filePath.endsWith(watchEvent.context().toString()));
    }

    private void registerPath() {
        this.registerPath(this.path, null != this.filePath ? 0 : this.maxDepth);
    }
}

