/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.loader;

import java.security.SecureClassLoader;
import java.util.HashMap;
import java.util.Map;
import org.aoju.bus.core.io.resource.Resource;
import org.aoju.bus.core.toolkit.ClassKit;
import org.aoju.bus.core.toolkit.ObjectKit;

public class ClazzLoader<T extends Resource>
extends SecureClassLoader {
    private final Map<String, T> resourceMap;
    private final Map<String, Class<?>> cacheClassMap;

    public ClazzLoader(ClassLoader parentClassLoader, Map<String, T> resourceMap) {
        super(ObjectKit.defaultIfNull(parentClassLoader, ClassKit.getClassLoader()));
        this.resourceMap = ObjectKit.defaultIfNull(resourceMap, new HashMap());
        this.cacheClassMap = new HashMap();
    }

    public ClazzLoader<T> addResource(T resource) {
        this.resourceMap.put(resource.getName(), resource);
        return this;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Class clazz = this.cacheClassMap.computeIfAbsent(name, this::defineByName);
        if (clazz == null) {
            return super.findClass(name);
        }
        return clazz;
    }

    private Class<?> defineByName(String name) {
        Resource resource = (Resource)this.resourceMap.get(name);
        if (null != resource) {
            byte[] bytes = resource.readBytes();
            return this.defineClass(name, bytes, 0, bytes.length);
        }
        return null;
    }
}

