/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.text;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.aoju.bus.core.collection.ComputeIterator;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.text.finder.TextFinder;
import org.aoju.bus.core.toolkit.StringKit;

public class SplitIterator
extends ComputeIterator<String>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String text;
    private final TextFinder finder;
    private final int limit;
    private final boolean ignoreEmpty;
    private int offset;
    private int count;

    public SplitIterator(CharSequence text, TextFinder separatorFinder, int limit, boolean ignoreEmpty) {
        Assert.notNull(text, "Text must be not null!", new Object[0]);
        this.text = text.toString();
        this.finder = separatorFinder.setText(text);
        this.limit = limit > 0 ? limit : Integer.MAX_VALUE;
        this.ignoreEmpty = ignoreEmpty;
    }

    @Override
    protected String computeNext() {
        if (this.count >= this.limit || this.offset > this.text.length()) {
            return null;
        }
        if (this.count == this.limit - 1) {
            if (this.ignoreEmpty && this.offset == this.text.length()) {
                return null;
            }
            ++this.count;
            return this.text.substring(this.offset);
        }
        int start = this.finder.start(this.offset);
        if (start < 0) {
            if (this.offset <= this.text.length()) {
                String result = this.text.substring(this.offset);
                if (!this.ignoreEmpty || !result.isEmpty()) {
                    this.offset = Integer.MAX_VALUE;
                    return result;
                }
            }
            return null;
        }
        int end = this.finder.end(start);
        String result = this.text.substring(this.offset, start);
        this.offset = end;
        if (this.ignoreEmpty && result.isEmpty()) {
            return this.computeNext();
        }
        ++this.count;
        return result;
    }

    public void reset() {
        this.finder.reset();
        this.offset = 0;
        this.count = 0;
    }

    public String[] toArray(boolean trim) {
        return this.toList(trim).toArray(new String[0]);
    }

    public List<String> toList(boolean trim) {
        return this.toList(text -> trim ? StringKit.trim(text) : text);
    }

    public <T> List<T> toList(Function<String, T> mapping) {
        ArrayList<T> result = new ArrayList<T>();
        while (this.hasNext()) {
            T apply = mapping.apply((String)this.next());
            if (this.ignoreEmpty && StringKit.emptyIfString(apply)) continue;
            result.add(apply);
        }
        if (result.isEmpty()) {
            return new ArrayList(0);
        }
        return result;
    }
}

