/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.text;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.lang.Normal;
import org.aoju.bus.core.text.SplitIterator;
import org.aoju.bus.core.text.finder.CharFinder;
import org.aoju.bus.core.text.finder.LengthFinder;
import org.aoju.bus.core.text.finder.MatcherFinder;
import org.aoju.bus.core.text.finder.PatternFinder;
import org.aoju.bus.core.text.finder.StringFinder;
import org.aoju.bus.core.toolkit.ArrayKit;
import org.aoju.bus.core.toolkit.CharsKit;
import org.aoju.bus.core.toolkit.PatternKit;
import org.aoju.bus.core.toolkit.StringKit;

public class TextSplitter {
    public static List<String> split(CharSequence text, int limit) {
        if (StringKit.isEmpty(text)) {
            return new ArrayList<String>(0);
        }
        SplitIterator SplitIterator2 = new SplitIterator(text, new MatcherFinder(CharsKit::isBlankChar), limit, true);
        return SplitIterator2.toList(false);
    }

    public static List<String> split(CharSequence text, char separator, boolean isTrim, boolean ignoreEmpty) {
        return TextSplitter.split(text, separator, 0, isTrim, ignoreEmpty);
    }

    public static List<String> split(CharSequence text, String separator, boolean isTrim, boolean ignoreEmpty) {
        return TextSplitter.split(text, separator, -1, isTrim, ignoreEmpty, false);
    }

    public static List<String> split(CharSequence text, char separator, int limit, boolean isTrim, boolean ignoreEmpty) {
        return TextSplitter.split(text, separator, limit, isTrim, ignoreEmpty, false);
    }

    public static List<String> split(String text, Pattern separator, int limit, boolean isTrim, boolean ignoreEmpty) {
        Assert.notNull(text, "Text must be not null!", new Object[0]);
        if (text.length() < 1) {
            return new ArrayList<String>(0);
        }
        SplitIterator SplitIterator2 = new SplitIterator(text, new PatternFinder(separator), limit, ignoreEmpty);
        return SplitIterator2.toList(isTrim);
    }

    public static List<String> split(CharSequence text, String separator, int limit, boolean isTrim, boolean ignoreEmpty) {
        return TextSplitter.split(text, separator, limit, isTrim, ignoreEmpty, false);
    }

    public static <R> List<R> split(CharSequence text, char separator, int limit, boolean ignoreEmpty, Function<String, R> mapping) {
        return TextSplitter.split(text, separator, limit, ignoreEmpty, false, mapping);
    }

    public static List<String> split(CharSequence text, char separator, int limit, boolean isTrim, boolean ignoreEmpty, boolean ignoreCase) {
        return TextSplitter.split(text, separator, limit, ignoreEmpty, ignoreCase, TextSplitter.trimFunc(isTrim));
    }

    public static <R> List<R> split(CharSequence text, char separator, int limit, boolean ignoreEmpty, boolean ignoreCase, Function<String, R> mapping) {
        SplitIterator SplitIterator2 = new SplitIterator(text, new CharFinder(separator, ignoreCase), limit, ignoreEmpty);
        return SplitIterator2.toList(mapping);
    }

    public static List<String> split(CharSequence text, String separator, int limit, boolean isTrim, boolean ignoreEmpty, boolean ignoreCase) {
        SplitIterator SplitIterator2 = new SplitIterator(text, new StringFinder(separator, ignoreCase), limit, ignoreEmpty);
        return SplitIterator2.toList(isTrim);
    }

    public static List<String> splitTrim(CharSequence text, String separator, boolean ignoreEmpty) {
        return TextSplitter.split(text, separator, true, ignoreEmpty);
    }

    public static List<String> splitTrim(CharSequence text, char separator, boolean ignoreEmpty) {
        return TextSplitter.split(text, separator, 0, true, ignoreEmpty);
    }

    public static List<String> splitTrim(CharSequence text, String separator, int limit, boolean ignoreEmpty) {
        return TextSplitter.split(text, separator, limit, true, ignoreEmpty);
    }

    public static List<String> splitTrim(CharSequence text, char separator, int limit, boolean ignoreEmpty) {
        return TextSplitter.split(text, separator, limit, true, ignoreEmpty, false);
    }

    public static String[] splitToArray(String text, String separator) {
        return TextSplitter.splitToArray(text, separator, true, true);
    }

    public static String[] splitToArray(String text, String separator, boolean isTrim, boolean ignoreEmpty) {
        if (text == null) {
            return Normal.EMPTY_STRING_ARRAY;
        }
        StringTokenizer st = new StringTokenizer(text, separator);
        ArrayList<String> tokens = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (isTrim) {
                token = token.trim();
            }
            if (ignoreEmpty && token.length() <= 0) continue;
            tokens.add(token);
        }
        return ArrayKit.toArray(tokens);
    }

    public static String[] splitToArray(CharSequence text, String separator, int limit, boolean isTrim, boolean ignoreEmpty) {
        return ArrayKit.toArray(TextSplitter.split(text, separator, limit, isTrim, ignoreEmpty));
    }

    public static String[] splitToArray(CharSequence text, char separator, int limit, boolean isTrim, boolean ignoreEmpty) {
        return ArrayKit.toArray(TextSplitter.split(text, separator, limit, isTrim, ignoreEmpty));
    }

    public static String[] splitToArray(String text, int limit) {
        return ArrayKit.toArray(TextSplitter.split(text, limit));
    }

    public static String[] splitToArray(String text, Pattern separatorPattern, int limit, boolean isTrim, boolean ignoreEmpty) {
        return ArrayKit.toArray(TextSplitter.split(text, separatorPattern, limit, isTrim, ignoreEmpty));
    }

    public static List<String> splitIgnoreCase(CharSequence text, char separator, int limit, boolean isTrim, boolean ignoreEmpty) {
        return TextSplitter.split(text, separator, limit, isTrim, ignoreEmpty, true);
    }

    public static List<String> splitIgnoreCase(CharSequence text, String separator, int limit, boolean isTrim, boolean ignoreEmpty) {
        return TextSplitter.split(text, separator, limit, isTrim, ignoreEmpty, true);
    }

    public static List<String> splitTrimIgnoreCase(CharSequence text, String separator, int limit, boolean ignoreEmpty) {
        return TextSplitter.split(text, separator, limit, true, ignoreEmpty, true);
    }

    public static List<String> splitPath(CharSequence text) {
        return TextSplitter.splitPath(text, 0);
    }

    public static List<String> splitPath(CharSequence text, int limit) {
        return TextSplitter.split(text, '/', limit, true, true);
    }

    public static String[] splitPathToArray(CharSequence text) {
        return ArrayKit.toArray(TextSplitter.splitPath(text));
    }

    public static String[] splitPathToArray(CharSequence text, int limit) {
        return ArrayKit.toArray(TextSplitter.splitPath(text, limit));
    }

    public static String[] splitByLength(String text, int len) {
        SplitIterator SplitIterator2 = new SplitIterator(text, new LengthFinder(len), -1, false);
        return SplitIterator2.toArray(false);
    }

    public static List<String> splitByRegex(String text, String separatorRegex, int limit, boolean isTrim, boolean ignoreEmpty) {
        Pattern pattern = PatternKit.get(separatorRegex);
        return TextSplitter.split(text, pattern, limit, isTrim, ignoreEmpty);
    }

    public static Function<String, String> trimFunc(boolean isTrim) {
        return text -> isTrim ? StringKit.trim(text) : text;
    }
}

