/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.text.finder;

import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.lang.Matcher;
import org.aoju.bus.core.text.finder.TextFinder;

public class MatcherFinder
extends TextFinder {
    private static final long serialVersionUID = 1L;
    private final Matcher<Character> matcher;

    public MatcherFinder(Matcher<Character> matcher) {
        this.matcher = matcher;
    }

    @Override
    public int start(int from) {
        Assert.notNull(this.text, "Text to find must be not null!", new Object[0]);
        int limit = this.getValidEndIndex();
        if (this.negative) {
            for (int i = from; i > limit; --i) {
                if (!this.matcher.match(Character.valueOf(this.text.charAt(i)))) continue;
                return i;
            }
        } else {
            for (int i = from; i < limit; ++i) {
                if (!this.matcher.match(Character.valueOf(this.text.charAt(i)))) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public int end(int start) {
        if (start < 0) {
            return -1;
        }
        return start + 1;
    }
}

