/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.toolkit;

import java.lang.annotation.Annotation;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import org.aoju.bus.core.annotation.Element;
import org.aoju.bus.core.toolkit.ArrayKit;
import org.aoju.bus.core.toolkit.ReflectKit;

public class AnnoKit {
    public static Element toCombination(AnnotatedElement annotationEle) {
        if (annotationEle instanceof Element) {
            return (Element)annotationEle;
        }
        return new Element(annotationEle);
    }

    public static Annotation[] getAnnotations(AnnotatedElement annotationEle, boolean isCombination) {
        return null == annotationEle ? null : (isCombination ? AnnoKit.toCombination(annotationEle) : annotationEle).getAnnotations();
    }

    public static <A extends Annotation> A getAnnotation(AnnotatedElement annotationEle, Class<A> annotationType) {
        return null == annotationEle ? null : (A)AnnoKit.toCombination(annotationEle).getAnnotation(annotationType);
    }

    public static boolean hasAnnotation(AnnotatedElement annotationEle, Class<? extends Annotation> annotationType) {
        return null != AnnoKit.getAnnotation(annotationEle, annotationType);
    }

    public static <T> T getAnnotationValue(AnnotatedElement annotationEle, Class<? extends Annotation> annotationType) {
        return AnnoKit.getAnnotationValue(annotationEle, annotationType, "value");
    }

    public static <T> T getAnnotationValue(AnnotatedElement annotationEle, Class<? extends Annotation> annotationType, String propertyName) {
        Annotation annotation = AnnoKit.getAnnotation(annotationEle, annotationType);
        if (null == annotation) {
            return null;
        }
        Method method = ReflectKit.getMethodOfObj(annotation, propertyName, new Object[0]);
        if (null == method) {
            return null;
        }
        return ReflectKit.invoke((Object)annotation, method, new Object[0]);
    }

    public static Map<String, Object> getAnnotationValueMap(AnnotatedElement annotationEle, Class<? extends Annotation> annotationType) {
        Annotation annotation = AnnoKit.getAnnotation(annotationEle, annotationType);
        if (null == annotation) {
            return null;
        }
        Method[] methods = ReflectKit.getMethods(annotationType, t -> {
            if (ArrayKit.isEmpty(t.getParameterTypes())) {
                String name = t.getName();
                return false == "hashCode".equals(name) && false == "toString".equals(name) && false == "annotationType".equals(name);
            }
            return false;
        });
        HashMap<String, Object> result = new HashMap<String, Object>(methods.length, 1.0f);
        for (Method method : methods) {
            result.put(method.getName(), ReflectKit.invoke((Object)annotation, method, new Object[0]));
        }
        return result;
    }

    public static RetentionPolicy getRetentionPolicy(Class<? extends Annotation> annotationType) {
        Retention retention = annotationType.getAnnotation(Retention.class);
        if (null == retention) {
            return RetentionPolicy.CLASS;
        }
        return retention.value();
    }

    public static ElementType[] getTargetType(Class<? extends Annotation> annotationType) {
        Target target = annotationType.getAnnotation(Target.class);
        if (null == target) {
            return new ElementType[]{ElementType.TYPE, ElementType.FIELD, ElementType.METHOD, ElementType.PARAMETER, ElementType.CONSTRUCTOR, ElementType.LOCAL_VARIABLE, ElementType.ANNOTATION_TYPE, ElementType.PACKAGE};
        }
        return target.value();
    }

    public static boolean isDocumented(Class<? extends Annotation> annotationType) {
        return annotationType.isAnnotationPresent(Documented.class);
    }

    public static boolean isInherited(Class<? extends Annotation> annotationType) {
        return annotationType.isAnnotationPresent(Inherited.class);
    }

    public static void setValue(Annotation annotation, String annotationField, Object value) {
        Map memberValues = (Map)ReflectKit.getFieldValue((Object)Proxy.getInvocationHandler(annotation), "memberValues");
        memberValues.put(annotationField, value);
    }
}

