/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.toolkit;

import java.awt.Color;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import org.aoju.bus.core.date.DateTime;
import org.aoju.bus.core.lang.Algorithm;
import org.aoju.bus.core.lang.Fields;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.toolkit.ArrayKit;
import org.aoju.bus.core.toolkit.CollKit;
import org.aoju.bus.core.toolkit.DateKit;
import org.aoju.bus.core.toolkit.MathKit;
import org.aoju.bus.core.toolkit.StringKit;

public class RandomKit {
    public static ThreadLocalRandom getRandom() {
        return ThreadLocalRandom.current();
    }

    public static Random getRandom(boolean isSecure) {
        return isSecure ? RandomKit.getSecureRandom() : RandomKit.getRandom();
    }

    public static SecureRandom getSecureRandom() {
        return RandomKit.getSecureRandom(null);
    }

    public static SecureRandom getSecureRandom(byte[] seed) {
        SecureRandom random;
        if (null == seed) {
            return new SecureRandom();
        }
        try {
            random = SecureRandom.getInstance(Algorithm.SHA1PRNG.getValue());
        }
        catch (NoSuchAlgorithmException e) {
            throw new InstrumentException(e);
        }
        if (null != seed) {
            random.setSeed(seed);
        }
        return random;
    }

    public static int randomInt(int min, int max) {
        return RandomKit.getRandom().nextInt(min, max);
    }

    public static int randomInt() {
        return RandomKit.getRandom().nextInt();
    }

    public static int randomInt(int limit) {
        return RandomKit.getRandom().nextInt(limit);
    }

    public static long randomLong(long min, long max) {
        return RandomKit.getRandom().nextLong(min, max);
    }

    public static long randomLong() {
        return RandomKit.getRandom().nextLong();
    }

    public static long randomLong(long limit) {
        return RandomKit.getRandom().nextLong(limit);
    }

    public static double randomDouble(double min, double max) {
        return RandomKit.getRandom().nextDouble(min, max);
    }

    public static double randomDouble(double min, double max, int scale, RoundingMode roundingMode) {
        return MathKit.round(RandomKit.randomDouble(min, max), scale, roundingMode).doubleValue();
    }

    public static double randomDouble() {
        return RandomKit.getRandom().nextDouble();
    }

    public static double randomDouble(int scale, RoundingMode roundingMode) {
        return MathKit.round(RandomKit.randomDouble(), scale, roundingMode).doubleValue();
    }

    public static double randomDouble(double limit) {
        return RandomKit.getRandom().nextDouble(limit);
    }

    public static double randomDouble(double limit, int scale, RoundingMode roundingMode) {
        return MathKit.round(RandomKit.randomDouble(limit), scale, roundingMode).doubleValue();
    }

    public static BigDecimal randomBigDecimal() {
        return MathKit.toBigDecimal(RandomKit.getRandom().nextDouble());
    }

    public static BigDecimal randomBigDecimal(BigDecimal limit) {
        return MathKit.toBigDecimal(RandomKit.getRandom().nextDouble(limit.doubleValue()));
    }

    public static BigDecimal randomBigDecimal(BigDecimal min, BigDecimal max) {
        return MathKit.toBigDecimal(RandomKit.getRandom().nextDouble(min.doubleValue(), max.doubleValue()));
    }

    public static byte[] randomBytes(int length) {
        byte[] bytes = new byte[length];
        RandomKit.getRandom().nextBytes(bytes);
        return bytes;
    }

    public static <T> T randomEle(List<T> list) {
        return RandomKit.randomEle(list, list.size());
    }

    public static <T> T randomEle(List<T> list, int limit) {
        if (list.size() < limit) {
            limit = list.size();
        }
        return list.get(RandomKit.randomInt(limit));
    }

    public static <T> T randomEle(T[] array) {
        return RandomKit.randomEle(array, array.length);
    }

    public static <T> T randomEle(T[] array, int limit) {
        return array[RandomKit.randomInt(limit)];
    }

    public static <T> List<T> randomEles(List<T> list, int count) {
        ArrayList<T> result = new ArrayList<T>(count);
        int limit = list.size();
        while (result.size() < count) {
            result.add(RandomKit.randomEle(list, limit));
        }
        return result;
    }

    public static <T> List<T> randomEleList(List<T> source, int count) {
        if (count >= source.size()) {
            return CollKit.toList(source);
        }
        int[] randomList = ArrayKit.sub(RandomKit.randomInts(source.size()), 0, count);
        ArrayList<T> result = new ArrayList<T>();
        for (int e : randomList) {
            result.add(source.get(e));
        }
        return result;
    }

    public static <T> Set<T> randomEleSet(Collection<T> collection, int count) {
        ArrayList<T> source = new ArrayList<T>(new HashSet<T>(collection));
        if (count > source.size()) {
            throw new IllegalArgumentException("Count is larger than collection distinct size !");
        }
        LinkedHashSet<T> result = new LinkedHashSet<T>(count);
        int limit = collection.size();
        while (result.size() < count) {
            result.add(RandomKit.randomEle(source, limit));
        }
        return result;
    }

    public static String randomString(int length) {
        return RandomKit.randomString("abcdefghijklmnopqrstuvwxyz0123456789", length);
    }

    public static String randomStringUpper(int length) {
        return RandomKit.randomString("abcdefghijklmnopqrstuvwxyz0123456789", length).toUpperCase();
    }

    public static int[] randomInts(int length) {
        int[] list = ArrayKit.range(length);
        for (int i = 0; i < length; ++i) {
            int random = RandomKit.randomInt(i, length);
            ArrayKit.swap(list, i, random);
        }
        return list;
    }

    public static String randomNumbers(int length) {
        return RandomKit.randomString("0123456789", length);
    }

    public static String randomString(String text, int length) {
        if (StringKit.isEmpty(text)) {
            return "";
        }
        StringBuilder sb = new StringBuilder(length);
        if (length < 1) {
            length = 1;
        }
        int baseLength = text.length();
        for (int i = 0; i < length; ++i) {
            int number = RandomKit.randomInt(baseLength);
            sb.append(text.charAt(number));
        }
        return sb.toString();
    }

    public static int randomNumber() {
        return RandomKit.randomChar("0123456789");
    }

    public static char randomChar() {
        return RandomKit.randomChar("abcdefghijklmnopqrstuvwxyz0123456789");
    }

    public static char randomChar(String baseString) {
        return baseString.charAt(RandomKit.getRandom().nextInt(baseString.length()));
    }

    public static Color randomColor() {
        ThreadLocalRandom random = RandomKit.getRandom();
        return new Color(((Random)random).nextInt(256), ((Random)random).nextInt(256), ((Random)random).nextInt(256));
    }

    public static DateTime randomDay(int min, int max) {
        return RandomKit.randomDate(DateKit.date(), Fields.Type.DAY_OF_YEAR, min, max);
    }

    public static DateTime randomDate(Date baseDate, Fields.Type type, int min, int max) {
        if (null == baseDate) {
            baseDate = DateKit.date();
        }
        return DateKit.offset(baseDate, type, RandomKit.randomInt(min, max));
    }

    public static boolean randomBoolean() {
        return 0 == RandomKit.randomInt(2);
    }

    public static char randomChinese() {
        return (char)RandomKit.randomInt(19968, 40959);
    }
}

