/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.toolkit;

import java.io.StringReader;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import org.aoju.bus.core.lang.Charset;
import org.aoju.bus.core.lang.Normal;
import org.aoju.bus.core.lang.RegEx;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.text.Similarity;
import org.aoju.bus.core.text.TextBuilder;
import org.aoju.bus.core.toolkit.ArrayKit;
import org.aoju.bus.core.toolkit.CharsKit;
import org.aoju.bus.core.toolkit.HexKit;
import org.aoju.bus.core.toolkit.MapKit;
import org.aoju.bus.core.toolkit.ObjectKit;

public class StringKit
extends CharsKit {
    public static boolean isBlank(Object obj) {
        if (null == obj) {
            return true;
        }
        if (obj instanceof CharSequence) {
            return CharsKit.isBlank((CharSequence)obj);
        }
        return false;
    }

    public static String[] trim(String[] array) {
        if (ArrayKit.isEmpty(array)) {
            return array;
        }
        String[] resultArray = new String[array.length];
        for (int i = 0; i < array.length; ++i) {
            String param = array[i];
            resultArray[i] = CharsKit.trim(param);
        }
        return resultArray;
    }

    public static String trimToEmpty(String text) {
        return null == text ? "" : text.trim();
    }

    public static boolean emptyIfString(Object obj) {
        if (null == obj) {
            return true;
        }
        if (obj instanceof CharSequence) {
            return 0 == ((CharSequence)obj).length();
        }
        return false;
    }

    public static boolean areNotEmpty(String ... values) {
        boolean result = true;
        if (null != values && values.length != 0) {
            String[] var2 = values;
            int var3 = values.length;
            for (int var4 = 0; var4 < var3; ++var4) {
                String value = var2[var4];
                result &= !CharsKit.isEmpty(value);
            }
        } else {
            result = false;
        }
        return result;
    }

    public static String toString(Object obj) {
        return StringKit.toString(obj, Charset.UTF_8);
    }

    public static String toString(Object obj, String charset) {
        return StringKit.toString(obj, java.nio.charset.Charset.forName(charset));
    }

    public static String toString(String text, String defaultStr) {
        return null == text ? defaultStr : text;
    }

    public static String toString(Object obj, java.nio.charset.Charset charset) {
        if (ObjectKit.isEmpty(obj)) {
            return null;
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof byte[]) {
            return StringKit.toString((byte[])obj, charset);
        }
        if (obj instanceof Byte[]) {
            return StringKit.toString((Byte[])obj, charset);
        }
        if (obj instanceof ByteBuffer) {
            return StringKit.toString((ByteBuffer)obj, charset);
        }
        if (ArrayKit.isArray(obj)) {
            return ArrayKit.toString(obj);
        }
        return obj.toString();
    }

    public static String toString(byte[] bytes, String charset) {
        return StringKit.toString(bytes, Charset.charset(charset));
    }

    public static String toString(byte[] data, java.nio.charset.Charset charset) {
        if (null == data) {
            return null;
        }
        if (null == charset) {
            return new String(data);
        }
        return new String(data, charset);
    }

    public static String toString(Byte[] bytes, String charset) {
        return StringKit.toString(bytes, Charset.charset(charset));
    }

    public static String toString(Byte[] data, java.nio.charset.Charset charset) {
        if (null == data) {
            return null;
        }
        byte[] bytes = new byte[data.length];
        for (int i = 0; i < data.length; ++i) {
            Byte dataByte = data[i];
            bytes[i] = null == dataByte ? -1 : (int)dataByte.byteValue();
        }
        return StringKit.toString(bytes, charset);
    }

    public static String toString(ByteBuffer data, String charset) {
        if (null == data) {
            return null;
        }
        return StringKit.toString(data, java.nio.charset.Charset.forName(charset));
    }

    public static String toString(ByteBuffer data, java.nio.charset.Charset charset) {
        if (null == charset) {
            charset = java.nio.charset.Charset.defaultCharset();
        }
        return charset.decode(data).toString();
    }

    public static String toString(String[] values) {
        if (ArrayKit.isEmpty(values)) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (String value : values) {
            builder.append("," + value);
        }
        String parameter = builder.toString().trim();
        if (parameter.length() > 0) {
            return parameter.substring(1);
        }
        return "";
    }

    public static String toString(Class<?>[] parameterTypes) {
        if (ArrayKit.isEmpty(parameterTypes)) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (Class<?> clazz : parameterTypes) {
            builder.append("," + clazz.getCanonicalName());
        }
        String parameter = builder.toString().trim();
        if (parameter.length() > 0) {
            return parameter.substring(1);
        }
        return "";
    }

    public static String toStringOrNull(Object obj) {
        return null == obj ? null : obj.toString();
    }

    public static boolean hasText(String text) {
        if (null == text || text.isEmpty()) {
            return false;
        }
        int strLen = text.length();
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(text.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean hasLength(String text) {
        return null != text && !text.isEmpty();
    }

    public static byte[] base64ToByte(String text) {
        try {
            if (null == text) {
                return null;
            }
            return Base64.getDecoder().decode(text);
        }
        catch (Exception e) {
            throw new InstrumentException(e);
        }
    }

    public static String base64ToString(String text) {
        try {
            if (null == text) {
                return null;
            }
            return new String(StringKit.base64ToByte(text), Charset.UTF_8);
        }
        catch (Exception e) {
            throw new InstrumentException(e);
        }
    }

    public static String base64ToString(String text, String charset) {
        try {
            if (null == text) {
                return null;
            }
            return new String(StringKit.base64ToByte(text), charset);
        }
        catch (Exception e) {
            throw new InstrumentException(e);
        }
    }

    public static String byteArrayToHex(byte[] byteArray) {
        char[] resultCharArray = new char[byteArray.length * 2];
        int index = 0;
        for (byte b : byteArray) {
            resultCharArray[index++] = Normal.DIGITS_16_LOWER[b >>> 4 & 0xF];
            resultCharArray[index++] = Normal.DIGITS_16_LOWER[b & 0xF];
        }
        return new String(resultCharArray);
    }

    public static byte[] hexStringToByte(String hexText) {
        if (CharsKit.isEmpty(hexText)) {
            return Normal.EMPTY_BYTE_ARRAY;
        }
        int len = hexText.length();
        if (!RegEx.VALID_HEX.matcher(hexText).matches() || (len & 1) != 0) {
            return Normal.EMPTY_BYTE_ARRAY;
        }
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)(Character.digit(hexText.charAt(i), 16) << 4 | Character.digit(hexText.charAt(i + 1), 16));
        }
        return data;
    }

    public static String toUnicode(char c) {
        return HexKit.toUnicodeHex(c);
    }

    public static String toUnicode(int c) {
        return HexKit.toUnicodeHex(c);
    }

    public static String toUnicode(String text) {
        return StringKit.toUnicode(text, true);
    }

    public static String toUnicode(String text, boolean isSkipAscii) {
        if (StringKit.isEmpty(text)) {
            return text;
        }
        int len = text.length();
        StringBuilder unicode = new StringBuilder(text.length() * 6);
        for (int i = 0; i < len; ++i) {
            char c = text.charAt(i);
            if (isSkipAscii && CharsKit.isAsciiPrintable(c)) {
                unicode.append(c);
                continue;
            }
            unicode.append(HexKit.toUnicodeHex(c));
        }
        return unicode.toString();
    }

    public static String toUnicodeString(String text) {
        int i;
        if (StringKit.isBlank(text)) {
            return text;
        }
        int len = text.length();
        StringBuilder sb = new StringBuilder(len);
        int pos = 0;
        while ((i = StringKit.indexOfIgnoreCase(text, "\\u", pos)) != -1) {
            sb.append(text, pos, i);
            pos = i;
            if (i + 5 >= len) break;
            try {
                char c = (char)Integer.parseInt(text.substring(i + 2, i + 6), 16);
                sb.append(c);
                pos = i + 6;
            }
            catch (NumberFormatException e) {
                sb.append(text, pos, i + 2);
                pos = i + 2;
            }
        }
        if (pos < len) {
            sb.append(text, pos, len);
        }
        return sb.toString();
    }

    public static String sub(String input, int fromIndex, int length) {
        return CharsKit.sub(input, fromIndex, fromIndex + length);
    }

    public static String split(String text) {
        return StringKit.split(text, ",", ",");
    }

    public static String split(String text, String separator, String reserve) {
        StringBuffer sb = new StringBuffer();
        if (CharsKit.isNotEmpty(text)) {
            String[] arr = CharsKit.splitToArray((CharSequence)text, separator);
            for (int i = 0; i < arr.length; ++i) {
                if (i == 0) {
                    sb.append("'").append(arr[i]).append("'");
                    continue;
                }
                sb.append(reserve).append("'").append(arr[i]).append("'");
            }
        }
        return sb.toString();
    }

    public static String left(String text, int len) {
        if (null == text) {
            return null;
        }
        if (len < 0) {
            return "";
        }
        if (text.length() <= len) {
            return text;
        }
        return text.substring(0, len);
    }

    public static String right(String text, int len) {
        if (null == text) {
            return null;
        }
        if (len < 0) {
            return "";
        }
        if (text.length() <= len) {
            return text;
        }
        return text.substring(text.length() - len);
    }

    public static String mid(String text, int pos, int len) {
        if (null == text) {
            return null;
        }
        if (len < 0 || pos > text.length()) {
            return "";
        }
        if (pos < 0) {
            pos = 0;
        }
        if (text.length() <= pos + len) {
            return text.substring(pos);
        }
        return text.substring(pos, pos + len);
    }

    public static String removeStart(String text, String remove) {
        if (CharsKit.isEmpty(text) || CharsKit.isEmpty(remove)) {
            return text;
        }
        if (text.startsWith(remove)) {
            return text.substring(remove.length());
        }
        return text;
    }

    public static String build(Object original, String middle, int prefixLength) {
        if (ObjectKit.isNull(original)) {
            return null;
        }
        String string = original.toString();
        int stringLength = string.length();
        String prefix = stringLength >= prefixLength ? string.substring(0, prefixLength) : string.substring(0, stringLength);
        String suffix = "";
        int suffixLength = stringLength - prefix.length() - middle.length();
        if (suffixLength > 0) {
            suffix = string.substring(stringLength - suffixLength);
        }
        return prefix + middle + suffix;
    }

    public static String concat(boolean isNullToEmpty, CharSequence ... texts) {
        TextBuilder sb = new TextBuilder();
        for (CharSequence text : texts) {
            sb.append(isNullToEmpty ? CharsKit.nullToEmpty(text) : text);
        }
        return sb.toString();
    }

    public static String swapCase(String text) {
        if (CharsKit.isEmpty(text)) {
            return text;
        }
        char[] buffer = text.toCharArray();
        for (int i = 0; i < buffer.length; ++i) {
            char ch = buffer[i];
            if (Character.isUpperCase(ch)) {
                buffer[i] = Character.toLowerCase(ch);
                continue;
            }
            if (Character.isTitleCase(ch)) {
                buffer[i] = Character.toLowerCase(ch);
                continue;
            }
            if (!Character.isLowerCase(ch)) continue;
            buffer[i] = Character.toUpperCase(ch);
        }
        return new String(buffer);
    }

    public static String fillBefore(String text, char filledChar, int len) {
        return StringKit.fill(text, filledChar, len, true);
    }

    public static String fillAfter(String strVal, char charVal, int len) {
        return StringKit.fill(strVal, charVal, len, false);
    }

    public static String fill(String strVal, char charVal, int len, boolean isPre) {
        int strLen = strVal.length();
        if (strLen > len) {
            return strVal;
        }
        String filled = CharsKit.repeat(charVal, len - strLen);
        return isPre ? filled.concat(strVal) : strVal.concat(filled);
    }

    public static String fill(int count, char charVal) {
        if (count < 0) {
            throw new IllegalArgumentException("count must be greater than or equal 0.");
        }
        char[] chs = new char[count];
        for (int i = 0; i < count; ++i) {
            chs[i] = charVal;
        }
        return new String(chs);
    }

    public static String fill(int count, String strVal) {
        if (count < 0) {
            throw new IllegalArgumentException("count must be greater than or equal 0.");
        }
        StringBuilder sb = new StringBuilder(count);
        for (int i = 0; i < count; ++i) {
            sb.append(strVal);
        }
        return sb.toString();
    }

    public static StringReader getReader(CharSequence text) {
        if (null == text) {
            return null;
        }
        return new StringReader(text.toString());
    }

    public static StringWriter getWriter() {
        return new StringWriter();
    }

    public static Map<String, Long> count(String text, String separator) {
        return StringKit.count(Collections.singletonList(text), separator);
    }

    public static Map<String, Long> count(String text, String separator, boolean isValueDesc) {
        return StringKit.count(Collections.singletonList(text), separator, isValueDesc);
    }

    public static Map<String, Long> count(List<String> list, String separator) {
        HashMap<String, Long> countMap = MapKit.newHashMap();
        for (String text : list) {
            String[] words;
            for (String word : words = text.split(separator)) {
                countMap.put(word, countMap.getOrDefault(word, 0L) + 1L);
            }
        }
        return countMap;
    }

    public static Map<String, Long> count(List<String> list, String separator, boolean isValueDesc) {
        return MapKit.sort(StringKit.count(list, separator), isValueDesc);
    }

    public static String cleanText(String txt) {
        if (null == txt) {
            return null;
        }
        return Pattern.compile("[`'\"|/,;()-+*%#\u00b7\u2022\ufffd\u3000\\s]").matcher(txt).replaceAll("");
    }

    public static String upperCase(String text) {
        if (null == text) {
            return null;
        }
        return text.toUpperCase();
    }

    public static String upperCase(String text, Locale locale) {
        if (null == text) {
            return null;
        }
        return text.toUpperCase(locale);
    }

    public static String lowerCase(String text) {
        if (null == text) {
            return null;
        }
        return text.toLowerCase();
    }

    public static String lowerCase(String text, Locale locale) {
        if (null == text) {
            return null;
        }
        return text.toLowerCase(locale);
    }

    public static String capitalize(String text) {
        int codepoint;
        int newCodePoint;
        int strLen;
        if (null == text || (strLen = text.length()) == 0) {
            return text;
        }
        int firstCodepoint = text.codePointAt(0);
        if (firstCodepoint == (newCodePoint = Character.toTitleCase(firstCodepoint))) {
            return text;
        }
        int[] newCodePoints = new int[strLen];
        int outOffset = 0;
        newCodePoints[outOffset++] = newCodePoint;
        for (int inOffset = Character.charCount(firstCodepoint); inOffset < strLen; inOffset += Character.charCount(codepoint)) {
            codepoint = text.codePointAt(inOffset);
            newCodePoints[outOffset++] = codepoint;
        }
        return new String(newCodePoints, 0, outOffset);
    }

    public static String unCapitalize(String text) {
        int codepoint;
        int newCodePoint;
        int strLen;
        if (null == text || (strLen = text.length()) == 0) {
            return text;
        }
        int firstCodepoint = text.codePointAt(0);
        if (firstCodepoint == (newCodePoint = Character.toLowerCase(firstCodepoint))) {
            return text;
        }
        int[] newCodePoints = new int[strLen];
        int outOffset = 0;
        newCodePoints[outOffset++] = newCodePoint;
        for (int inOffset = Character.charCount(firstCodepoint); inOffset < strLen; inOffset += Character.charCount(codepoint)) {
            codepoint = text.codePointAt(inOffset);
            newCodePoints[outOffset++] = codepoint;
        }
        return new String(newCodePoints, 0, outOffset);
    }

    public static String sort(String text) {
        if (CharsKit.isEmpty(text) || "".equalsIgnoreCase(text)) {
            return null;
        }
        char[] strArray = text.toCharArray();
        Arrays.sort(strArray);
        return String.valueOf(strArray);
    }

    public static double similar(String str1, String str2) {
        return Similarity.similar(str1, str2);
    }

    public static String similar(String str1, String str2, int scale) {
        return Similarity.similar(str1, str2, scale);
    }

    public static String newLine(String content, int length) {
        String stVal = "";
        if (length > 0) {
            if (content.length() > length) {
                int rows = (content.length() + length - 1) / length;
                for (int i = 0; i < rows; ++i) {
                    stVal = i == rows - 1 ? stVal + content.substring(i * length) : stVal + content.substring(i * length, i * length + length) + "\r\n";
                }
            } else {
                stVal = content;
            }
        }
        return stVal;
    }
}

