/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.cron.listener;

import java.util.ArrayList;
import java.util.List;
import org.aoju.bus.cron.Executor;
import org.aoju.bus.cron.listener.TaskListener;
import org.aoju.bus.logger.Logger;

public class TaskListenerManager {
    private final List<TaskListener> listeners = new ArrayList<TaskListener>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskListenerManager addListener(TaskListener listener) {
        List<TaskListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskListenerManager removeListener(TaskListener listener) {
        List<TaskListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyTaskStart(Executor executor) {
        List<TaskListener> list = this.listeners;
        synchronized (list) {
            for (TaskListener listener : this.listeners) {
                if (null == listener) continue;
                listener.onStart(executor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyTaskSucceeded(Executor executor) {
        List<TaskListener> list = this.listeners;
        synchronized (list) {
            for (TaskListener listener : this.listeners) {
                listener.onSucceeded(executor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyTaskFailed(Executor executor, Throwable exception) {
        List<TaskListener> list = this.listeners;
        synchronized (list) {
            int size = this.listeners.size();
            if (size > 0) {
                for (TaskListener listener : this.listeners) {
                    listener.onFailed(executor, exception);
                }
            } else {
                Logger.error(exception, exception.getMessage(), new Object[0]);
            }
        }
    }
}

