/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.http;

import java.net.InetSocketAddress;
import java.net.Proxy;
import org.aoju.bus.http.Address;

public final class Route {
    final Address address;
    final Proxy proxy;
    final InetSocketAddress inetSocketAddress;

    public Route(Address address, Proxy proxy, InetSocketAddress inetSocketAddress) {
        if (null == address) {
            throw new NullPointerException("address == null");
        }
        if (null == proxy) {
            throw new NullPointerException("proxy == null");
        }
        if (null == inetSocketAddress) {
            throw new NullPointerException("inetSocketAddress == null");
        }
        this.address = address;
        this.proxy = proxy;
        this.inetSocketAddress = inetSocketAddress;
    }

    public Address address() {
        return this.address;
    }

    public Proxy proxy() {
        return this.proxy;
    }

    public InetSocketAddress socketAddress() {
        return this.inetSocketAddress;
    }

    public boolean requiresTunnel() {
        return null != this.address.sslSocketFactory && this.proxy.type() == Proxy.Type.HTTP;
    }

    public boolean equals(Object other) {
        return other instanceof Route && ((Route)other).address.equals(this.address) && ((Route)other).proxy.equals(this.proxy) && ((Route)other).inetSocketAddress.equals(this.inetSocketAddress);
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.address.hashCode();
        result = 31 * result + this.proxy.hashCode();
        result = 31 * result + this.inetSocketAddress.hashCode();
        return result;
    }
}

