/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.http.magic;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.aoju.bus.core.toolkit.StreamKit;
import org.aoju.bus.http.NewCall;
import org.aoju.bus.http.magic.AbsCallback;
import org.aoju.bus.http.magic.HttpResponse;
import org.aoju.bus.logger.Logger;

public abstract class FileCallback
extends AbsCallback {
    private String fileAbsolutePath;

    public FileCallback() {
    }

    public FileCallback(String fileAbsolutePath) {
        this.fileAbsolutePath = fileAbsolutePath;
    }

    @Override
    public void onResponse(NewCall call, HttpResponse response, String id) {
        try {
            if (this.fileAbsolutePath != null && this.fileAbsolutePath.length() > 0) {
                File file = new File(this.fileAbsolutePath);
                FileOutputStream fos = new FileOutputStream(file);
                ByteArrayInputStream bis = new ByteArrayInputStream(response.body().bytes());
                StreamKit.copy(bis, fos);
                this.onSuccess(call, file, id);
            } else {
                this.onSuccess(call, response.body().byteStream(), id);
            }
        }
        catch (IOException e) {
            Logger.error(e.getMessage(), e);
        }
    }

    public void onSuccess(NewCall call, File file, String id) {
    }

    public void onSuccess(NewCall call, InputStream fileStream, String id) {
    }
}

