/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.metric;

import java.io.IOException;
import java.io.Serializable;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.toolkit.IoKit;
import org.aoju.bus.image.Device;
import org.aoju.bus.image.Dimse;
import org.aoju.bus.image.Option;
import org.aoju.bus.image.galaxy.Property;
import org.aoju.bus.image.galaxy.data.Attributes;
import org.aoju.bus.image.metric.Association;
import org.aoju.bus.image.metric.AssociationMonitor;
import org.aoju.bus.image.metric.Compatible;
import org.aoju.bus.image.metric.Connection;
import org.aoju.bus.image.metric.DimseRQHandler;
import org.aoju.bus.image.metric.PDVInputStream;
import org.aoju.bus.image.metric.StorageOptions;
import org.aoju.bus.image.metric.TransferCapability;
import org.aoju.bus.image.metric.acquire.AEExtension;
import org.aoju.bus.image.metric.internal.pdu.AAbort;
import org.aoju.bus.image.metric.internal.pdu.AAssociateAC;
import org.aoju.bus.image.metric.internal.pdu.AAssociateRQ;
import org.aoju.bus.image.metric.internal.pdu.CommonExtended;
import org.aoju.bus.image.metric.internal.pdu.ExtendedNegotiate;
import org.aoju.bus.image.metric.internal.pdu.Presentation;
import org.aoju.bus.image.metric.internal.pdu.RoleSelection;
import org.aoju.bus.logger.Logger;

public class ApplicationEntity
implements Serializable {
    private final LinkedHashSet<String> acceptedCallingAETs = new LinkedHashSet();
    private final LinkedHashSet<String> otherAETs = new LinkedHashSet();
    private final LinkedHashMap<String, String> masqueradeCallingAETs = new LinkedHashMap();
    private final List<Connection> conns = new ArrayList<Connection>(1);
    private final LinkedHashMap<String, TransferCapability> scuTCs = new LinkedHashMap();
    private final LinkedHashMap<String, TransferCapability> scpTCs = new LinkedHashMap();
    private final LinkedHashMap<Class<? extends AEExtension>, AEExtension> extensions = new LinkedHashMap();
    private Device device;
    private String aet;
    private String description;
    private byte[][] vendorData = new byte[0][];
    private String[] applicationClusters = new String[0];
    private String[] prefCalledAETs = new String[0];
    private String[] prefCallingAETs = new String[0];
    private String[] prefTransferSyntaxes = new String[0];
    private String[] supportedCharacterSets = new String[0];
    private boolean acceptor = true;
    private boolean initiator = true;
    private Boolean installed;
    private Boolean roleSelectionNegotiationLenient;
    private String hl7ApplicationName;
    private transient DimseRQHandler dimseRQHandler;

    public ApplicationEntity() {
    }

    public ApplicationEntity(String aeTitle) {
        this.setAETitle(aeTitle);
    }

    public final Device getDevice() {
        return this.device;
    }

    public void setDevice(Device device) {
        if (null != device) {
            if (null != this.device) {
                throw new IllegalStateException("already owned by " + this.device.getDeviceName());
            }
            for (Connection conn : this.conns) {
                if (conn.getDevice() == device) continue;
                throw new IllegalStateException(conn + " not owned by " + device.getDeviceName());
            }
        }
        this.device = device;
    }

    public final String getAETitle() {
        return this.aet;
    }

    public void setAETitle(String aet) {
        if (aet.isEmpty()) {
            throw new IllegalArgumentException("AE title cannot be empty");
        }
        Device device = this.device;
        if (null != device) {
            device.removeApplicationEntity(this.aet);
        }
        this.aet = aet;
        if (null != device) {
            device.addApplicationEntity(this);
        }
    }

    public final String getDescription() {
        return this.description;
    }

    public final void setDescription(String description) {
        this.description = description;
    }

    public final byte[][] getVendorData() {
        return this.vendorData;
    }

    public final void setVendorData(byte[] ... vendorData) {
        this.vendorData = vendorData;
    }

    public String[] getApplicationClusters() {
        return this.applicationClusters;
    }

    public void setApplicationClusters(String ... clusters) {
        this.applicationClusters = clusters;
    }

    public String[] getPreferredCalledAETitles() {
        return this.prefCalledAETs;
    }

    public void setPreferredCalledAETitles(String ... aets) {
        this.prefCalledAETs = aets;
    }

    public String[] getPreferredCallingAETitles() {
        return this.prefCallingAETs;
    }

    public void setPreferredCallingAETitles(String ... aets) {
        this.prefCallingAETs = aets;
    }

    public String[] getPreferredTransferSyntaxes() {
        return this.prefTransferSyntaxes;
    }

    public void setPreferredTransferSyntaxes(String ... transferSyntaxes) {
        this.prefTransferSyntaxes = Property.requireContainsNoEmpty(transferSyntaxes, "empty transferSyntax");
    }

    public String[] getAcceptedCallingAETitles() {
        return this.acceptedCallingAETs.toArray(new String[this.acceptedCallingAETs.size()]);
    }

    public void setAcceptedCallingAETitles(String ... aets) {
        this.acceptedCallingAETs.clear();
        for (String name : aets) {
            this.acceptedCallingAETs.add(name);
        }
    }

    public boolean isAcceptedCallingAETitle(String aet) {
        return this.acceptedCallingAETs.isEmpty() || this.acceptedCallingAETs.contains(aet);
    }

    public String[] getOtherAETitles() {
        return this.otherAETs.toArray(new String[this.otherAETs.size()]);
    }

    public void setOtherAETitles(String ... aets) {
        this.otherAETs.clear();
        for (String name : aets) {
            this.otherAETs.add(name);
        }
    }

    public boolean isOtherAETitle(String aet) {
        return this.otherAETs.contains(aet);
    }

    public String[] getMasqueradeCallingAETitles() {
        String[] aets = new String[this.masqueradeCallingAETs.size()];
        int i = 0;
        for (Map.Entry<String, String> entry : this.masqueradeCallingAETs.entrySet()) {
            aets[i] = entry.getKey().equals("*") ? entry.getValue() : '[' + entry.getKey() + ']' + entry.getValue();
            ++i;
        }
        return aets;
    }

    public void setMasqueradeCallingAETitles(String ... aets) {
        this.masqueradeCallingAETs.clear();
        for (String aet : aets) {
            if (aet.charAt(0) == '[') {
                int end = aet.indexOf(93);
                if (end <= 0) continue;
                this.masqueradeCallingAETs.put(aet.substring(1, end), aet.substring(end + 1));
                continue;
            }
            this.masqueradeCallingAETs.put("*", aet);
        }
    }

    public String getCallingAETitle(String calledAET) {
        String callingAET = this.masqueradeCallingAETs.get(calledAET);
        if (null == callingAET && null == (callingAET = this.masqueradeCallingAETs.get("*"))) {
            callingAET = this.aet;
        }
        return callingAET;
    }

    public boolean isMasqueradeCallingAETitle(String calledAET) {
        return this.masqueradeCallingAETs.containsKey(calledAET) || this.masqueradeCallingAETs.containsKey("*");
    }

    public String[] getSupportedCharacterSets() {
        return this.supportedCharacterSets;
    }

    public void setSupportedCharacterSets(String ... characterSets) {
        this.supportedCharacterSets = characterSets;
    }

    public final boolean isAssociationAcceptor() {
        return this.acceptor;
    }

    public final void setAssociationAcceptor(boolean acceptor) {
        this.acceptor = acceptor;
    }

    public final boolean isAssociationInitiator() {
        return this.initiator;
    }

    public final void setAssociationInitiator(boolean initiator) {
        this.initiator = initiator;
    }

    public boolean isInstalled() {
        return null != this.device && this.device.isInstalled() && (null == this.installed || this.installed != false);
    }

    public final Boolean getInstalled() {
        return this.installed;
    }

    public void setInstalled(Boolean installed) {
        this.installed = installed;
    }

    public boolean isRoleSelectionNegotiationLenient() {
        return null != this.roleSelectionNegotiationLenient ? this.roleSelectionNegotiationLenient : null != this.device && this.device.isRoleSelectionNegotiationLenient();
    }

    public final Boolean getRoleSelectionNegotiationLenient() {
        return this.roleSelectionNegotiationLenient;
    }

    public void setRoleSelectionNegotiationLenient(Boolean installed) {
        this.roleSelectionNegotiationLenient = this.roleSelectionNegotiationLenient;
    }

    public String getHl7ApplicationName() {
        return this.hl7ApplicationName;
    }

    public void setHl7ApplicationName(String hl7ApplicationName) {
        this.hl7ApplicationName = hl7ApplicationName;
    }

    public DimseRQHandler getDimseRQHandler() {
        DimseRQHandler handler = this.dimseRQHandler;
        if (null != handler) {
            return handler;
        }
        Device device = this.device;
        return null != device ? device.getDimseRQHandler() : null;
    }

    public final void setDimseRQHandler(DimseRQHandler dimseRQHandler) {
        this.dimseRQHandler = dimseRQHandler;
    }

    private void checkInstalled() {
        if (!this.isInstalled()) {
            throw new IllegalStateException("Not installed");
        }
    }

    private void checkDevice() {
        if (null == this.device) {
            throw new IllegalStateException("Not attached to Device");
        }
    }

    void onDimseRQ(Association as, Presentation pc, Dimse cmd, Attributes cmdAttrs, PDVInputStream data) throws IOException {
        DimseRQHandler tmp = this.getDimseRQHandler();
        if (null == tmp) {
            Logger.error("DimseRQHandler not initalized", new Object[0]);
            throw new AAbort();
        }
        tmp.onDimse(as, pc, cmd, cmdAttrs, data);
    }

    public void addConnection(Connection conn) {
        if (conn.getProtocol() != Connection.Protocol.DICOM) {
            throw new IllegalArgumentException("protocol != DICOM - " + (Object)((Object)conn.getProtocol()));
        }
        if (null != this.device && this.device != conn.getDevice()) {
            throw new IllegalStateException(conn + " not contained by Device: " + this.device.getDeviceName());
        }
        this.conns.add(conn);
    }

    public boolean removeConnection(Connection conn) {
        return this.conns.remove(conn);
    }

    public List<Connection> getConnections() {
        return this.conns;
    }

    public TransferCapability addTransferCapability(TransferCapability tc) {
        tc.setApplicationEntity(this);
        TransferCapability prev = (tc.getRole() == TransferCapability.Role.SCU ? this.scuTCs : this.scpTCs).put(tc.getSopClass(), tc);
        if (null != prev && prev != tc) {
            prev.setApplicationEntity(null);
        }
        return prev;
    }

    public TransferCapability removeTransferCapabilityFor(String sopClass, TransferCapability.Role role) {
        TransferCapability tc = (TransferCapability)(role == TransferCapability.Role.SCU ? this.scuTCs : this.scpTCs).remove(sopClass);
        if (null != tc) {
            tc.setApplicationEntity(null);
        }
        return tc;
    }

    public Collection<TransferCapability> getTransferCapabilities() {
        ArrayList<TransferCapability> tcs = new ArrayList<TransferCapability>(this.scuTCs.size() + this.scpTCs.size());
        tcs.addAll(this.scpTCs.values());
        tcs.addAll(this.scuTCs.values());
        return tcs;
    }

    public Collection<TransferCapability> getTransferCapabilitiesWithRole(TransferCapability.Role role) {
        return (role == TransferCapability.Role.SCU ? this.scuTCs : this.scpTCs).values();
    }

    public TransferCapability getTransferCapabilityFor(String sopClass, TransferCapability.Role role) {
        return (role == TransferCapability.Role.SCU ? this.scuTCs : this.scpTCs).get(sopClass);
    }

    protected Presentation negotiate(AAssociateRQ rq, AAssociateAC ac, Presentation rqpc) {
        String as = rqpc.getAbstractSyntax();
        TransferCapability tc = this.roleSelection(rq, ac, as);
        int pcid = rqpc.getPCID();
        if (null == tc) {
            return new Presentation(pcid, 3, rqpc.getTransferSyntax());
        }
        String ts = tc.selectTransferSyntax(rqpc.getTransferSyntaxes());
        if (null == ts) {
            return new Presentation(pcid, 4, rqpc.getTransferSyntax());
        }
        byte[] info = this.negotiate(rq.getExtNegotiationFor(as), tc);
        if (null != info) {
            ac.addExtendedNegotiate(new ExtendedNegotiate(as, info));
        }
        return new Presentation(pcid, 0, ts);
    }

    private TransferCapability roleSelection(AAssociateRQ rq, AAssociateAC ac, String asuid) {
        RoleSelection rqrs = rq.getRoleSelectionFor(asuid);
        if (null == rqrs) {
            return this.getTC(this.scpTCs, asuid, rq);
        }
        RoleSelection acrs = ac.getRoleSelectionFor(asuid);
        if (null != acrs) {
            return this.getTC(acrs.isSCU() ? this.scpTCs : this.scuTCs, asuid, rq);
        }
        TransferCapability tcscu = null;
        TransferCapability tcscp = null;
        boolean scu = rqrs.isSCU() && null != (tcscp = this.getTC(this.scpTCs, asuid, rq));
        boolean scp = rqrs.isSCP() && null != (tcscu = this.getTC(this.scuTCs, asuid, rq));
        ac.addRoleSelection(new RoleSelection(asuid, scu, scp));
        return scu ? tcscp : tcscu;
    }

    private TransferCapability getTC(Map<String, TransferCapability> tcs, String asuid, AAssociateRQ rq) {
        TransferCapability tc = tcs.get(asuid);
        if (null != tc) {
            return tc;
        }
        CommonExtended commonExtNeg = rq.getCommonExtendedNegotiationFor(asuid);
        if (null != commonExtNeg) {
            for (String cuid : commonExtNeg.getRelatedGeneralSOPClassUIDs()) {
                tc = tcs.get(cuid);
                if (null == tc) continue;
                return tc;
            }
            tc = tcs.get(commonExtNeg.getServiceClassUID());
            if (null != tc) {
                return tc;
            }
        }
        return tcs.get("*");
    }

    private byte[] negotiate(ExtendedNegotiate exneg, TransferCapability tc) {
        if (null == exneg) {
            return null;
        }
        StorageOptions storageOptions = tc.getStorageOptions();
        if (null != storageOptions) {
            return storageOptions.toExtendedNegotiationInformation();
        }
        EnumSet<Option.Type> types = tc.getTypes();
        if (null != types) {
            EnumSet<Option.Type> commonOpts = Option.Type.toOptions(exneg);
            commonOpts.retainAll(types);
            return Option.Type.toExtendedNegotiationInformation(commonOpts);
        }
        return null;
    }

    public Association connect(Connection local, Connection remote, AAssociateRQ rq) throws IOException, InterruptedException, InstrumentException, GeneralSecurityException {
        this.checkDevice();
        this.checkInstalled();
        if (null == rq.getCallingAET()) {
            rq.setCallingAET(this.getCallingAETitle(rq.getCalledAET()));
        }
        rq.setMaxOpsInvoked(local.getMaxOpsInvoked());
        rq.setMaxOpsPerformed(local.getMaxOpsPerformed());
        rq.setMaxPDULength(local.getReceivePDULength());
        Socket sock = local.connect(remote);
        AssociationMonitor monitor = this.device.getAssociationMonitor();
        Association as = null;
        try {
            as = new Association(this, local, sock);
            as.write(rq);
            as.waitForLeaving(Association.State.Sta5);
            if (null != monitor) {
                monitor.onAssociationEstablished(as);
            }
            return as;
        }
        catch (IOException | InterruptedException e) {
            IoKit.close(sock);
            if (null != as && null != monitor) {
                monitor.onAssociationFailed(as, e);
            }
            throw e;
        }
    }

    public Association connect(Connection remote, AAssociateRQ rq) throws IOException, InterruptedException, InstrumentException, GeneralSecurityException {
        return this.connect(this.findCompatibleConnection(remote), remote, rq);
    }

    public Connection findCompatibleConnection(Connection remoteConn) throws InstrumentException {
        for (Connection conn : this.conns) {
            if (!conn.isInstalled() || !conn.isCompatible(remoteConn)) continue;
            return conn;
        }
        throw new InstrumentException("No compatible connection to " + remoteConn + " available on " + this.aet);
    }

    public Compatible findCompatibleConnection(ApplicationEntity remote) throws InstrumentException {
        for (Connection remoteConn : remote.conns) {
            if (!remoteConn.isInstalled() || !remoteConn.isServer()) continue;
            for (Connection conn : this.conns) {
                if (!conn.isInstalled() || !conn.isCompatible(remoteConn)) continue;
                return new Compatible(conn, remoteConn);
            }
        }
        throw new InstrumentException("No compatible connection to " + remote.getAETitle() + " available on " + this.aet);
    }

    public Association connect(ApplicationEntity remote, AAssociateRQ rq) throws IOException, InterruptedException, InstrumentException, GeneralSecurityException {
        Compatible cc = this.findCompatibleConnection(remote);
        if (null == rq.getCalledAET()) {
            rq.setCalledAET(remote.getAETitle());
        }
        return this.connect(cc.getLocalConnection(), cc.getRemoteConnection(), rq);
    }

    public String toString() {
        return this.promptTo(new StringBuilder(512), "").toString();
    }

    public StringBuilder promptTo(StringBuilder sb, String indent) {
        String indent2 = indent + " ";
        Property.appendLine(sb, indent, "ApplicationEntity[title: ", this.aet);
        Property.appendLine(sb, indent2, "desc: ", this.description);
        Property.appendLine(sb, indent2, "acceptor: ", this.acceptor);
        Property.appendLine(sb, indent2, "initiator: ", this.initiator);
        Property.appendLine(sb, indent2, "installed: ", this.getInstalled());
        for (Connection conn : this.conns) {
            conn.promptTo(sb, indent2).append(Property.LINE_SEPARATOR);
        }
        for (TransferCapability tc : this.getTransferCapabilities()) {
            tc.promptTo(sb, indent2).append(Property.LINE_SEPARATOR);
        }
        return sb.append(indent).append(']');
    }

    public void reconfigure(ApplicationEntity src) {
        this.setApplicationEntityAttributes(src);
        this.device.reconfigureConnections(this.conns, src.conns);
        this.reconfigureTransferCapabilities(src);
        this.reconfigureAEExtensions(src);
    }

    private void reconfigureTransferCapabilities(ApplicationEntity src) {
        this.scuTCs.clear();
        this.scuTCs.putAll(src.scuTCs);
        this.scpTCs.clear();
        this.scpTCs.putAll(src.scpTCs);
    }

    private void reconfigureAEExtensions(ApplicationEntity from) {
        Iterator<Class<? extends AEExtension>> it = this.extensions.keySet().iterator();
        while (it.hasNext()) {
            if (from.extensions.containsKey(it.next())) continue;
            it.remove();
        }
        for (AEExtension src : from.extensions.values()) {
            Class<?> clazz = src.getClass();
            AEExtension ext = this.extensions.get(clazz);
            if (null == ext) {
                try {
                    ext = (AEExtension)clazz.newInstance();
                    this.addAEExtension(ext);
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to instantiate " + clazz.getName(), e);
                }
            }
            ext.reconfigure(src);
        }
    }

    protected void setApplicationEntityAttributes(ApplicationEntity from) {
        this.description = from.description;
        this.vendorData = from.vendorData;
        this.applicationClusters = from.applicationClusters;
        this.prefCalledAETs = from.prefCalledAETs;
        this.prefCallingAETs = from.prefCallingAETs;
        this.acceptedCallingAETs.clear();
        this.acceptedCallingAETs.addAll(from.acceptedCallingAETs);
        this.otherAETs.clear();
        this.otherAETs.addAll(from.otherAETs);
        this.masqueradeCallingAETs.clear();
        this.masqueradeCallingAETs.putAll(from.masqueradeCallingAETs);
        this.supportedCharacterSets = from.supportedCharacterSets;
        this.prefTransferSyntaxes = from.prefTransferSyntaxes;
        this.hl7ApplicationName = from.hl7ApplicationName;
        this.acceptor = from.acceptor;
        this.initiator = from.initiator;
        this.installed = from.installed;
        this.roleSelectionNegotiationLenient = from.roleSelectionNegotiationLenient;
    }

    public void addAEExtension(AEExtension ext) {
        Class<?> clazz = ext.getClass();
        if (this.extensions.containsKey(clazz)) {
            throw new IllegalStateException("already contains AE Extension:" + clazz);
        }
        ext.setApplicationEntity(this);
        this.extensions.put(clazz, ext);
    }

    public boolean removeAEExtension(AEExtension ext) {
        if (null == this.extensions.remove(ext.getClass())) {
            return false;
        }
        ext.setApplicationEntity(null);
        return true;
    }

    public Collection<AEExtension> listAEExtensions() {
        return this.extensions.values();
    }

    public <T extends AEExtension> T getAEExtension(Class<T> clazz) {
        return (T)this.extensions.get(clazz);
    }

    public <T extends AEExtension> T getAEExtensionNotNull(Class<T> clazz) {
        T aeExt = this.getAEExtension(clazz);
        if (null == aeExt) {
            throw new IllegalStateException("No " + clazz.getName() + " configured for AE: " + this.aet);
        }
        return aeExt;
    }
}

