/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.metric;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import org.aoju.bus.image.Device;
import org.aoju.bus.image.metric.Connection;
import org.aoju.bus.image.metric.KeycloakClient;

public class WebApplication {
    private final List<Connection> conns = new ArrayList<Connection>(1);
    private final EnumSet<ServiceClass> serviceClasses = EnumSet.noneOf(ServiceClass.class);
    private Device device;
    private String applicationName;
    private String description;
    private String servicePath;
    private String aeTitle;
    private String[] applicationClusters = new String[0];
    private String keycloakClientID;
    private Boolean installed;

    public WebApplication() {
    }

    public WebApplication(String applicationName) {
        this.applicationName = applicationName;
    }

    public Device getDevice() {
        return this.device;
    }

    public void setDevice(Device device) {
        if (null != device) {
            if (null != this.device) {
                throw new IllegalStateException("already owned by " + this.device.getDeviceName());
            }
            for (Connection conn : this.conns) {
                if (conn.getDevice() == device) continue;
                throw new IllegalStateException(conn + " not owned by " + device.getDeviceName());
            }
        }
        this.device = device;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String name) {
        if (name.isEmpty()) {
            throw new IllegalArgumentException("name cannot be empty");
        }
        Device device = this.device;
        if (null != device) {
            device.removeWebApplication(this.applicationName);
        }
        this.applicationName = name;
        if (null != device) {
            device.addWebApplication(this);
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getServicePath() {
        return this.servicePath;
    }

    public void setServicePath(String servicePath) {
        this.servicePath = servicePath.startsWith("/") ? servicePath : '/' + servicePath;
    }

    public String getAETitle() {
        return this.aeTitle;
    }

    public void setAETitle(String aeTitle) {
        this.aeTitle = aeTitle;
    }

    public String[] getApplicationClusters() {
        return this.applicationClusters;
    }

    public void setApplicationClusters(String ... applicationClusters) {
        this.applicationClusters = applicationClusters;
    }

    public String getKeycloakClientID() {
        return this.keycloakClientID;
    }

    public void setKeycloakClientID(String keycloakClientID) {
        this.keycloakClientID = keycloakClientID;
    }

    public boolean isInstalled() {
        return null != this.device && this.device.isInstalled() && (null == this.installed || this.installed != false);
    }

    public final Boolean getInstalled() {
        return this.installed;
    }

    public void setInstalled(Boolean installed) {
        if (null != installed && installed.booleanValue() && null != this.device && !this.device.isInstalled()) {
            throw new IllegalStateException("owning device not installed");
        }
        this.installed = installed;
    }

    public KeycloakClient getKeycloakClient() {
        return null != this.keycloakClientID ? this.device.getKeycloakClient(this.keycloakClientID) : null;
    }

    public void addConnection(Connection conn) {
        if (conn.getProtocol() != Connection.Protocol.HTTP) {
            throw new IllegalArgumentException("Web Application does not support protocol " + (Object)((Object)conn.getProtocol()));
        }
        if (null != this.device && this.device != conn.getDevice()) {
            throw new IllegalStateException(conn + " not contained by " + this.device.getDeviceName());
        }
        this.conns.add(conn);
    }

    public StringBuilder getServiceURL() {
        return this.getServiceURL(this.firstInstalledConnection());
    }

    private Connection firstInstalledConnection() {
        for (Connection conn : this.conns) {
            if (!conn.isInstalled()) continue;
            return conn;
        }
        throw new IllegalStateException("No installed Network Connection");
    }

    public StringBuilder getServiceURL(Connection conn) {
        return new StringBuilder(64).append(conn.isTls() ? "https://" : "http://").append(conn.getHostname()).append(':').append(conn.getPort()).append(this.servicePath);
    }

    public boolean removeConnection(Connection conn) {
        return this.conns.remove(conn);
    }

    public List<Connection> getConnections() {
        return this.conns;
    }

    public ServiceClass[] getServiceClasses() {
        return this.serviceClasses.toArray(new ServiceClass[0]);
    }

    public void setServiceClasses(ServiceClass ... serviceClasses) {
        this.serviceClasses.clear();
        this.serviceClasses.addAll(Arrays.asList(serviceClasses));
    }

    public boolean containsServiceClass(ServiceClass serviceClass) {
        return this.serviceClasses.contains((Object)serviceClass);
    }

    public void reconfigure(WebApplication src) {
        this.description = src.description;
        this.servicePath = src.servicePath;
        this.aeTitle = src.aeTitle;
        this.applicationClusters = src.applicationClusters;
        this.keycloakClientID = src.keycloakClientID;
        this.installed = src.installed;
        this.serviceClasses.clear();
        this.serviceClasses.addAll(src.serviceClasses);
        this.device.reconfigureConnections(this.conns, src.conns);
    }

    public String toString() {
        return "WebApplication[name=" + this.applicationName + ",classes=" + this.serviceClasses + ",path=" + this.servicePath + ",aet=" + this.aeTitle + ']';
    }

    public static enum ServiceClass {
        WADO_URI,
        WADO_RS,
        STOW_RS,
        QIDO_RS,
        UPS_RS,
        AOJU_ARC,
        AOJU_ARC_AET;

    }
}

